/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.evh;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.dispatcher.AbstractEventHandler;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandlerException;
import com.streamscape.service.osf.evh.IllegalHandlerStateException;

public class EventHandler
extends AbstractEventHandler {
    private String methodName = "";
    private String handlerName = "";
    private String requestEventId = "";
    private String requestSemanticType = "Null";
    private String requestSelector = null;
    private String requestSDRPath = null;
    private String responseEventId = "";
    private String responseSemanticType = "Void";
    private InvokeMode invokeMode = InvokeMode.ASYNC;
    private long timeout = 0L;
    private transient AbstractServiceConfigurationObject sco = null;
    private static final String NULL_TYPE = "Null";
    private static final String VOID_TYPE = "Void";

    public EventHandler() {
    }

    public EventHandler(AbstractServiceConfigurationObject sco, String methodName, String handlerName) {
        this.setMethodName(methodName);
        this.setHandlerName(handlerName);
        this.sco = sco;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public InvokeMode getInvokeMode() {
        return this.invokeMode;
    }

    public void setInvokeMode(InvokeMode mode) {
        this.invokeMode = mode;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getHandlerName() {
        return this.handlerName;
    }

    public void setHandlerName(String name) {
        this.handlerName = name;
    }

    public String getRequestEventId() {
        return this.requestEventId;
    }

    public String getRequestSelector() {
        return this.requestSelector;
    }

    public void setRequestSelector(String selector) {
        this.requestSelector = selector;
    }

    public String getRequestSDRPath() {
        return this.requestSDRPath;
    }

    public void setRequestSDRPath(String path) {
        this.requestSDRPath = path;
    }

    public String getRequestObjectClass() {
        String className = RuntimeContext.getInstance().getSemanticTypeCache().resolveSemanticType(this.requestSemanticType);
        if (className == null) {
            throw new RuntimeException("Unable to resolve class name for '" + this.requestSemanticType + "' semantic type.");
        }
        return className;
    }

    public String getRequestSemanticType() {
        return this.requestSemanticType;
    }

    public boolean isRequestBound() {
        return this.requestEventId != null && this.requestEventId.length() > 0;
    }

    public String getResponseEventId() {
        return this.responseEventId;
    }

    public String getResponseObjectClass() {
        String className = RuntimeContext.getInstance().getSemanticTypeCache().resolveSemanticType(this.responseSemanticType);
        if (className == null) {
            throw new RuntimeException("Unable to resolve class name for '" + this.responseSemanticType + "' semantic type.");
        }
        return className;
    }

    public String getResponseSemanticType() {
        return this.responseSemanticType;
    }

    public boolean isResponseBound() {
        return this.responseEventId != null && this.responseEventId.length() > 0;
    }

    public void bindRequestObject(String eventId, SemanticType type) throws EventHandlerException {
        if (eventId == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event id specified.", new String[0]));
        }
        if (type == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null semantic type specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new EventHandlerException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        if (!type.isValid()) {
            throw new EventHandlerException(ErrorMessages.format("Semantic Integrity Exception: Semantic Type '%1$s' is invalid and may not be used.", type.getTypeName()));
        }
        this.assertStateRequest();
        this.requestEventId = eventId;
        this.requestSemanticType = type.getTypeName();
    }

    public void bindRequestObject(String eventId, String type) throws EventHandlerException {
        if (eventId == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event id specified.", new String[0]));
        }
        if (type == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null semantic type specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new EventHandlerException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        this.assertStateRequest();
        this.requestEventId = eventId;
        this.requestSemanticType = type;
    }

    public void bindVoidRequestObject(String eventId) throws EventHandlerException {
        if (eventId == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event id specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new EventHandlerException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        this.assertStateRequest();
        this.requestEventId = eventId;
        this.requestSemanticType = VOID_TYPE;
    }

    public void bindRequestEvent(ImmutableEventDatagram event) throws EventHandlerException {
        if (event == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event datagram specified.", new String[0]));
        }
        this.assertStateRequest();
        this.requestEventId = event.getEventId();
        this.requestSemanticType = RuntimeContext.getInstance().getSemanticTypeCache().resolveSemanticClass(event.getClass());
    }

    public void unbindRequest() {
        this.requestEventId = "";
        this.requestSemanticType = null;
    }

    public void bindResponseObject(String eventId, SemanticType type) throws EventHandlerException, ServiceConfigurationException {
        if (eventId == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event id specified.", new String[0]));
        }
        if (type == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null semantic type specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new EventHandlerException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        if (!type.isValid()) {
            throw new EventHandlerException(ErrorMessages.format("Semantic Integrity Exception: Semantic Type '%1$s' is invalid and may not be used.", type.getTypeName()));
        }
        this.assertStateResponse();
        this.responseEventId = eventId;
        this.responseSemanticType = type.getTypeName();
        if (!this.sco.existsActionableEvent(this.responseEventId)) {
            this.sco.addActionableEvent(this.responseEventId);
        }
    }

    public void bindResponseObject(String eventId, String type) throws EventHandlerException, ServiceConfigurationException {
        if (eventId == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event id specified.", new String[0]));
        }
        if (type == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null semantic type specified.", new String[0]));
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new EventHandlerException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        this.assertStateResponse();
        this.responseEventId = eventId;
        this.responseSemanticType = type;
        if (!this.sco.existsActionableEvent(this.responseEventId)) {
            this.sco.addActionableEvent(this.responseEventId);
        }
    }

    public void bindResponseEvent(ImmutableEventDatagram datagram) throws EventHandlerException {
        if (datagram == null) {
            throw new EventHandlerException(ErrorMessages.format("Null Parameter Exception: Null event datagram specified.", new String[0]));
        }
        this.assertStateResponse();
        this.responseEventId = datagram.getEventId();
        this.responseSemanticType = RuntimeContext.getInstance().getSemanticTypeCache().resolveSemanticClass(datagram.getClass());
    }

    public void bindVoidResponseObject(String eventId) throws EventHandlerException, ServiceConfigurationException {
        this.assertStateResponse();
        this.responseEventId = eventId;
        this.responseSemanticType = VOID_TYPE;
    }

    public void unbindResponse() throws ServiceConfigurationException {
        this.responseEventId = "";
        this.responseSemanticType = null;
    }

    public void setServiceConfigurationObject(AbstractServiceConfigurationObject sco) {
        if (this.sco == null) {
            this.sco = sco;
        }
    }

    protected void assertStateRequest() throws IllegalHandlerStateException {
        if (this.isRequestBound()) {
            throw new IllegalHandlerStateException("Request Object already bound. Unbind first.", false);
        }
    }

    protected void assertStateResponse() throws IllegalHandlerStateException {
        if (this.isResponseBound()) {
            throw new IllegalHandlerStateException("Response Object already bound. Unbind first.", false);
        }
    }

    @Override
    public EventHandler clone() {
        return (EventHandler)super.clone();
    }

    public String toString() {
        return this.handlerName + "(methodName=" + this.methodName + ", requestEventId=" + this.requestEventId + ", responseEventId=" + this.requestEventId + ")";
    }

    public boolean isValid() {
        return this.isValid;
    }

    private Object readResolve() {
        this.isValid = true;
        return this;
    }
}

