/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim.mf;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.service.osf.eim.EventIdentityCustomProcessStart;
import com.streamscape.service.osf.eim.EventIdentityGUIDKey;
import com.streamscape.service.osf.eim.EventIdentityIntegerKeyStart;
import com.streamscape.service.osf.eim.EventIdentityPassthru;
import com.streamscape.service.osf.eim.EventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentityProcessStart;
import com.streamscape.service.osf.eim.EventIdentityProcessTracker;
import com.streamscape.service.osf.eim.EventIdentitySequentialKey;
import com.streamscape.service.osf.eim.mf.EventIdentityPluginManagerException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class EventIdentityPluginManager
extends AbstractRuntimeFactory {
    private ConcurrentHashMap<String, String> eventIdentityPlugins = new ConcurrentHashMap();
    public static final String PLUGINS_CONTEXT = "/sys/event/identity";
    private static final Class[] SYSTEM_PLUGINS = new Class[]{EventIdentityGUIDKey.class, EventIdentityPassthru.class, EventIdentitySequentialKey.class, EventIdentityProcessStart.class, EventIdentityProcessTracker.class, EventIdentityIntegerKeyStart.class, EventIdentityCustomProcessStart.class};

    protected EventIdentityPluginManager() throws Exception {
        SemanticObjectReferenceStore.beginXact();
        ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext(PLUGINS_CONTEXT);
        if (ref == null) {
            this.logDebug("Creating EIM plugins cache...");
            ref = SemanticObjectReferenceStore.createSubcontextFromNamespace(PLUGINS_CONTEXT);
        }
        SemanticObjectReferenceStore.setReferenceContext(ref);
        for (Class clazz : SYSTEM_PLUGINS) {
            this.registerSystemPlugin(clazz);
        }
        SemanticObjectReferenceStore.commitXact();
        for (String pluginName : this.listRegisteredPlugins()) {
            try {
                this.addEventIdentityPlugin(this.loadPlugin(pluginName));
                this.logInfo("EIM plugin '" + pluginName + "' added.");
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Adding EIM plugin '" + pluginName + "' failed.");
            }
        }
    }

    private void registerSystemPlugin(Class clazz) throws InstantiationException, IllegalAccessException, ObjectConfigurationException {
        String pluginName = clazz.getSimpleName();
        if (!SemanticObjectReferenceStore.existsBinding(pluginName)) {
            EventIdentityPlugin plugin = (EventIdentityPlugin)clazz.newInstance();
            SemanticObjectReferenceStore.bind(pluginName, plugin);
            this.logInfo("Default EIM plugin: " + pluginName + " created.");
        }
    }

    public void addEventIdentityPlugin(EventIdentityPlugin plugin) throws EventIdentityPluginManagerException {
        EventIdentityPluginManager.checkContext();
        if (this.eventIdentityPlugins.containsKey(plugin.getPluginName())) {
            throw new EventIdentityPluginManagerException(6031, "EIM plugin '" + plugin.getPluginName() + "' already exists.");
        }
        this.eventIdentityPlugins.put(plugin.getPluginName(), plugin.getClass().getName());
    }

    public void removeEventIdentityPlugin(String pluginName) throws EventIdentityPluginManagerException {
        EventIdentityPluginManager.checkContext();
        if (!this.eventIdentityPlugins.containsKey(pluginName)) {
            throw new EventIdentityPluginManagerException(6032, "EIM plugin '" + pluginName + "' does not exist.");
        }
        this.eventIdentityPlugins.remove(pluginName);
    }

    public EventIdentityPlugin createEventIdentityPlugin(String pluginName, ClassLoader loader) throws EventIdentityPluginManagerException {
        EventIdentityPluginManager.checkContext();
        if (!this.eventIdentityPlugins.containsKey(pluginName)) {
            throw new EventIdentityPluginManagerException(6032, "EIM plugin '" + pluginName + "' does not exist.");
        }
        try {
            return (EventIdentityPlugin)ClassUtils.createFromClassName((Object)this, this.eventIdentityPlugins.get(pluginName), loader);
        }
        catch (UtilitiesException exception) {
            throw new EventIdentityPluginManagerException(6002, "Creation of EIM plugin '" + pluginName + "' failed.", exception);
        }
    }

    public List<String> listRegisteredPlugins() {
        EventIdentityPluginManager.checkContext();
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext(PLUGINS_CONTEXT));
            List<String> names = SemanticObjectReferenceStore.listBoundNames(null);
            SemanticObjectReferenceStore.commitXact();
            return names;
        }
        catch (Exception exception) {
            this.logException(exception);
            return new ArrayList<String>();
        }
    }

    public void registerPlugin(Class eimClass) throws EventIdentityPluginManagerException {
        EventIdentityPluginManager.checkContext();
        if (eimClass == null) {
            throw new EventIdentityPluginManagerException(6004, "EIM class is null.");
        }
        this.logDebug("Registering EIM plugin '" + eimClass.getSimpleName() + "'...");
        if (EventIdentityPlugin.class.isAssignableFrom(eimClass)) {
            try {
                Constructor c = ClassUtils.getConstructor(eimClass, new Class[0]);
                c.setAccessible(true);
                EventIdentityPlugin eim = (EventIdentityPlugin)c.newInstance(new Object[0]);
                if (this.isPluginRegistered(eim.getPluginName())) {
                    throw new EventIdentityPluginManagerException(6033, "EIM plugin '" + eim.getPluginName() + "' already registered.");
                }
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext(PLUGINS_CONTEXT));
                SemanticObjectReferenceStore.bind(eim.getPluginName(), eim);
                SemanticObjectReferenceStore.commitXact();
                this.logInfo("EIM plugin '" + eim.getPluginName() + "' registered.");
            }
            catch (ObjectConfigurationException exception) {
                throw new EventIdentityPluginManagerException(6025, "Registering EIM plugin failed.", exception);
            }
            catch (Exception exception) {
                if (exception instanceof EventIdentityPluginManagerException) {
                    throw (EventIdentityPluginManagerException)exception;
                }
                throw new EventIdentityPluginManagerException(6002, "Registering EIM plugin failed.", exception);
            }
        } else {
            throw new EventIdentityPluginManagerException(5008, ErrorMessages.format("Object is not an instance of '%1$s'.", EventIdentityPlugin.class.getName()));
        }
    }

    public void unregisterPlugin(String pluginName) throws EventIdentityPluginManagerException {
        EventIdentityPluginManager.checkContext();
        this.logDebug("Unregistering EIM plugin '" + pluginName + "'...");
        if (pluginName == null) {
            throw new EventIdentityPluginManagerException(6004, "EIM plugin name is null");
        }
        if (!this.isPluginRegistered(pluginName)) {
            throw new EventIdentityPluginManagerException(6034, "EIM plugin '" + pluginName + "' is not registered.");
        }
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext(PLUGINS_CONTEXT));
            SemanticObjectReferenceStore.unbind(pluginName);
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new EventIdentityPluginManagerException(6025, "Unregistering EIM plugin '" + pluginName + "' failed.", exception);
        }
        this.logDebug("EIM plugin '" + pluginName + "' unregistered.");
    }

    public boolean isPluginRegistered(String pluginName) {
        boolean registered = false;
        EventIdentityPluginManager.checkContext();
        try {
            SemanticObjectReferenceStore.beginXact();
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext(PLUGINS_CONTEXT);
            if (ref == null) {
                throw new RuntimeContextException("Runtime Configuration Error: reference context '/sys/event/identity' does not exist.");
            }
            SemanticObjectReferenceStore.setReferenceContext(ref);
            if (SemanticObjectReferenceStore.existsBinding(pluginName)) {
                registered = true;
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return registered;
    }

    protected EventIdentityPlugin loadPlugin(String pluginName) throws ObjectConfigurationException {
        this.logDebug("Loading EIM plugin '" + pluginName + "'...");
        SemanticObjectReferenceStore.beginXact();
        SemanticObjectReferenceStore.setReferenceContext(SemanticObjectReferenceStore.lookupReferenceContext(PLUGINS_CONTEXT));
        EventIdentityPlugin plugin = (EventIdentityPlugin)SemanticObjectReferenceStore.lookup(pluginName);
        SemanticObjectReferenceStore.commitXact();
        return plugin;
    }

    protected void logException(Throwable exception) {
        Trace.logException(EventIdentityPluginManager.class, exception, true);
    }

    protected void logError(String message) {
        Trace.logError(EventIdentityPluginManager.class, message);
    }

    protected void logInfo(String message) {
        Trace.logInfo(EventIdentityPluginManager.class, message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(EventIdentityPluginManager.class, message);
    }
}

