/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.eim.AbstractEventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentity;

public class EventIdentitySequentialKey
extends AbstractEventIdentityPlugin {
    protected Long key = 0L;

    public EventIdentitySequentialKey() {
        Trace.logDebug(this, "Initialized Event Identity Manager Plugin: " + this.getName());
    }

    @Override
    public void init(ServiceContext ctx) {
        this.key = 0L;
        this.eim.correlationId = null;
        this.eim.eventGroupId = ctx.getType() + "." + ctx.getType();
        this.eim.eventKey = this.key.toString();
    }

    @Override
    public void acceptDatagramIdentity(EventDatagram datagram) {
        Long l = this.key;
        this.key = this.key + 1L;
        this.eim.correlationId = datagram.getCorrelationIdAsBytes();
        this.eim.eventKey = this.key.toString();
    }

    @Override
    public void setDatagramIdentity(EventDatagram datagram) {
        datagram.setCorrelationIdAsBytes(this.eim.correlationId);
        datagram.setEventGroupId(this.eim.eventGroupId);
        datagram.setEventKey(this.eim.eventKey);
    }

    @Override
    public String getName() {
        return "Sequential Event Key Identity";
    }

    @Override
    public String getDescription() {
        return "This plugin automatically increments the Event Key resulting in a sequenced message stream grouped by  service instance name.  The Correlation Id is still passed thru.";
    }

    @Override
    public void acceptIdentity(EventIdentity identity) {
        Long l = this.key;
        this.key = this.key + 1L;
        this.eim.correlationId = identity.getCorrelationId();
        this.eim.eventKey = this.key.toString();
    }

    @Override
    public void setExceptionIdentity(ExceptionEventDatagram exception) {
        exception.setCorrelationIdAsBytes(this.eim.correlationId);
        exception.setEventGroupId(this.eim.eventGroupId);
        exception.setEventKey(this.eim.eventKey);
    }
}

