/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.SDOFormatException;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.eim.AbstractEventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentity;

public class EventIdentityProcessTracker
extends AbstractEventIdentityPlugin {
    protected String replyTo = null;

    public EventIdentityProcessTracker() {
        Trace.logDebug(this, "Initialized Event Identity Manager Plugin: " + this.getName());
    }

    @Override
    public void init(ServiceContext ctx) {
        this.eim.correlationId = "..".getBytes();
        this.eim.eventGroupId = ctx.getType() + "." + ctx.getType();
        this.eim.eventKey = "1";
    }

    @Override
    public void acceptDatagramIdentity(EventDatagram datagram) {
        this.eim.correlationId = datagram.getCorrelationIdAsBytes();
        this.eim.eventGroupId = datagram.getEventGroupId();
        String eventKey = datagram.getEventKey();
        if (eventKey != null) {
            try {
                Long value = Long.parseLong(eventKey);
                value = value + 1L;
                eventKey = Long.toString(value);
            }
            catch (NumberFormatException error) {
                Trace.logError(this, "Unable to convert EventKey of accepted datagram to Long.");
            }
        }
        this.eim.eventKey = eventKey;
        this.replyTo = datagram.getReplyTo();
    }

    @Override
    public void setDatagramIdentity(EventDatagram datagram) {
        datagram.setCorrelationIdAsBytes(this.eim.correlationId);
        datagram.setEventGroupId(this.eim.eventGroupId);
        datagram.setEventKey(this.eim.eventKey);
        try {
            if (this.replyTo != null) {
                datagram.setReplyTo(this.replyTo);
            }
        }
        catch (SDOFormatException error) {
            Trace.logError(this, "Unable to set ReplyTo on outgoing event.");
        }
    }

    @Override
    public EventIdentity getIdentity() {
        return this.eim;
    }

    @Override
    public String getName() {
        return "Process Tracker Identity";
    }

    @Override
    public String getDescription() {
        return "This plugin automatically increases Event Key of the datagram to identify each process step.";
    }

    @Override
    public void acceptIdentity(EventIdentity identity) {
        this.eim.correlationId = identity.getCorrelationId();
        this.eim.eventKey = identity.getEventKey();
        this.eim.eventGroupId = identity.getEventGroupID();
    }

    @Override
    public void setExceptionIdentity(ExceptionEventDatagram exception) {
        exception.setCorrelationIdAsBytes(this.eim.correlationId);
        exception.setEventGroupId(this.eim.eventGroupId);
        exception.setEventKey(this.eim.eventKey);
        try {
            if (this.replyTo != null) {
                exception.setReplyTo(this.replyTo);
            }
        }
        catch (SDOFormatException error) {
            Trace.logError(this, "Unable to set ReplyTo on outgoing exception.");
        }
    }
}

