/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.eim.AbstractEventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentity;

public class EventIdentityPassthru
extends AbstractEventIdentityPlugin {
    public EventIdentityPassthru() {
        Trace.logDebug(this, "Initialized Event Identity Manager Plugin: " + this.getName());
    }

    @Override
    public void init(ServiceContext ctx) {
        this.eim.correlationId = "..".getBytes();
        this.eim.eventGroupId = "..";
        this.eim.eventKey = "..";
    }

    @Override
    public void acceptDatagramIdentity(EventDatagram datagram) {
        this.eim.correlationId = datagram.getCorrelationIdAsBytes();
        this.eim.eventGroupId = datagram.getEventGroupId();
        this.eim.eventKey = datagram.getEventKey();
    }

    @Override
    public void setDatagramIdentity(EventDatagram datagram) {
        datagram.setCorrelationIdAsBytes(this.eim.correlationId);
        datagram.setEventGroupId(this.eim.eventGroupId);
        datagram.setEventKey(this.eim.eventKey);
    }

    @Override
    public String getName() {
        return "Passthru Event Identity";
    }

    @Override
    public String getDescription() {
        return "This plugin takes the accepted values and applies them to the next datagram, passing them thru.";
    }

    @Override
    public void acceptIdentity(EventIdentity identity) {
        this.eim = identity;
    }

    @Override
    public void setExceptionIdentity(ExceptionEventDatagram exception) {
        exception.setCorrelationIdAsBytes(this.eim.correlationId);
        exception.setEventGroupId(this.eim.eventGroupId);
        exception.setEventKey(this.eim.eventKey);
    }
}

