/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.eim.AbstractEventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentity;

public class EventIdentityIntegerKeyStart
extends AbstractEventIdentityPlugin {
    public static final String EVENT_GROUP_IDENTITY = "event.group.identity";

    public EventIdentityIntegerKeyStart() {
        Trace.logDebug(this, "Initialized Event Identity Manager Plugin: " + this.getName());
    }

    @Override
    public void init(ServiceContext ctx) {
        this.eim.correlationId = this.getUniqueId().getBytes();
        this.eim.eventKey = "1";
        if (ctx.getServiceConfiguration().getAdvancedProperty(EVENT_GROUP_IDENTITY) != null) {
            this.eim.eventGroupId = ctx.getServiceConfiguration().getAdvancedProperty(EVENT_GROUP_IDENTITY).getValue().toString();
        } else {
            this.eim.eventGroupId = "UnknownProcess";
            ctx.logError("Event group identity advanced property is not set for EventIdentityIntegerKeyStart Identity Manager.");
        }
    }

    @Override
    public void acceptDatagramIdentity(EventDatagram datagram) {
    }

    @Override
    public void setDatagramIdentity(EventDatagram datagram) {
        String correlationId = Integer.toString(Math.abs(this.getUniqueId().hashCode()));
        datagram.setCorrelationIdAsBytes(correlationId.getBytes());
        datagram.setEventGroupId(this.eim.eventGroupId);
        datagram.setEventKey("1");
    }

    @Override
    public String getName() {
        return "Process Start Integer Key";
    }

    @Override
    public String getDescription() {
        return "This plugin automatically generates a unique Correlation Id as positive integer key.";
    }

    @Override
    public void acceptIdentity(EventIdentity identity) {
        this.eim.correlationId = identity.getCorrelationId();
        this.eim.eventKey = this.getUniqueId();
    }

    @Override
    public void setExceptionIdentity(ExceptionEventDatagram exception) {
        exception.setCorrelationIdAsBytes(this.eim.correlationId);
        exception.setEventGroupId(this.eim.eventGroupId);
        exception.setEventKey(this.eim.eventKey);
    }
}

