/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.eim.AbstractEventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentity;
import java.security.SecureRandom;

public class EventIdentityGUIDKey
extends AbstractEventIdentityPlugin {
    private transient SecureRandom secureRandom = null;

    public EventIdentityGUIDKey() {
        Trace.logDebug(this, "Initialized Event Identity Manager Plugin: " + this.getName());
    }

    @Override
    protected String getUniqueId() {
        return Long.toString(Math.abs(this.secureRandom.nextLong()));
    }

    @Override
    public void init(ServiceContext ctx) {
        this.secureRandom = new SecureRandom(Long.toString(System.currentTimeMillis()).getBytes());
        this.eim.correlationId = null;
        this.eim.eventGroupId = ctx.getType() + "." + ctx.getType();
        this.eim.eventKey = this.getUniqueId();
    }

    @Override
    public void acceptDatagramIdentity(EventDatagram datagram) {
        this.eim.correlationId = datagram.getCorrelationIdAsBytes();
        this.eim.eventKey = this.getUniqueId();
    }

    @Override
    public void setDatagramIdentity(EventDatagram datagram) {
        datagram.setCorrelationIdAsBytes(this.eim.correlationId);
        datagram.setEventGroupId(this.eim.eventGroupId);
        datagram.setEventKey(this.eim.eventKey);
    }

    @Override
    public String getName() {
        return "Unique Event Key Identity";
    }

    @Override
    public String getDescription() {
        return "This plugin automatically generates a unique Event Key identifying each message. The Correlation Id is still passed thru.";
    }

    @Override
    public void acceptIdentity(EventIdentity identity) {
        this.eim.correlationId = identity.getCorrelationId();
        this.eim.eventKey = this.getUniqueId();
    }

    @Override
    public void setExceptionIdentity(ExceptionEventDatagram exception) {
        exception.setCorrelationIdAsBytes(this.eim.correlationId);
        exception.setEventGroupId(this.eim.eventGroupId);
        exception.setEventKey(this.eim.eventKey);
    }
}

