/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.eim;

import com.streamscape.Trace;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.osf.eim.AbstractEventIdentityPlugin;
import com.streamscape.service.osf.eim.EventIdentity;

public class EventIdentityCustomProcessStart
extends AbstractEventIdentityPlugin {
    public static final String EVENT_GROUP_IDENTITY = "event.group.identity";

    public EventIdentityCustomProcessStart() {
        Trace.logDebug(this, "Initialized Event Identity Manager Plugin: " + this.getName());
    }

    @Override
    public void init(ServiceContext ctx) {
        if (ctx.getServiceConfiguration().getAdvancedProperty(EVENT_GROUP_IDENTITY) != null) {
            this.eim.eventGroupId = ctx.getServiceConfiguration().getAdvancedProperty(EVENT_GROUP_IDENTITY).getValue().toString();
        } else {
            this.eim.eventGroupId = "UnknownProcess";
            ctx.logError("Event group identity advanced property is not set for EventIdentityIntegerKeyStart Identity Manager.");
        }
        this.eim.eventKey = "1";
    }

    @Override
    public void acceptDatagramIdentity(EventDatagram datagram) {
    }

    @Override
    public void setDatagramIdentity(EventDatagram datagram) {
        if (datagram.getCorrelationId() == null) {
            Trace.logError(EventIdentityCustomProcessStart.class, "Correlation ID is not set on the datagram. Use another which can generate it automatically.");
        }
        datagram.setEventGroupId(this.eim.eventGroupId);
        datagram.setEventKey("1");
    }

    @Override
    public String getName() {
        return "Custom Process Start";
    }

    @Override
    public String getDescription() {
        return "This plugin keeps CorrelationId which can be set by service and set EventKey and EventGroup ID.";
    }

    @Override
    public void acceptIdentity(EventIdentity identity) {
        this.eim.correlationId = identity.getCorrelationId();
        this.eim.eventKey = identity.getEventKey();
        this.eim.eventGroupId = identity.getEventGroupID();
    }

    @Override
    public void setExceptionIdentity(ExceptionEventDatagram exception) {
        exception.setEventGroupId(this.eim.eventGroupId);
        exception.setEventKey(this.eim.eventKey);
    }
}

