/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.config;

import java.util.Enumeration;
import java.util.Hashtable;

public class ServiceConfigurationValidatorResults
extends Hashtable<String, ValidatorResult> {
    public ValidatorResult createValidationResult(String propertyName) {
        return new ValidatorResult(propertyName);
    }

    public ValidatorResult createValidationResult(String propertyName, int errorType, String errorMsg) {
        return new ValidatorResult(propertyName, errorType, errorMsg);
    }

    public void addResult(ValidatorResult result) {
        this.put(result.getPropertyName(), result);
    }

    public void addResultsAll(ServiceConfigurationValidatorResults results) {
        Enumeration<ValidatorResult> res = results.getValidatorResults();
        while (res.hasMoreElements()) {
            this.addResult(res.nextElement());
        }
    }

    public void removeResult(String propertyName) {
        this.remove(propertyName);
    }

    public void clearResults() {
        this.clear();
    }

    public Enumeration<ValidatorResult> getValidatorResults() {
        return this.elements();
    }

    public Enumeration<String> getValidationResultProperties() {
        return this.keys();
    }

    public int getErrorCount() {
        return this.size();
    }

    public static class ValidatorResult {
        private String propertyName = "";
        private int errorType = 1;
        private String errorMsg = "";

        public ValidatorResult(String name) {
            this.propertyName = name;
        }

        public ValidatorResult(String elementName, int type, String msg) {
            this.propertyName = elementName;
            this.errorType = type;
            this.errorMsg = msg;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setType(int type) {
            this.errorType = type;
        }

        public int getType() {
            return this.errorType;
        }

        public void setMessage(String msg) {
            this.errorMsg = msg;
        }

        public String getMessage() {
            return this.errorMsg;
        }
    }

    public static class Type {
        public static final int PROPERTY_WARNING = 1;
        public static final int PROPERTY_SEVERE = 2;
        public static final int PROPERTY_UNKNOWN = 3;
        public static final int PROPERTY_DEPRECATED = 4;
        public static final int GLOBAL_WARNING = 5;
        public static final int GLOBAL_SEVERE = 6;
        public static final int GLOBAL_UNKNOWN = 7;
        public static final int GLOBAL_DEPRECATED = 8;
    }
}

