/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.config;

import com.streamscape.Trace;
import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.sdo.CloneableObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.JDBCFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class ServiceConfigurationProperty
implements Cloneable {
    protected String propertyName = "";
    protected String labelName = "";
    protected String propertyDescription = "";
    protected String propertyGroup = "main.group";
    protected ServicePropertyType dataType = ServicePropertyType.STRING;
    protected Boolean isRequired = false;
    protected String rangeList = "";
    protected Object defaultValue = null;
    protected Object propertyValue = null;
    protected Boolean isExportable = true;

    protected ServiceConfigurationProperty() {
    }

    protected ServiceConfigurationProperty(String name) {
        this.propertyName = name;
    }

    protected ServiceConfigurationProperty(String name, String label, String desc, String range, boolean export) {
        this.propertyName = name;
        this.labelName = label;
        this.propertyDescription = desc;
        this.rangeList = range;
        this.isExportable = export;
    }

    public void setName(String name) {
        this.propertyName = name;
    }

    public String getName() {
        return this.propertyName;
    }

    public void setLabel(String label) {
        this.labelName = label;
    }

    public String getLabel() {
        return this.labelName;
    }

    public void setDescription(String desc) {
        this.propertyDescription = desc;
    }

    public String getDescription() {
        return this.propertyDescription;
    }

    public void setGroup(String group) {
        this.propertyGroup = group;
    }

    public String getGroup() {
        return this.propertyGroup;
    }

    void setType(ServicePropertyType type) throws ServiceConfigurationException {
        this.dataType = type;
        this.initDefaultValues();
    }

    public ServicePropertyType getType() {
        return this.dataType;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public void setRange(String range) {
        this.rangeList = range;
    }

    public String getRange() {
        return this.rangeList;
    }

    public Vector<String> getRangeList() {
        Vector<String> range = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.rangeList, ",");
        while (tokenizer.hasMoreTokens()) {
            range.add(tokenizer.nextToken());
        }
        return range;
    }

    public void setDefault(Object dflt) throws ServiceConfigurationException {
        if (dflt == null) {
            throw new ServiceConfigurationException("Null property value.");
        }
        this.defaultValue = dflt;
    }

    public Object getDefault() {
        return this.defaultValue;
    }

    public void applyDefault() {
        try {
            this.setValue(this.getDefault());
        }
        catch (ServiceConfigurationException ex) {
            Trace.logError(this, "Error applying defaults on: " + this.getName() + ", " + ex.getMessage());
        }
    }

    public void setValue(Object value) throws ServiceConfigurationException {
        if (value == null) {
            throw new ServiceConfigurationException("Null property value.");
        }
        this.doSetValue(value);
    }

    public void setValue(String valueWithMacro) throws ServiceConfigurationException {
        if (valueWithMacro == null) {
            throw new ServiceConfigurationException("Null property value.");
        }
        if (MacroProcessor.isMacro(valueWithMacro)) {
            this.propertyValue = valueWithMacro;
            return;
        }
        switch (this.dataType) {
            case STRING: 
            case SQL: 
            case TEXT: 
            case XML: {
                this.propertyValue = valueWithMacro;
                break;
            }
            case ENUMERATION: {
                this.doSetValue(valueWithMacro);
                break;
            }
            case URL: {
                try {
                    new URI(valueWithMacro);
                }
                catch (URISyntaxException error) {
                    throw new ServiceConfigurationException("Incorrect format for URL property value. " + error.getMessage());
                }
                this.propertyValue = valueWithMacro;
                break;
            }
            case BOOLEAN: {
                try {
                    this.propertyValue = Boolean.parseBoolean(valueWithMacro);
                    break;
                }
                catch (IllegalArgumentException error) {
                    throw new ServiceConfigurationException("Incorrect Boolean property value provided. " + error.getMessage());
                }
            }
            case NUMERIC: {
                try {
                    this.propertyValue = Long.valueOf(valueWithMacro);
                    break;
                }
                catch (IllegalArgumentException error) {
                    throw new ServiceConfigurationException("Incorrect Numeric property value provided. " + error.getMessage());
                }
            }
            case DECIMAL: {
                try {
                    this.propertyValue = Double.parseDouble(valueWithMacro);
                    break;
                }
                catch (IllegalArgumentException error) {
                    throw new ServiceConfigurationException("Incorrect Decimal property value provided. " + error.getMessage());
                }
            }
            case JDBC_FACTORY: 
            case CLIENT_FACTORY: 
            case TRANSPORT_FACTORY: {
                throw new ServiceConfigurationException("Property of Connection Factory type can't be set as String.");
            }
            case OBJECT: {
                throw new ServiceConfigurationException("Property of Object type can't be set as String.");
            }
            case OTHER: {
                this.propertyValue = valueWithMacro;
            }
        }
    }

    public Object getRawValue() {
        return this.propertyValue;
    }

    public Object resolveValue(MacroProcessor processor) {
        return this.getValueInternal(processor, true);
    }

    public Object getValue() {
        return this.getValueInternal(new MacroProcessor(), false);
    }

    private Object getValueInternal(MacroProcessor processor, boolean withResolve) {
        if (this.propertyValue == null) {
            return null;
        }
        if (this.propertyValue instanceof String) {
            String value = (String)this.propertyValue;
            if (MacroProcessor.isMacro(value)) {
                value = processor.process(value);
            }
            switch (this.dataType) {
                case STRING: 
                case SQL: 
                case TEXT: 
                case XML: 
                case ENUMERATION: {
                    return value;
                }
                case URL: {
                    try {
                        return new URI(value);
                    }
                    catch (URISyntaxException error) {
                        return null;
                    }
                }
                case BOOLEAN: {
                    if (value.equalsIgnoreCase("true")) {
                        return Boolean.TRUE;
                    }
                    if (value.equalsIgnoreCase("false")) {
                        return Boolean.FALSE;
                    }
                    return null;
                }
                case NUMERIC: {
                    try {
                        return Long.valueOf(value);
                    }
                    catch (IllegalArgumentException error) {
                        return null;
                    }
                }
                case DECIMAL: {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (IllegalArgumentException error) {
                        return null;
                    }
                }
                case JDBC_FACTORY: 
                case CLIENT_FACTORY: 
                case TRANSPORT_FACTORY: {
                    return null;
                }
                case OBJECT: {
                    return null;
                }
            }
        } else {
            if (this.propertyValue instanceof TransportFactoryPropertyValue && this.dataType == ServicePropertyType.TRANSPORT_FACTORY || this.propertyValue instanceof JDBCFactoryPropertyValue && this.dataType == ServicePropertyType.JDBC_FACTORY || this.propertyValue instanceof ClientFactoryPropertyValue && this.dataType == ServicePropertyType.CLIENT_FACTORY) {
                return this.propertyValue;
            }
            if (this.propertyValue instanceof ObjectPropertyValue && this.dataType == ServicePropertyType.OBJECT) {
                return this.propertyValue;
            }
            if (this.propertyValue instanceof PasswordPropertyValue && this.dataType == ServicePropertyType.PASSWORD) {
                return this.propertyValue;
            }
            if (this.dataType == ServicePropertyType.LIST) {
                if (this.propertyValue != null && this.propertyValue.getClass().isArray()) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < Array.getLength(this.propertyValue); ++i) {
                        list.add(Array.get(this.propertyValue, i));
                    }
                    this.propertyValue = list;
                }
                if (this.propertyValue instanceof List) {
                    if (withResolve) {
                        ArrayList<ServiceConfigurationProperty> newProps = new ArrayList<ServiceConfigurationProperty>();
                        for (ServiceConfigurationProperty prop : (List)this.propertyValue) {
                            try {
                                ServiceConfigurationProperty newProp = prop.clone();
                                newProp.setValue(newProp.resolveValue(processor));
                                newProps.add(newProp);
                            }
                            catch (Exception error) {
                                Trace.logException(this, error, true);
                            }
                        }
                        return newProps;
                    }
                    return this.propertyValue;
                }
            } else {
                if (this.propertyValue instanceof Hashtable && this.dataType == ServicePropertyType.TABLE) {
                    if (withResolve) {
                        Hashtable<String, ServiceConfigurationProperty> newProps = new Hashtable<String, ServiceConfigurationProperty>();
                        for (Map.Entry prop : ((Hashtable)this.propertyValue).entrySet()) {
                            try {
                                ServiceConfigurationProperty newProp = ((ServiceConfigurationProperty)prop.getValue()).clone();
                                newProp.setValue(newProp.resolveValue(processor));
                                newProps.put((String)prop.getKey(), newProp);
                            }
                            catch (Exception error) {
                                Trace.logException(this, error, true);
                            }
                        }
                        return newProps;
                    }
                    return this.propertyValue;
                }
                if (this.dataType == ServicePropertyType.NUMERIC) {
                    if (this.propertyValue instanceof Number) {
                        return ((Number)this.propertyValue).longValue();
                    }
                    return Long.parseLong(this.propertyValue.toString());
                }
                if (this.dataType == ServicePropertyType.DECIMAL) {
                    if (this.propertyValue instanceof Number) {
                        return ((Number)this.propertyValue).doubleValue();
                    }
                    return Double.parseDouble(this.propertyValue.toString());
                }
                if (this.dataType == ServicePropertyType.BOOLEAN) {
                    if (this.propertyValue instanceof Boolean) {
                        return this.propertyValue;
                    }
                    return Boolean.parseBoolean(this.propertyValue.toString());
                }
                if (this.dataType == ServicePropertyType.OTHER) {
                    return this.propertyValue;
                }
            }
        }
        return null;
    }

    public void setExportable(boolean export) {
        this.isExportable = export;
    }

    public boolean isExportable() {
        return this.isExportable;
    }

    public String toString() {
        if (this.propertyValue == null) {
            return "";
        }
        return this.propertyValue.toString();
    }

    public Object toObject() {
        switch (this.dataType) {
            case STRING: {
                return this.toString();
            }
            case PASSWORD: {
                return this.toString().getBytes();
            }
            case XML: {
                return this.toString();
            }
            case TEXT: {
                return this.toString();
            }
            case NUMERIC: {
                return new Long(this.toString());
            }
            case DECIMAL: {
                return new Double(this.toString());
            }
            case BOOLEAN: {
                return Boolean.valueOf(this.toString());
            }
            case ENUMERATION: {
                return this.toString();
            }
            case LIST: {
                return this.propertyValue;
            }
            case TABLE: {
                return this.propertyValue;
            }
            case OBJECT: {
                return this.propertyValue;
            }
            case SQL: {
                return this.toString();
            }
            case URL: {
                URI uri = null;
                try {
                    uri = new URI(this.toString());
                }
                catch (URISyntaxException ex) {
                    Trace.logError(this, "Malformed URL when converting '" + this.toString() + "' parameter");
                }
                return uri;
            }
            case TRANSPORT_FACTORY: {
                return this.propertyValue;
            }
            case CLIENT_FACTORY: {
                return this.propertyValue;
            }
            case JDBC_FACTORY: {
                return this.propertyValue;
            }
        }
        return null;
    }

    private void initDefaultValues() {
        switch (this.dataType) {
            case STRING: {
                this.propertyValue = "";
                break;
            }
            case PASSWORD: {
                this.propertyValue = new PasswordPropertyValue("");
                break;
            }
            case XML: {
                this.propertyValue = "";
                break;
            }
            case TEXT: {
                this.propertyValue = "";
                break;
            }
            case NUMERIC: {
                this.propertyValue = 0L;
                break;
            }
            case DECIMAL: {
                this.propertyValue = 0.0;
                break;
            }
            case BOOLEAN: {
                this.propertyValue = false;
                break;
            }
            case ENUMERATION: {
                this.propertyValue = "";
                this.rangeList = "";
                break;
            }
            case LIST: {
                this.propertyValue = new ArrayList();
                break;
            }
            case TABLE: {
                this.propertyValue = new Hashtable();
                break;
            }
            case OBJECT: {
                this.propertyValue = new ObjectPropertyValue("");
                break;
            }
            case SQL: {
                this.propertyValue = "";
                break;
            }
            case URL: {
                try {
                    this.propertyValue = new URI("tcp://");
                }
                catch (URISyntaxException ex) {
                    this.propertyValue = "";
                }
                break;
            }
            case TRANSPORT_FACTORY: {
                this.propertyValue = new TransportFactoryPropertyValue(".", ".");
                Trace.logInfo(this, "Initialized a new default Transport Factory property.");
                break;
            }
            case CLIENT_FACTORY: {
                this.propertyValue = new ClientFactoryPropertyValue(".", ".");
                Trace.logInfo(this, "Initialized a new default Client Factory property.");
                break;
            }
            case JDBC_FACTORY: {
                this.propertyValue = new JDBCFactoryPropertyValue(".", ".");
                Trace.logInfo(this, "Initialized a new default JDBC Factory property.");
                break;
            }
        }
    }

    private void doSetValue(Object value) throws ServiceConfigurationException {
        switch (this.dataType) {
            case STRING: {
                if (!(value instanceof String)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type String is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case PASSWORD: {
                if (!(value instanceof PasswordPropertyValue)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type PASSWORD is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case XML: {
                if (!(value instanceof String)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type String is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case TEXT: {
                if (!(value instanceof String)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type String is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case NUMERIC: {
                if (value instanceof Number) {
                    this.propertyValue = ((Number)value).longValue();
                    break;
                }
                throw new ServiceConfigurationException("Wrong property value provided. Value of type Long is expected.");
            }
            case DECIMAL: {
                if (value instanceof Number) {
                    this.propertyValue = ((Number)value).doubleValue();
                    break;
                }
                throw new ServiceConfigurationException("Wrong property value provided. Value of type Double is expected.");
            }
            case BOOLEAN: {
                if (!(value instanceof Boolean)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type Boolean is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case ENUMERATION: {
                if (this.rangeList == null || this.rangeList.length() <= 0) {
                    throw new ServiceConfigurationException("Range list is not set for this Enumeration property. Initialize range first.");
                }
                if (!(value instanceof String)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type String is expected.");
                }
                if (!this.getRangeList().contains(value.toString())) {
                    throw new ServiceConfigurationException("Illegal enumeration value '" + String.valueOf(value) + "' provided. Should be one of the following: " + this.rangeList);
                }
                this.propertyValue = value;
                break;
            }
            case LIST: {
                if (value == null) {
                    throw new ServiceConfigurationException("Null property value.");
                }
                if (!(value instanceof List)) {
                    throw new ServiceConfigurationException("Invalid Type specified : must be List<ServiceConfigurationProperty>.");
                }
                this.propertyValue = value;
                break;
            }
            case TABLE: {
                if (value == null) {
                    throw new ServiceConfigurationException("Null property value.");
                }
                if (!(value instanceof Hashtable)) {
                    throw new ServiceConfigurationException("Invalid Type specified : must be Hashtable<String,ServiceConfigurationProperty>.");
                }
                this.propertyValue = value;
                break;
            }
            case OBJECT: {
                if (!(value instanceof ObjectPropertyValue)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type " + ObjectPropertyValue.class.getSimpleName() + " is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case SQL: {
                if (!(value instanceof String)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type String is expected.");
                }
                this.propertyValue = value;
                break;
            }
            case URL: {
                if (!(value instanceof URI)) {
                    throw new ServiceConfigurationException("Wrong property value provided. Value of type URL is expected.");
                }
                this.propertyValue = value.toString();
                break;
            }
            case TRANSPORT_FACTORY: {
                if (value == null) {
                    throw new ServiceConfigurationException("Null property value.");
                }
                if (!(value instanceof TransportFactoryPropertyValue)) {
                    throw new ServiceConfigurationException("Invalid Type specified : must be FactoryPropertyValue.");
                }
                this.propertyValue = value;
                break;
            }
            case CLIENT_FACTORY: {
                if (value == null) {
                    throw new ServiceConfigurationException("Null property value.");
                }
                if (!(value instanceof ClientFactoryPropertyValue)) {
                    throw new ServiceConfigurationException("Invalid Type specified : must be FactoryPropertyValue.");
                }
                this.propertyValue = value;
                break;
            }
            case JDBC_FACTORY: {
                if (value == null) {
                    throw new ServiceConfigurationException("Null property value.");
                }
                if (!(value instanceof JDBCFactoryPropertyValue)) {
                    throw new ServiceConfigurationException("Invalid Type specified : must be FactoryPropertyValue.");
                }
                this.propertyValue = value;
                break;
            }
            case OTHER: {
                this.propertyValue = value;
            }
        }
    }

    public ServiceConfigurationProperty clone() {
        try {
            List values;
            ServiceConfigurationProperty result = (ServiceConfigurationProperty)super.clone();
            if (this.defaultValue instanceof List) {
                values = (List)this.defaultValue;
                result.defaultValue = new ArrayList();
                for (ServiceConfigurationProperty prop : values) {
                    ((List)result.defaultValue).add(prop.clone());
                }
            } else if (this.defaultValue instanceof CloneableObject) {
                result.defaultValue = ((CloneableObject)this.defaultValue).clone();
            }
            if (this.propertyValue instanceof List) {
                values = (List)this.propertyValue;
                result.propertyValue = new ArrayList();
                for (ServiceConfigurationProperty prop : values) {
                    ((List)result.propertyValue).add(prop.clone());
                }
            } else if (this.propertyValue instanceof CloneableObject) {
                result.propertyValue = ((CloneableObject)this.propertyValue).clone();
            }
            return result;
        }
        catch (CloneNotSupportedException exception) {
            throw new RuntimeException(exception);
        }
    }
}

