/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.config;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.service.osf.ServiceRuntimeException;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import javax.naming.NamingException;

public class ObjectPropertyValue {
    private String objectName = "";
    private String objectType = "";
    private String ctxNamespace = "/";

    private Object readResolve() {
        return this;
    }

    public ObjectPropertyValue(String objName) {
        if (!StringUtils.validateString(objName)) {
            throw new ServiceRuntimeException("Invalid OBJECT name '" + objName + "'.");
        }
        this.objectName = objName;
    }

    public ObjectPropertyValue(String objName, String semanticType, ReferenceContext ctx) throws ServiceConfigurationException {
        if (!StringUtils.validateString(objName)) {
            throw new ServiceConfigurationException("Invalid OBJECT name '" + objName + "'.");
        }
        if (!StringUtils.validateString(semanticType)) {
            throw new ServiceConfigurationException("Invalid OBJECT semantic type name '" + semanticType + "'.");
        }
        this.objectName = objName;
        this.objectType = semanticType;
        this.setReferenceContext(ctx);
    }

    public void setObjectName(String objName) throws ServiceConfigurationException {
        if (!StringUtils.validateString(objName)) {
            throw new ServiceConfigurationException("Invalid OBJECT name '" + objName + "'.");
        }
        this.objectName = objName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectType(String semanticType) throws ServiceConfigurationException {
        if (!StringUtils.validateString(semanticType)) {
            throw new ServiceConfigurationException("Invalid OBJECT semantic type name '" + semanticType + "'.");
        }
        this.objectType = semanticType;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setReferenceContext(ReferenceContext ctx) {
        this.ctxNamespace = ctx.getContextNameSpace();
    }

    public ReferenceContext getReferenceContext() {
        ReferenceContext ctx = null;
        try {
            ctx = new ReferenceContext(new ReferenceContext(null, null), this.ctxNamespace);
        }
        catch (NamingException ex) {
            Trace.logError(this, "Naming Exception obtaining Reference Context for '" + this.toString() + "'. " + ex.getMessage());
            System.out.println("Naming Exception obtaining Reference Context for '" + this.toString() + "'. " + ex.getMessage());
        }
        return ctx;
    }

    public String toString() {
        return this.objectType + "." + this.objectName;
    }
}

