/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.config;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.service.osf.ServiceRuntimeException;
import com.streamscape.service.osf.config.ServiceConfigurationException;

public class DestinationPropertyValue {
    private String destinationName = "defaultDestinationName";
    private String semanticType = "JMSDestination";
    private String destinationFactoryType = "defaultFactoryType";

    public DestinationPropertyValue(String destName) {
        if (!StringUtils.validateObjectName(destName)) {
            throw new ServiceRuntimeException("Invalid DESTINATION name '" + destName + "'.");
        }
        this.destinationName = destName;
    }

    public DestinationPropertyValue(String destName, String semanticType, String factoryType) throws ServiceConfigurationException {
        if (!StringUtils.validateObjectName(destName)) {
            throw new ServiceConfigurationException("Invalid DESTINATION name '" + destName + "'.");
        }
        if (!StringUtils.validateString(semanticType)) {
            throw new ServiceConfigurationException("Invalid DESTINATION semantic type name '" + semanticType + "'.");
        }
        this.destinationName = destName;
        this.semanticType = semanticType;
        this.destinationFactoryType = factoryType;
    }

    public void setDestinationName(String destName) throws ServiceConfigurationException {
        if (!StringUtils.validateObjectName(destName)) {
            throw new ServiceConfigurationException("Invalid DESTINATION name '" + destName + "'.");
        }
        this.destinationName = destName;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationType(String semanticType) throws ServiceConfigurationException {
        if (!StringUtils.validateString(semanticType)) {
            throw new ServiceConfigurationException("Invalid DESTINATION semantic type name '" + semanticType + "'.");
        }
        this.semanticType = semanticType;
    }

    public String getDestinationType() {
        return this.semanticType;
    }

    public void setFactoryType(String factoryType) {
        this.destinationFactoryType = factoryType;
    }

    public String getFactoryType() {
        return this.destinationFactoryType;
    }

    public String toString() {
        return this.destinationFactoryType + ":" + this.destinationName;
    }
}

