/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.config;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.SystemDataObject;
import com.streamscape.sdo.enums.StateAdvisoryType;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponentConfigurationException;
import com.streamscape.sef.FabricComponentProperties;
import com.streamscape.sef.advisories.StateAdvisoryDefinition;
import com.streamscape.sef.metrics.MetricDefinition;
import com.streamscape.service.osf.ErrorMessages;
import com.streamscape.service.osf.ServiceRuntimeException;
import com.streamscape.service.osf.config.AbstractServiceConfigurationValidator;
import com.streamscape.service.osf.config.ActionableEventsConfiguration;
import com.streamscape.service.osf.config.AdvancedPropertiesConfiguration;
import com.streamscape.service.osf.config.AdvisoriesConfiguration;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.EventHandlersConfiguration;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.service.osf.config.EventTriggersConfiguration;
import com.streamscape.service.osf.config.ExceptionsConfiguration;
import com.streamscape.service.osf.config.MetricsConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServiceConfigurationValidatorResults;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.osf.registry.ActionableEvents;
import com.streamscape.service.osf.registry.AdvancedProperties;
import com.streamscape.service.osf.registry.AdvisoryEvents;
import com.streamscape.service.osf.registry.ConfigurationProperties;
import com.streamscape.service.osf.registry.EventHandlers;
import com.streamscape.service.osf.registry.EventTriggers;
import com.streamscape.service.osf.registry.ExceptionEvents;
import com.streamscape.service.osf.registry.Metrics;
import com.streamscape.service.ui.validators.DefaultValidator;
import java.util.Date;
import java.util.List;

public class AbstractServiceConfigurationObject
extends CloneableDataObject
implements ConfigurationObject,
MetricsConfiguration,
AdvisoriesConfiguration,
EventHandlersConfiguration,
ServiceConfigurationProperties,
ExceptionsConfiguration,
ActionableEventsConfiguration,
EventTriggersConfiguration,
AdvancedPropertiesConfiguration,
SystemDataObject {
    private String serviceType = "";
    private String serviceName = "";
    private String serviceDisplayName = "";
    private String serviceDesc = "";
    private String serviceClass = "";
    private String eimPlugin = "";
    private String validatorClass = DefaultValidator.class.getName();
    private InvokeMode invokeMode = InvokeMode.DIRECT;
    private boolean daemonService = false;
    private boolean interruptable = false;
    private ConfigurationProperties propertiesRegistry = new ConfigurationProperties();
    private AdvancedProperties advancedPropertiesRegistry = new AdvancedProperties();
    private Metrics metricsRegistry = new Metrics();
    private AdvisoryEvents advisoriesRegistry = new AdvisoryEvents();
    private ActionableEvents actionableEventsRegistry = new ActionableEvents();
    private EventHandlers eventHandlersRegistry = new EventHandlers();
    private ExceptionEvents exceptionsRegistry = new ExceptionEvents();
    private long configTimeStamp = 0L;
    private EventTriggers eventTriggersRegistry = new EventTriggers();

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String name) {
        this.serviceName = name;
        this.touch();
    }

    @Override
    public void setServiceType(String type) {
        this.serviceType = type;
        this.touch();
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public void setServiceDisplayName(String displayName) {
        this.serviceDisplayName = displayName;
        this.touch();
    }

    @Override
    public String getServiceDisplayName() {
        return this.serviceDisplayName;
    }

    @Override
    public void setServiceDescription(String desc) {
        this.serviceDesc = desc;
        this.touch();
    }

    @Override
    public String getServiceDescription() {
        return this.serviceDesc;
    }

    @Override
    public boolean isDaemonService() {
        return this.daemonService;
    }

    @Override
    public void setDaemonService(boolean isDaemon) {
        this.daemonService = isDaemon;
        if (isDaemon) {
            this.removeAllEventHandlers();
        }
        this.touch();
    }

    @Override
    public boolean isInterruptableService() {
        return this.interruptable;
    }

    @Override
    public void setInterruptableService(boolean isInterruptable) throws ServiceConfigurationException {
        this.interruptable = isInterruptable;
        if (isInterruptable) {
            StateAdvisoryDefinition cancelNotif = new StateAdvisoryDefinition("Cancel");
            cancelNotif.setType(StateAdvisoryType.WARNING);
            this.advisoriesRegistry.addStateAdvisory(cancelNotif);
        } else {
            try {
                this.advisoriesRegistry.removeAdvisory("Cancel");
            }
            catch (ServiceConfigurationException serviceConfigurationException) {
                // empty catch block
            }
        }
        this.touch();
    }

    @Override
    public void setServiceClassName(String className) {
        this.serviceClass = className;
        this.touch();
    }

    @Override
    public String getServiceClassName() {
        return this.serviceClass;
    }

    @Override
    public void setInvokeMode(InvokeMode type) {
        this.invokeMode = type;
        if (this.invokeMode == InvokeMode.ASYNC) {
            this.addAdvancedProperty(FabricComponentProperties.getProperty("consumerAsyncSpinWait"));
            this.addAdvancedProperty(FabricComponentProperties.getProperty("consumerAsyncDeliveryMode"));
            this.addAdvancedProperty(FabricComponentProperties.getProperty("consumerAsyncQueueMaxDepth"));
            this.addAdvancedProperty(FabricComponentProperties.getProperty("consumerAsyncQueueFlowcontrol"));
        } else {
            this.removeAdvancedProperty("consumerAsyncSpinWait");
            this.removeAdvancedProperty("consumerAsyncDeliveryMode");
            this.removeAdvancedProperty("consumerAsyncQueueMaxDepth");
            this.removeAdvancedProperty("consumerAsyncQueueFlowcontrol");
        }
        this.touch();
    }

    @Override
    public InvokeMode getInvokeMode() {
        return this.invokeMode;
    }

    @Override
    public String getEIMPluginName() {
        return this.eimPlugin;
    }

    @Override
    public void setEIMPluginName(String name) {
        this.eimPlugin = name;
        this.touch();
    }

    @Override
    public boolean hasEIMPlugin() {
        return this.eimPlugin != null && !this.eimPlugin.equals("") && !this.eimPlugin.equals("none") && !this.eimPlugin.equals("NONE");
    }

    @Override
    public boolean hasMetrics() {
        return this.metricsRegistry.hasMetrics();
    }

    @Override
    public boolean existsMetric(String metricName) {
        return this.metricsRegistry.existsMetric(metricName);
    }

    @Override
    public void addMetric(MetricDefinition metric) throws ServiceConfigurationException {
        this.metricsRegistry.addMetric(metric);
        this.touch();
        Trace.logDebug(this, "Added configuration metric '" + metric.getName() + "' (" + metric.getUnits().name() + ").");
    }

    @Override
    public void removeMetric(String metricName) throws ServiceConfigurationException {
        if (this.existsAdvisory(metricName)) {
            this.removeAdvisory(metricName);
            Trace.logDebug(this, "Removed configuration metric advisory '" + metricName + "'.");
        }
        this.metricsRegistry.removeMetric(metricName);
        this.touch();
        Trace.logDebug(this, "Removed configuration metric '" + metricName + "'.");
    }

    @Override
    public void removeAllMetrics() {
        for (String metric : this.listMetrics()) {
            if (!this.existsAdvisory(metric)) continue;
            try {
                this.removeAdvisory(metric);
                Trace.logDebug(this, "Removed metric advisory '" + metric + "'.");
            }
            catch (ServiceConfigurationException ex) {
                throw new ServiceRuntimeException(ex);
            }
        }
        this.metricsRegistry.removeAllMetrics();
        this.touch();
    }

    @Override
    public MetricDefinition getMetric(String metricName) throws ServiceConfigurationException {
        return this.metricsRegistry.getMetric(metricName).clone();
    }

    @Override
    public List<MetricDefinition> getMetrics() {
        return this.metricsRegistry.getMetrics();
    }

    @Override
    public List<String> listMetrics() {
        return this.metricsRegistry.listMetrics();
    }

    @Override
    public boolean hasAdvisories() {
        return this.advisoriesRegistry.hasAdvisories();
    }

    @Override
    public boolean existsAdvisory(String snName) {
        return this.advisoriesRegistry.existsAdvisory(snName);
    }

    @Override
    public void addStateAdvisory(StateAdvisoryDefinition advisory) throws ServiceConfigurationException {
        if (advisory.getName().equals("Cancel")) {
            throw new ServiceConfigurationException("Advisory 'Cancel' is reserved for system use. Choose another name.");
        }
        this.advisoriesRegistry.addStateAdvisory(advisory);
        this.touch();
        Trace.logDebug(this, "Added state advisory '" + advisory.getName() + "' (" + advisory.getType().name() + ").");
    }

    @Override
    public void addAdvisory(String eventId) throws ServiceConfigurationException {
        this.advisoriesRegistry.addAdvisory(eventId);
        this.touch();
        Trace.logDebug(this, "Added advisory '" + eventId + "'.");
    }

    @Override
    public void removeAdvisory(String advisoryName) throws ServiceConfigurationException {
        this.advisoriesRegistry.removeAdvisory(advisoryName);
        this.touch();
        Trace.logDebug(this, "Removed advisory '" + advisoryName + "'.");
    }

    @Override
    public StateAdvisoryDefinition getStateAdvisoryDefinition(String advisoryName) throws ServiceConfigurationException {
        return this.advisoriesRegistry.getStateAdvisoryDefinition(advisoryName);
    }

    @Override
    public List<StateAdvisoryDefinition> getStateAdvisoryDefinitions() {
        return this.advisoriesRegistry.getStateAdvisoryDefinitions();
    }

    @Override
    public List<String> listAdvisories() {
        return this.advisoriesRegistry.listAdvisories();
    }

    @Override
    public void removeAllAdvisories() {
        this.advisoriesRegistry.removeAllAdvisories();
        this.touch();
        Trace.logDebug(this, "Removed all advisories.");
    }

    public ServiceConfigurationProperty createProperty(String propertyName, ServicePropertyType propertyType, String propertyGroup) throws ServiceConfigurationException {
        if (propertyName == null) {
            throw new ServiceConfigurationException("Null property object. : propertyName");
        }
        if (propertyName.equals("")) {
            throw new ServiceConfigurationException("Missing property value : propertyName");
        }
        if (propertyType == null) {
            throw new ServiceConfigurationException("Null property object. : propertyType");
        }
        if (propertyGroup != null) {
            if (propertyGroup.equals("")) {
                throw new ServiceConfigurationException("Missing property value : propertyGroup");
            }
            if (!this.existsPropertyGroup(propertyGroup)) {
                throw new ServiceConfigurationException("Unknown property group specified.");
            }
        }
        ServiceConfigurationProperty p = new ServiceConfigurationProperty(propertyName);
        p.setType(propertyType);
        p.setGroup(propertyGroup == null ? "main.group" : propertyGroup);
        return p;
    }

    public ConfigurationProperty createAdvancedProperty(String propertyName, String propertyLabel, String propertyDescription) {
        return new ConfigurationProperty(propertyName, propertyLabel, propertyDescription);
    }

    public EventHandler createEventHandler(String methodName, String handlerName) throws ServiceConfigurationException {
        if (methodName == null) {
            throw new ServiceConfigurationException("Null property object.");
        }
        if (handlerName == null) {
            throw new ServiceConfigurationException("Null property object.");
        }
        if (methodName.equals("")) {
            throw new ServiceConfigurationException("Missing property value");
        }
        if (handlerName.equals("")) {
            throw new ServiceConfigurationException("Missing property value");
        }
        return new EventHandler(this, methodName, handlerName);
    }

    public MetricDefinition createMetric(String metricName) throws ServiceConfigurationException {
        if (metricName == null) {
            throw new ServiceConfigurationException("Null Metric name specified.");
        }
        if (metricName.equals("")) {
            throw new ServiceConfigurationException("Unknown Metric specified.''.");
        }
        if (!StringUtils.validateEventId(metricName)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Invalid metric name '%1$s'.", metricName));
        }
        try {
            return new MetricDefinition(metricName);
        }
        catch (FabricComponentConfigurationException ex) {
            throw new ServiceConfigurationException(ex);
        }
    }

    public StateAdvisoryDefinition createStateAdvisory(String eventId) throws ServiceConfigurationException {
        if (eventId == null) {
            throw new ServiceConfigurationException("Null Advisory name specified.");
        }
        if (eventId.equals("")) {
            throw new ServiceConfigurationException("Null Advisory name specified.");
        }
        if (!StringUtils.validateEventId(eventId)) {
            throw new ServiceConfigurationException(ErrorMessages.format("Event id [%1$s] is invalid.", eventId));
        }
        return new StateAdvisoryDefinition(eventId);
    }

    @Override
    public void addProperty(ServiceConfigurationProperty property) throws ServiceConfigurationException {
        if ((property.getType().equals((Object)ServicePropertyType.JDBC_FACTORY) || property.getType().equals((Object)ServicePropertyType.TRANSPORT_FACTORY) || property.getType().equals((Object)ServicePropertyType.CLIENT_FACTORY)) && !this.existsAdvisory("advisory.connection.StateChange")) {
            this.addAdvisory("advisory.connection.StateChange");
            Trace.logDebug(this, "Added configuration advisory 'advisory.connection.StateChange'.");
        }
        this.propertiesRegistry.addProperty(property);
        this.touch();
        Trace.logDebug(this, "Added configuration property '" + property.getName() + "' (" + property.getClass().getName() + ").");
    }

    @Override
    public void removeProperty(String name) throws ServiceConfigurationException {
        boolean hasFactory = false;
        this.propertiesRegistry.removeProperty(name);
        for (ServiceConfigurationProperty p : this.getProperties()) {
            if (p.getType() != ServicePropertyType.JDBC_FACTORY && p.getType() != ServicePropertyType.TRANSPORT_FACTORY && p.getType() != ServicePropertyType.CLIENT_FACTORY) continue;
            hasFactory = true;
        }
        if (!hasFactory && this.existsAdvisory("advisory.connection.StateChange")) {
            this.removeAdvisory("advisory.connection.StateChange");
        }
        this.touch();
        Trace.logDebug(this, "Removed configuration property '" + name + "'.");
    }

    @Override
    public ServiceConfigurationProperty getProperty(String name) throws ServiceConfigurationException {
        return this.propertiesRegistry.getProperty(name);
    }

    @Override
    public List<String> getPropertyNames() {
        return this.propertiesRegistry.getPropertyNames();
    }

    @Override
    public void removeAllProperties() {
        this.propertiesRegistry.removeAllProperties();
        this.touch();
    }

    @Override
    public List<ServiceConfigurationProperty> getProperties() {
        return this.propertiesRegistry.getProperties();
    }

    @Override
    public void setValidatorName(String validatorClassName) {
        this.validatorClass = validatorClassName;
        this.touch();
    }

    @Override
    public String getValidatorName() {
        return this.validatorClass;
    }

    @Override
    public boolean hasProperty(String name) {
        return this.propertiesRegistry.hasProperty(name);
    }

    @Override
    public ServiceConfigurationValidatorResults validate() {
        try {
            AbstractServiceConfigurationValidator validator = (AbstractServiceConfigurationValidator)ClassUtils.createFromClassName((Object)this, this.getValidatorName(), true);
            validator.setProperties(this.getServiceConfigurationProperties());
            Trace.logDebug(this, "Service validator '" + this.getValidatorName() + "' triggered..");
            return validator.validate();
        }
        catch (UtilitiesException ex) {
            Trace.logDebug(this, "Service validator Utility Exception: " + ex.getMessage());
            ServiceConfigurationValidatorResults results = new ServiceConfigurationValidatorResults();
            ServiceConfigurationValidatorResults.ValidatorResult rs = new ServiceConfigurationValidatorResults.ValidatorResult("Validator Class", 3, ex.getMessage());
            results.addResult(rs);
            return results;
        }
    }

    @Override
    public String getDefaultPropertyGroup() {
        return "main.group";
    }

    @Override
    public void addPropertyGroup(String groupName) {
        this.getServiceConfigurationProperties().addPropertyGroup(groupName);
        this.touch();
        Trace.logDebug(this, "Added configuration property group '" + groupName + "'.");
    }

    @Override
    public void removePropertyGroup(String groupName) {
        this.getServiceConfigurationProperties().removePropertyGroup(groupName);
        this.touch();
        Trace.logDebug(this, "Removed configuration property group '" + groupName + "'.");
    }

    @Override
    public boolean existsPropertyGroup(String groupName) {
        return this.getServiceConfigurationProperties().existsPropertyGroup(groupName);
    }

    @Override
    public List<String> getPropertyGroups() {
        return this.getServiceConfigurationProperties().getPropertyGroups();
    }

    @Override
    public List<ServiceConfigurationProperty> getPropertiesForGroup(String groupName) throws ServiceConfigurationException {
        return this.getServiceConfigurationProperties().getPropertiesForGroup(groupName);
    }

    @Override
    public void setDefaults() {
        for (ServiceConfigurationProperty property : this.getProperties()) {
            property.applyDefault();
        }
        this.touch();
        Trace.logDebug(this, "Configuration defaults set.");
    }

    @Override
    public ServiceConfigurationProperties getServiceConfigurationProperties() {
        return this.propertiesRegistry;
    }

    @Override
    public boolean hasEventHandlers() {
        return this.eventHandlersRegistry.hasEventHandlers();
    }

    @Override
    public void addEventHandler(EventHandler evh) throws ServiceConfigurationException {
        this.eventHandlersRegistry.addEventHandler(evh);
        if (evh.getResponseEventId() != null && evh.getResponseEventId().length() > 0 && !this.existsActionableEvent(evh.getResponseEventId())) {
            this.actionableEventsRegistry.addActionableEvent(evh.getResponseEventId());
        }
        this.touch();
        Trace.logDebug(this, "Added Event Handler eventId: " + evh.getRequestEventId() + ", method : " + evh.getMethodName() + "().");
    }

    @Override
    public void removeEventHandler(String evhName) throws ServiceConfigurationException {
        String actionable = this.getEventHandler(evhName).getResponseEventId();
        this.eventHandlersRegistry.removeEventHandler(evhName);
        boolean shared = false;
        for (EventHandler handler : this.getEventHandlers()) {
            if (!handler.getResponseEventId().equals(actionable)) continue;
            shared = true;
        }
        if (!shared && this.existsActionableEvent(actionable)) {
            this.removeActionableEvent(actionable);
        }
        this.touch();
        Trace.logDebug(this, "Removed configuration event handler: " + evhName + "().");
    }

    @Override
    public EventHandler getEventHandler(String evhName) throws ServiceConfigurationException {
        return this.eventHandlersRegistry.getEventHandler(evhName);
    }

    @Override
    public List<EventHandler> getEventHandlers() {
        return this.eventHandlersRegistry.getEventHandlers();
    }

    @Override
    public List<String> listEventHandlers() {
        return this.eventHandlersRegistry.listEventHandlers();
    }

    @Override
    public void removeAllEventHandlers() {
        for (String handler : this.listEventHandlers()) {
            try {
                this.removeEventHandler(handler);
            }
            catch (ServiceConfigurationException ex) {
                throw new ServiceRuntimeException(ex);
            }
        }
        this.touch();
    }

    @Override
    public boolean existsEventHandler(String evhName) {
        return this.eventHandlersRegistry.existsEventHandler(evhName);
    }

    @Override
    public List<String> listSinkEvents() {
        return this.eventHandlersRegistry.listSinkEvents();
    }

    @Override
    public boolean hasSinkEvents() {
        return this.eventHandlersRegistry.hasSinkEvents();
    }

    @Override
    public EventTriggerData getEventTriggerData(String triggerName) {
        return this.eventTriggersRegistry.getEventTriggerData(triggerName);
    }

    public void addEventTriggerData(EventTriggerData eventTriggerData) throws ServiceConfigurationException {
        this.eventTriggersRegistry.addEventTriggerData(eventTriggerData);
        this.touch();
    }

    @Override
    public void addEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.eventTriggersRegistry.addEventTrigger(triggerName);
        this.touch();
    }

    @Override
    public void removeEventTrigger(String triggerName) throws ServiceConfigurationException {
        this.eventTriggersRegistry.removeEventTrigger(triggerName);
        this.touch();
    }

    @Override
    public void removeAllEventTriggers() {
        this.eventTriggersRegistry.removeAllEventTriggers();
        this.touch();
    }

    @Override
    public boolean hasEventTriggers() {
        return this.eventTriggersRegistry.hasEventTriggers();
    }

    @Override
    public boolean existsEventTrigger(String triggerName) {
        return this.eventTriggersRegistry.existsEventTrigger(triggerName);
    }

    @Override
    public List<String> listEventTriggers() {
        return this.eventTriggersRegistry.listEventTriggers();
    }

    @Override
    public void addAdvancedProperty(ConfigurationProperty property) {
        this.advancedPropertiesRegistry.addAdvancedProperty(property);
        this.touch();
    }

    @Override
    public void removeAdvancedProperty(String propertyName) {
        this.advancedPropertiesRegistry.removeAdvancedProperty(propertyName);
        this.touch();
    }

    @Override
    public List<ConfigurationProperty> getAdvancedProperties() {
        return this.advancedPropertiesRegistry.getAdvancedProperties();
    }

    @Override
    public List<String> listAdvancedProperties() {
        return this.advancedPropertiesRegistry.listAdvancedProperties();
    }

    @Override
    public String lookupAdvancedProperty(String propertyName) {
        return this.advancedPropertiesRegistry.lookupAdvancedProperty(propertyName);
    }

    @Override
    public ConfigurationProperty getAdvancedProperty(String propertyName) {
        return this.advancedPropertiesRegistry.getAdvancedProperty(propertyName);
    }

    @Override
    public void removeAllAdvancedProperties() {
        this.advancedPropertiesRegistry.removeAllAdvancedProperties();
        this.touch();
    }

    @Override
    public boolean hasAdvancedProperties() {
        return this.advancedPropertiesRegistry.hasAdvancedProperties();
    }

    @Override
    public boolean existsAdvancedProperty(String propertyName) {
        return this.advancedPropertiesRegistry.existsAdvancedProperty(propertyName);
    }

    @Override
    public Date getTimestamp() {
        return new Date(this.configTimeStamp);
    }

    @Override
    public void touch() {
        this.configTimeStamp = System.currentTimeMillis();
    }

    @Override
    public void addActionableEvent(String eventId) throws ServiceConfigurationException {
        if (this.actionableEventsRegistry.existsActionableEvent(eventId)) {
            throw new ServiceConfigurationException("Actionable event [" + eventId + "] already defined.");
        }
        this.actionableEventsRegistry.addActionableEvent(eventId);
        this.touch();
    }

    @Override
    public void setActionableEventId(String oldId, String newId) throws ServiceConfigurationException {
        if (!this.actionableEventsRegistry.existsActionableEvent(oldId)) {
            throw new ServiceConfigurationException("Actionable event [" + oldId + "] not defined.");
        }
        this.actionableEventsRegistry.setActionableEventId(oldId, newId);
        this.touch();
    }

    @Override
    public void removeActionableEvent(String eventId) throws ServiceConfigurationException {
        if (!this.actionableEventsRegistry.existsActionableEvent(eventId)) {
            throw new ServiceConfigurationException("Actionable event [" + eventId + "] not defined.");
        }
        this.actionableEventsRegistry.removeActionableEvent(eventId);
        this.touch();
    }

    @Override
    public void removeAllActionableEvents() {
        this.actionableEventsRegistry.removeAllActionableEvents();
        this.touch();
    }

    @Override
    public List<String> listActionableEvents() {
        return this.actionableEventsRegistry.listActionableEvents();
    }

    @Override
    public boolean hasActionableEvents() {
        return this.actionableEventsRegistry.hasActionableEvents();
    }

    @Override
    public boolean existsActionableEvent(String eventId) {
        return this.actionableEventsRegistry.existsActionableEvent(eventId);
    }

    @Override
    public List<String> listExceptions() {
        return this.exceptionsRegistry.listExceptions();
    }

    @Override
    public boolean hasExceptions() {
        return this.exceptionsRegistry.hasExceptions();
    }

    @Override
    public boolean existsException(String eventId) {
        return this.exceptionsRegistry.existsException(eventId);
    }

    @Override
    public void addException(String eventId) throws ServiceConfigurationException {
        this.exceptionsRegistry.addException(eventId);
    }

    @Override
    public void removeException(String eventId) throws ServiceConfigurationException {
        this.exceptionsRegistry.removeException(eventId);
    }

    @Override
    public void removeAllExceptions() {
        this.exceptionsRegistry.removeAllExceptions();
    }

    @Override
    public Object clone() {
        AbstractServiceConfigurationObject result = (AbstractServiceConfigurationObject)super.clone();
        result.propertiesRegistry = this.propertiesRegistry != null ? (ConfigurationProperties)this.propertiesRegistry.clone() : null;
        result.advancedPropertiesRegistry = this.advancedPropertiesRegistry != null ? (AdvancedProperties)this.advancedPropertiesRegistry.clone() : null;
        result.metricsRegistry = this.metricsRegistry != null ? (Metrics)this.metricsRegistry.clone() : null;
        result.advisoriesRegistry = this.advisoriesRegistry != null ? (AdvisoryEvents)this.advisoriesRegistry.clone() : null;
        result.eventTriggersRegistry = this.eventTriggersRegistry != null ? (EventTriggers)this.eventTriggersRegistry.clone() : null;
        result.actionableEventsRegistry = this.actionableEventsRegistry != null ? (ActionableEvents)this.actionableEventsRegistry.clone() : null;
        result.eventHandlersRegistry = this.eventHandlersRegistry != null ? (EventHandlers)this.eventHandlersRegistry.clone() : null;
        result.exceptionsRegistry = this.exceptionsRegistry != null ? this.exceptionsRegistry.clone() : null;
        return result;
    }
}

