/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.osf.clients;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sef.network.http.server.apicustomizer.UriMatcher;
import com.streamscape.service.osf.clients.ClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;

public abstract class AbstractClientConnection
implements ClientConnection {
    protected ClientFactory factory;
    private String name;
    private boolean suspended;
    private boolean primary;
    private ConnectionState state = ConnectionState.CLOSED;
    private Logger serviceLogger;
    private ExceptionEventListener exceptionEventListener;
    private StateNotificationEventListener stateNotificationEventListener;

    protected AbstractClientConnection() {
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void suspend() {
        this.suspended = true;
    }

    @Override
    public void resume() {
        this.suspended = false;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public boolean isActive() {
        return this.state == ConnectionState.OPEN;
    }

    @Override
    public ConnectionState getState() {
        return this.state;
    }

    @Override
    public void setServiceLogger(Logger logger) {
        this.serviceLogger = logger;
    }

    @Override
    public Logger getServiceLogger() {
        return this.serviceLogger;
    }

    @Override
    public void setStateNotificationEventListener(StateNotificationEventListener listener) {
        this.stateNotificationEventListener = listener;
    }

    @Override
    public StateNotificationEventListener getStateNotificationEventListener() {
        return this.stateNotificationEventListener;
    }

    @Override
    public void setExceptionEventListener(ExceptionEventListener listener) {
        this.exceptionEventListener = listener;
    }

    @Override
    public ExceptionEventListener getExceptionEventListener() {
        return this.exceptionEventListener;
    }

    protected void setState(ConnectionState state) {
        boolean wasUpdated = this.state != state;
        this.state = state;
        if (this.stateNotificationEventListener != null && wasUpdated) {
            ConnectionStateChangeAdvisory e = new ConnectionStateChangeAdvisory();
            e.setConnectionName(this.getName());
            e.setMessage("Connection State Changed to " + state.name());
            e.setState(state);
            e.setConnectionUrl(this.getUrl());
            this.stateNotificationEventListener.onEvent(e);
        }
    }

    protected abstract String getUrl();

    protected String getProperty(ClientFactory factory, String property) {
        return factory.getProperty(property);
    }

    protected int getIntProperty(ClientFactory factory, String property, int defaultValue) {
        return factory.getProperty(property) != null ? new Integer(factory.getProperty(property)) : defaultValue;
    }

    protected boolean getBooleanProperty(ClientFactory factory, String property, boolean defaultValue) {
        return factory.getProperty(property) != null ? Boolean.valueOf(factory.getProperty(property)) : defaultValue;
    }

    protected String getUrlProtocol(String url) throws ClientException {
        return this.getUrlProtocol(url, null);
    }

    protected String getUrlProtocol(String url, String defaultProtocol) throws ClientException {
        if (url == null) {
            throw new ClientException(1004, "URL is null.");
        }
        int pos = url.indexOf("://");
        if (pos == -1 && defaultProtocol != null) {
            return defaultProtocol;
        }
        if (pos == -1) {
            throw new ClientException(1006, "No protocol found in URL '" + url + "'.");
        }
        return url.substring(0, pos);
    }

    protected String getUrlHost(String url) throws ClientException {
        return this.getUrlHostPort(url, true);
    }

    protected int getUrlPort(String url) throws ClientException {
        return this.getUrlPort(url, -1);
    }

    protected int getUrlPort(String url, int defaultPort) throws ClientException {
        try {
            return Integer.valueOf(this.getUrlHostPort(url, false, defaultPort));
        }
        catch (Exception exception) {
            throw new ClientException(1006, "Invalid port in url '" + url + "'.");
        }
    }

    private String getUrlHostPort(String url, boolean host) throws ClientException {
        return this.getUrlHostPort(url, host, -1);
    }

    private String getUrlHostPort(String url, boolean host, int defaultPort) throws ClientException {
        if (url == null) {
            throw new ClientException(1004, "URL is null.");
        }
        int pos = url.indexOf("://");
        pos = pos == -1 ? 0 : (pos += 3);
        int pos1 = url.indexOf(":", pos);
        if (pos1 + 1 >= url.length()) {
            throw new ClientException(1006, "Invalid URL format '" + url + "', unexpected end of URL.");
        }
        if (host) {
            if (pos1 == -1) {
                pos1 = url.length();
            }
            return UriMatcher.normalizeUriWithLastSlashRemove(url.substring(pos, pos1));
        }
        if (pos1 == -1) {
            if (defaultPort != -1) {
                return String.valueOf(defaultPort);
            }
            throw new ClientException(1006, "Invalid URL format '" + url + "', port is missing.");
        }
        return url.substring(pos1 + 1);
    }

    protected void logError(String message) {
        if (this.serviceLogger != null) {
            this.serviceLogger.logError(message);
        } else {
            Trace.logError(this, this.buildTraceMessage(message));
        }
    }

    protected void logDebug(String message) {
        if (this.serviceLogger != null) {
            this.serviceLogger.logDebug(message);
        } else {
            Trace.logDebug(this, this.buildTraceMessage(message));
        }
    }

    protected void logInfo(String message) {
        if (this.serviceLogger != null) {
            this.serviceLogger.logInfo(message);
        } else {
            Trace.logInfo(this, this.buildTraceMessage(message));
        }
    }

    private String buildTraceMessage(String message) {
        return "[" + (String)(this.factory != null ? this.factory.getFactoryType() + "." + this.factory.getFactoryName() + "/" : "") + this.getName() + "] " + message;
    }
}

