/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.utils;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.JVM;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializer;
import com.streamscape.omf.serializer.Serializer;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.DeltaEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.utils.WrongParameterException;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Utils
extends com.streamscape.lib.utils.Utils {
    private static final String KILL_COMMAND = JVM.isWindowsOS() ? "taskkill /F /PID " : "kill -9 ";
    private static final String WHERE_COMMAND = JVM.isWindowsOS() ? "where " : "which ";

    public static void check(boolean condition, Exception exception) throws Exception {
        if (!condition) {
            throw exception;
        }
    }

    public static void check(boolean condition, String exceptionMessage) throws FabricException {
        if (!condition) {
            throw new FabricException(exceptionMessage);
        }
    }

    public static void checkParameter(boolean condition, String parameterName, String reason) throws FabricException {
        if (!condition) {
            throw new WrongParameterException(parameterName, reason);
        }
    }

    public static <TValue extends Number> double mean(List<TValue> values) {
        return values.stream().mapToDouble(Number::doubleValue).sum() / (double)values.size();
    }

    public static <TValue extends Number> double calculateMeanValue(List<TValue> values) {
        if (values.size() > 2) {
            ArrayList<TValue> valuesCopy = new ArrayList<TValue>(values);
            Collections.sort(valuesCopy);
            return Utils.mean(valuesCopy.subList(1, values.size() - 1));
        }
        return Utils.mean(values);
    }

    public static String toString(byte[] bytes, String delimiter) {
        return bytes != null ? Utils.toString(bytes, bytes.length, delimiter) : null;
    }

    public static String toString(byte[] bytes, int bytesNumber, String delimiter) {
        if (bytes == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < bytesNumber && i < bytes.length; ++i) {
            if (i > 0) {
                buffer.append(delimiter);
            }
            buffer.append(bytes[i]);
        }
        return buffer.toString();
    }

    public static File createDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    public static File createDirectory(String directoryName) {
        return Utils.createDirectory(new File(directoryName));
    }

    public static File createDirectory(File rootDirectory, String directoryName) {
        Utils.createDirectory(rootDirectory);
        return Utils.createDirectory(new File(rootDirectory, directoryName));
    }

    public static File createTFCache(File rootDirectory) {
        File tfcacheDirectory = rootDirectory != null ? new File(rootDirectory, ".tfcache") : new File(".tfcache");
        Utils.createDirectory(tfcacheDirectory);
        Utils.createDirectory(tfcacheDirectory, "artifacts");
        Utils.createDirectory(tfcacheDirectory, "clients");
        Utils.createDirectory(tfcacheDirectory, "ext");
        Utils.createDirectory(tfcacheDirectory, "globals");
        Utils.createDirectory(tfcacheDirectory, "jdbc");
        Utils.createDirectory(tfcacheDirectory, "lib");
        Utils.createDirectory(tfcacheDirectory, "objects/sys");
        Utils.createDirectory(tfcacheDirectory, "pkg");
        Utils.createDirectory(tfcacheDirectory, "services");
        Utils.createDirectory(tfcacheDirectory, "transports");
        Utils.createDirectory(tfcacheDirectory, "types");
        return tfcacheDirectory;
    }

    public static File createTFCache(String rootDirectoryName) {
        return Utils.createTFCache(new File(rootDirectoryName));
    }

    public static void addAlias(Class aliasedClass) throws FactoryManagerException {
        Utils.addAlias(aliasedClass, XSerializerFactory.getInstance());
    }

    public static void addAlias(Class aliasedClass, XSerializerFactory xFactory) throws FactoryManagerException {
        Utils.addAlias(aliasedClass.getSimpleName(), aliasedClass, xFactory);
    }

    public static void addAlias(String alias, Class aliasedClass) throws FactoryManagerException {
        Utils.addAlias(alias, aliasedClass, XSerializerFactory.getInstance());
    }

    public static void addAlias(String alias, Class aliasedClass, XSerializerFactory xFactory) throws FactoryManagerException {
        if (!xFactory.isAliased(alias)) {
            SemanticType type = new SemanticType(alias, aliasedClass.getName());
            type.setInterface(aliasedClass.isInterface());
            type.setDescription("Generated (transient) alias definition.");
            xFactory.alias(type);
        }
    }

    public static Object readObjectFromXML(String filename) throws FabricException {
        return Utils.readObject(filename, XSerializerFactory.getInstance().getDefaultSerializer());
    }

    public static Object readObjectFromXML(String filename, DataInputStream stream) throws FabricException {
        return Utils.readObject(filename, stream, XSerializerFactory.getInstance().getDefaultSerializer());
    }

    public static Object readObject(String filename, Serializer serializer) throws FabricException {
        try {
            return serializer.deserialize(FileIOUtils.getFileContent(new File(filename)));
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof FileNotFoundException) {
                throw new FabricException("File '" + filename + "' not found.", exception.getCause());
            }
            throw new FabricException("Reading object from file '" + filename + "' failed.", exception);
        }
    }

    public static Object readObject(String filename, DataInputStream stream, Serializer serializer) throws FabricException {
        try {
            return serializer.deserialize(stream);
        }
        catch (Exception exception) {
            throw new FabricException("Reading object from file '" + filename + "' failed.", exception);
        }
    }

    public static void writeObjectToXML(Object object, String filename) throws FabricException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filename);
            Utils.writeObjectToXML(object, filename, stream);
            stream.close();
        }
        catch (IOException exception) {
            throw new FabricException("Writing object to file '" + filename + "' failed.", exception);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeObjectToXML(Object object, String filename, FileOutputStream stream) throws FabricException {
        try {
            stream.write(XSerializerFactory.getInstance().getDefaultSerializer().serialize(object).getBytes());
        }
        catch (Exception exception) {
            throw new FabricException("Writing object to file '" + filename + "' failed.", exception);
        }
    }

    public static void writeObject(Object object, String filename, Serializer serializer) throws FabricException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(filename);
            Utils.writeObject(object, filename, stream, serializer);
            stream.close();
        }
        catch (IOException exception) {
            throw new FabricException("Writing object to file '" + filename + "' failed.", exception);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void writeObject(Object object, String filename, FileOutputStream stream, Serializer serializer) throws FabricException {
        try {
            stream.write(serializer instanceof JSerializer ? ((JSerializer)serializer).serialize(object) : ((TextSerializer)serializer).serialize(object).getBytes());
        }
        catch (Exception exception) {
            throw new FabricException("Writing object to file '" + filename + "' failed.", exception);
        }
    }

    public static boolean equals(Object object1, Object object2) {
        return object1 != null ? object2 != null && object1.equals(object2) : object2 == null;
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 != null ? str2 != null && str1.equalsIgnoreCase(str2) : str2 == null;
    }

    public static void bindAdvisoryPrototype(String model, String eventId, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addAdvisoryPrototype(model, eventId);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindAdvisoryPrototype(String eventId, AdvisoryEventDatagram event, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addAdvisoryPrototype(eventId, event);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindEventPrototype(String model, String eventId, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addEventPrototype(model, eventId);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindEventPrototype(String eventId, EventDatagram event, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addEventPrototype(eventId, event);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindDataEventPrototype(String eventId, String dataType, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addDataEventPrototype(eventId, dataType);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindDataEventPrototype(String eventId, CloneableDataObject data, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addDataEventPrototype(eventId, data);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindDataEventPrototype(String eventId, DataEvent event, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addDataEventPrototype(eventId, event);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindDeltaEventPrototype(String eventId, String dataType, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addDeltaEventPrototype(eventId, dataType);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindDeltaEventPrototype(String eventId, CloneableDataObject data, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addDeltaEventPrototype(eventId, data);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindDeltaEventPrototype(String eventId, DeltaEvent event, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addDeltaEventPrototype(eventId, event);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindOpaqueEventPrototype(String eventId, String dataType, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addOpaqueEventPrototype(eventId, dataType);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindOpaqueEventPrototype(String eventId, CloneableDataObject data, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addOpaqueEventPrototype(eventId, data);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindOpaqueEventPrototype(String eventId, OpaqueEvent event, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addOpaqueEventPrototype(eventId, event);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindExceptionPrototype(String model, String eventId, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addExceptionPrototype(model, eventId);
            connection.bindProducerFor(eventId);
        }
    }

    public static void bindExceptionPrototype(String eventId, ExceptionEventDatagram event, FabricConnection connection) throws DatagramFactoryException, FabricConnectionException, FabricEventDispatcherException {
        if (!connection.isBoundEventId(eventId)) {
            SDOUtils.addExceptionPrototype(eventId, event);
            connection.bindProducerFor(eventId);
        }
    }

    public static void killProcess(long pid) throws Exception {
        Runtime.getRuntime().exec(KILL_COMMAND + pid).waitFor();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getExecutablePath(String command) {
        try {
            Process process = Runtime.getRuntime().exec(WHERE_COMMAND + command);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String exePath = in.readLine();
                if (exePath == null) return null;
                if (exePath.isEmpty()) return null;
                File exeFile = new File(exePath);
                String string = exeFile.isFile() ? exeFile.getParentFile().getCanonicalPath() : null;
                return string;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static interface Consumer<T> {
        public void accept(T var1) throws Exception;
    }

    public static interface Supplier<T> {
        public T get() throws Exception;
    }

    public static interface Function<T, R> {
        public R apply(T var1) throws Exception;
    }

    public static interface Runnable {
        public void run() throws Exception;
    }
}

