/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.utils;

import com.streamscape.Trace;
import com.streamscape.lib.jar.JarFile;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.loader.MemoryJarFile;
import com.streamscape.lib.loader.TFCacheJarStorage;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.mapper.SemanticMap;
import com.streamscape.omf.mapper.SemanticMapRepositoryUtils;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.type.DescribeTypeOperation;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.PrototypeFactory;
import com.streamscape.sdo.mf.admin.SemanticTypeCache;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestException;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.utils.SemanticTypeInfo;
import com.streamscape.sef.utils.Utils;
import com.streamscape.slex.lang.FeedbackOperationInvoker;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SemanticUtils
extends Utils {
    private static final String CLASS_SUFFIX = ".class";
    private static final int CLASS_SUFFIX_LENGTH = ".class".length();

    public static List<String> listDependentTypes(SemanticType type, FabricContext context) {
        return context.getSemanticTypeCache().listDependentSemanticTypes(type.getTypeName());
    }

    public static List<String> listDependentEventIds(SemanticType type, FabricContext context) {
        return context.getDatagramPrototypeCache().listEventIdsByDataType(type);
    }

    public static List<String> listDependentEventIds(List<SemanticType> types, FabricContext context) {
        ArrayList<String> result = new ArrayList<String>();
        types.stream().map(type -> SemanticUtils.listDependentEventIds(type, context)).forEach(result::addAll);
        return result;
    }

    public static List<String> listDependentServices(SemanticType type, RuntimeContext context) {
        ArrayList<String> services = new ArrayList<String>();
        RepositoryAccessor accessor = context.getRepositoryAccessor();
        try {
            for (String serviceType : accessor.listServiceTypes()) {
                for (String serviceName : accessor.listServicesByType(serviceType)) {
                    try {
                        String serviceFullName;
                        FabricComponent component;
                        ServiceConfigurationObject sco;
                        if (serviceName.equalsIgnoreCase("prototype") || !(sco = (component = context.lookupComponentByFQName(serviceFullName = ServiceDescriptor.getFullName(serviceType, serviceName))) instanceof ServiceContext ? ((ServiceContext)component).getServiceConfiguration() : accessor.loadServiceConfiguration(serviceName, serviceType)).getEventHandlers().stream().anyMatch(handler -> handler.getRequestSemanticType() != null && handler.getRequestSemanticType().equals(type.getTypeName()) || handler.getResponseSemanticType() != null && handler.getResponseSemanticType().equals(type.getTypeName()))) continue;
                        services.add(serviceFullName);
                    }
                    catch (Exception exception) {
                        Trace.logException(Utils.class, exception, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(Utils.class, exception, false);
        }
        return services;
    }

    public static List<String> listDependentMappers(SemanticType type, RuntimeContext context) {
        ArrayList<String> dependentMappers = new ArrayList<String>();
        try {
            List<String> mappers = SemanticMapRepositoryUtils.listSemanticMaps();
            for (String mapper : mappers) {
                try {
                    SemanticMap semanticMap = SemanticMapRepositoryUtils.lookupSemanticMap(mapper);
                    if (semanticMap == null) {
                        Trace.logError(DescribeTypeOperation.class, "Loading semantic mapper '" + mapper + "' from repository failed.");
                        continue;
                    }
                    if (semanticMap.getTarget() != null && semanticMap.getTarget().getSemanticType().equals(type.getTypeName())) {
                        dependentMappers.add(SemanticMap.class.getSimpleName() + "." + mapper);
                        continue;
                    }
                    if (!semanticMap.getSources().stream().anyMatch(sourceObject -> sourceObject != null && sourceObject.getSemanticType().equals(type.getTypeName()))) continue;
                    dependentMappers.add(SemanticMap.class.getSimpleName() + "." + mapper);
                }
                catch (Exception exception) {
                    Trace.logException(Utils.class, exception, false);
                }
            }
        }
        catch (Exception exception) {
            Trace.logException(Utils.class, exception, false);
        }
        return dependentMappers;
    }

    public static Map<String, List<String>> getDependencies(SemanticType type, RuntimeContext context, boolean localOnly) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (type != null) {
            if (!localOnly) {
                SemanticUtils.putNonEmpty("Types", SemanticUtils.listDependentTypes(type, context), result);
                SemanticUtils.putNonEmpty("Events", SemanticUtils.listDependentEventIds(type, (FabricContext)context), result);
            }
            SemanticUtils.putNonEmpty("Services", SemanticUtils.listDependentServices(type, context), result);
            SemanticUtils.putNonEmpty("Artifacts", SemanticUtils.listDependentMappers(type, context), result);
            SemanticUtils.getDataspaceDependencies(type, context, result);
        }
        return result;
    }

    public static Map<String, List<String>> getDataspaceDependencies(SemanticType type, RuntimeContext context) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        SemanticUtils.getDataspaceDependencies(type, context, result);
        return result;
    }

    public static void getDataspaceDependencies(SemanticType type, RuntimeContext context, Map<String, List<String>> result) {
        HashMap<Integer, List<String>> references = context.getDataspaceManager().getSemanticTypeReferences(type);
        SemanticUtils.putNonEmpty("Collections", references.get(3), result);
        SemanticUtils.putNonEmpty("Functions", references.get(17), result);
        SemanticUtils.putNonEmpty("Actors", references.get(32), result);
        SemanticUtils.putNonEmpty("Triggers", references.get(9), result);
    }

    private static void putNonEmpty(String key, List<String> value, Map<String, List<String>> to) {
        if (!value.isEmpty()) {
            to.put(key, value);
        }
    }

    public static boolean hasDependencies(SemanticType type, RuntimeContext context, boolean localOnly) {
        return !localOnly && (!SemanticUtils.listDependentTypes(type, context).isEmpty() || !SemanticUtils.listDependentEventIds(type, (FabricContext)context).isEmpty()) || !SemanticUtils.listDependentServices(type, context).isEmpty() || !SemanticUtils.listDependentMappers(type, context).isEmpty() || SemanticUtils.hasDependentDataspaceEntities(type, context);
    }

    private static boolean hasDependentDataspaceEntities(SemanticType type, RuntimeContext context) {
        return context.getDataspaceManager().getSemanticTypeReferences(type).values().stream().anyMatch(entities -> !entities.isEmpty());
    }

    public static List<SemanticType> getRelatedSemanticTypes(String archiveName, boolean isExtArchive, RuntimeContext context) throws Exception {
        return SemanticUtils.getRelatedSemanticTypes(Arrays.asList(isExtArchive ? context.getRepositoryAccessor().getExtensionArchiveURL(archiveName) : context.getRepositoryAccessor().getArchiveURL(archiveName)), (FabricContext)context);
    }

    public static List<SemanticType> getRelatedSemanticTypes(Package pkg, RuntimeContext context) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jar : pkg.listJARs()) {
            urls.add(context.getRepositoryAccessor().getArchiveURL(jar));
        }
        return SemanticUtils.getRelatedSemanticTypes(urls, (FabricContext)context);
    }

    public static List<SemanticType> getRelatedSemanticTypes(PackageDescriptor descriptor, RuntimeContext context) throws Exception {
        Package pkg = context.getRepositoryAccessor().getPackage(descriptor.getPackageType(), descriptor.getPackageName());
        if (pkg == null) {
            throw new PackageManifestException("Package '" + descriptor.getFullName() + "' is not found in repository.");
        }
        return SemanticUtils.getRelatedSemanticTypes(pkg, context);
    }

    public static List<SemanticType> getRelatedSemanticTypes(List<URL> urls, FabricContext context) throws Exception {
        ArrayList<SemanticType> result = new ArrayList<SemanticType>();
        for (URL url : urls) {
            SemanticUtils.getRelatedSemanticTypes(url, context, result);
        }
        return result;
    }

    public static List<SemanticType> getRelatedSemanticTypes(byte[] jarContent, FabricContext context) throws Exception {
        ArrayList<SemanticType> result = new ArrayList<SemanticType>();
        SemanticUtils.doGetRelatedSemanticTypes(new MemoryJarFile(jarContent).listEntries(), context, result);
        return result;
    }

    private static void getRelatedSemanticTypes(URL url, FabricContext context, List<SemanticType> result) throws Exception {
        SemanticUtils.doGetRelatedSemanticTypes(SemanticUtils.getJarFile(url).listEntries(), context, result);
    }

    private static void doGetRelatedSemanticTypes(List<String> entries, FabricContext context, List<SemanticType> result) throws Exception {
        SemanticTypeCache typeCache = context.getSemanticTypeCache();
        entries.stream().filter(entry -> entry.endsWith(CLASS_SUFFIX)).map(entry -> entry.substring(0, entry.length() - CLASS_SUFFIX_LENGTH).replace('/', '.')).map(typeCache::lookupSemanticClass).filter(Objects::nonNull).forEach(result::add);
    }

    public static JarFile getExtJarFile(String jarName, RuntimeContext context) throws Exception {
        return SemanticUtils.getJarFile(context.getRepositoryAccessor().getExtensionArchiveURL(jarName));
    }

    public static JarFile getLibJarFile(String jarName, RuntimeContext context) throws Exception {
        return SemanticUtils.getJarFile(context.getRepositoryAccessor().getArchiveURL(jarName));
    }

    public static JarFile getJarFile(URL url) throws Exception {
        try {
            return new JarFile(TFCacheJarStorage.getInstance().getJarFile(url));
        }
        catch (IOException ignored) {
            try {
                return new JarFile(new File(".tfcache/" + url.getFile()));
            }
            catch (IOException exception) {
                throw new UtilitiesException("Loading archive '" + String.valueOf(url) + "' from cache failed.", exception);
            }
        }
    }

    public static SemanticTypeInfo getSemanticTypeInfo(SemanticType type, RuntimeContext context) {
        if (SemanticUtils.getInfo(type) != null) {
            return SemanticUtils.getInfo(type);
        }
        if (!type.isSystem()) {
            try {
                return SemanticUtils.doGetSemanticTypeInfo(type, ClassUtils.loadClass(type.getClassName(), context.getSystemClassLoaderChain()).getClassLoader(), context);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exception) {
                try {
                    String jar = SemanticUtils.getLibArchiveByClass(type.getClassName(), SemanticUtils.listLoadedLibArchives(context), context);
                    return new SemanticTypeInfo(type, null, jar != null ? context.getPackageManifestManager().getPackageByArchive(jar) : null, jar);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new SemanticTypeInfo(type, null, null, null);
    }

    public static SemanticTypeInfo getSemanticTypeInfo(String className, RuntimeContext context) {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(className);
        return type != null && type.isSystem() ? new SemanticTypeInfo(type, null, null, null) : SemanticUtils.doGetSemanticTypeInfo(type, className, context);
    }

    public static SemanticTypeInfo getSemanticTypeInfo(Class cls, RuntimeContext context) {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(cls);
        if (type == null || !type.isSystem()) {
            try {
                return SemanticUtils.doGetSemanticTypeInfo(type, cls.getClassLoader(), context);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new SemanticTypeInfo(type, null, null, null);
    }

    private static SemanticTypeInfo doGetSemanticTypeInfo(SemanticType type, String className, RuntimeContext context) {
        try {
            return SemanticUtils.doGetSemanticTypeInfo(type, ClassUtils.loadClass(className, context.getSystemClassLoaderChain()).getClassLoader(), context);
        }
        catch (ClassNotFoundException | NoClassDefFoundError exception) {
            try {
                String jar = SemanticUtils.getLibArchiveByClass(className, SemanticUtils.listLoadedLibArchives(context), context);
                return new SemanticTypeInfo(type, null, jar != null ? context.getPackageManifestManager().getPackageByArchive(jar) : null, jar);
            }
            catch (Throwable throwable) {
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new SemanticTypeInfo(type, null, null, null);
    }

    private static SemanticTypeInfo doGetSemanticTypeInfo(SemanticType type, ClassLoader classLoader, RuntimeContext context) throws Exception {
        if (classLoader instanceof FabricClassLoader) {
            FabricClassLoader fabricLoader = (FabricClassLoader)classLoader;
            if (fabricLoader.getPackageDescriptor() != null) {
                List<String> jars = fabricLoader.getPackage().listJARs();
                String jar = jars.size() == 1 ? jars.get(0) : SemanticUtils.getLibArchiveByClass(type.getClassName(), fabricLoader.getPackage(), context);
                return new SemanticTypeInfo(type, null, fabricLoader.getPackageDescriptor(), jar);
            }
            if (fabricLoader.getName().endsWith(".jar") && context.getRepositoryAccessor().existsExtensionArchive(fabricLoader.getName())) {
                return new SemanticTypeInfo(type, fabricLoader.getName(), null, null);
            }
        }
        return new SemanticTypeInfo(type, null, null, null);
    }

    public static boolean isSemanticTypeGlobal(SemanticType type, RuntimeContext context) {
        return type.isSystem() || SemanticUtils.getSemanticTypeInfo(type, context).isGlobal();
    }

    public static boolean isSemanticTypeGlobal(Class cls, RuntimeContext context) {
        ClassLoader classLoader = cls.getClassLoader();
        if (classLoader != null) {
            return SemanticUtils.getSemanticTypeInfo(cls, context).isGlobal();
        }
        SemanticType type = context.getSemanticTypeCache().lookupSemanticClass(cls.getName());
        return type != null && SemanticUtils.isSemanticTypeGlobal(type, context);
    }

    public static boolean isArchiveContainsClass(byte[] archive, String className) throws ArchiveException {
        return SemanticUtils.isArchiveContainsEntry(archive, SemanticUtils.convertToEntryName(className));
    }

    public static boolean isArchiveContainsEntry(byte[] archive, String entryName) throws ArchiveException {
        try {
            return new MemoryJarFile(archive).existsEntry(entryName);
        }
        catch (Exception exception) {
            throw new ArchiveException("Operation in memory archive failed.", exception);
        }
    }

    protected static String convertToEntryName(String className) {
        return MemoryJarFile.convertClassNameToPathInJar(className) + CLASS_SUFFIX;
    }

    public static String getLibArchiveByClass(String className, Package pkg, RuntimeContext context) throws Exception {
        for (String jar : pkg.listJARs()) {
            if (!SemanticUtils.existsClassInArchive(className, context.getRepositoryAccessor().getArchiveURL(jar))) continue;
            return jar;
        }
        return null;
    }

    public static String getLibArchiveByClass(String className, Set<String> excludedArchives, RuntimeContext context) throws Exception {
        RepositoryAccessor accessor = context.getRepositoryAccessor();
        for (String archive : accessor.listArchives()) {
            if (excludedArchives != null && excludedArchives.contains(archive) || !SemanticUtils.existsClassInArchive(className, accessor.getArchiveURL(archive))) continue;
            return archive;
        }
        return null;
    }

    public static boolean existsClassInArchive(String className, URL url) throws Exception {
        String classEntry = MemoryJarFile.convertClassNameToEntryInJar(className);
        return SemanticUtils.getJarFile(url).listEntries().stream().anyMatch(entry -> entry.equals(classEntry));
    }

    public static Set<String> listLoadedLibArchives(RuntimeContext context) {
        HashSet<String> result = new HashSet<String>();
        for (String pkgName : context.getPackageManifestManager().listLoadedPackages()) {
            try {
                Package pkg = context.getRepositoryAccessor().getPackage(pkgName);
                result.addAll(pkg.listJARs());
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public static void dropPackage(PackageType packageType, String packageName, boolean dropArchives, boolean dropTypes, boolean dropAll, boolean force, RuntimeContext context, FeedbackOperationInvoker feedback) throws Exception {
        if (dropTypes) {
            for (String jarName : context.getRepositoryAccessor().getPackage(packageType, packageName).listJARs()) {
                SemanticUtils.dropArchiveDependentEntities(jarName, false, force, dropAll, context, feedback);
            }
        }
        context.getRepositoryAccessor().removePackage(packageType, packageName, dropArchives);
    }

    public static void dropArchiveDependentEntities(String jarName, boolean isExt, boolean force, boolean dropAll, RuntimeContext context, FeedbackOperationInvoker feedback) throws Exception {
        List<SemanticType> types = SemanticUtils.getRelatedSemanticTypes(jarName, isExt, context);
        if (!force) {
            for (SemanticType type2 : types) {
                if (!context.getSemanticTypeFactory().hasDependencies(type2)) continue;
                throw new Exception("At least one semantic type of archive '" + jarName + "' has dependencies.");
            }
        }
        if (dropAll) {
            SemanticUtils.listDependentEventIds(types, (FabricContext)context).forEach(eventId -> {
                block3: {
                    try {
                        PrototypeFactory.removePrototype(eventId, force);
                        if (feedback != null) {
                            feedback.addFeedback("Event prototype [" + eventId + "] removed.");
                        }
                    }
                    catch (DatagramFactoryException exception) {
                        if (feedback == null) break block3;
                        feedback.addFeedback("Removing event prototype [" + eventId + "] failed. Cause: " + exception.getMessage());
                    }
                }
            });
        }
        types.forEach(type -> {
            block3: {
                try {
                    TypeFactory.removeSemanticType(type.getTypeName(), force);
                    if (feedback != null) {
                        feedback.addFeedback("Semantic type '" + type.getTypeName() + "' removed.");
                    }
                }
                catch (SemanticTypeFactoryException exception) {
                    if (feedback == null) break block3;
                    feedback.addFeedback("Removing semantic type '" + type.getTypeName() + "' failed. Cause: " + exception.getMessage());
                }
            }
        });
    }

    public static ArchiveDependencies getArchiveDependencies(String archiveName, boolean isExtArchive, RuntimeContext context) throws Exception {
        ArchiveDependencies result = SemanticUtils.doGetArchiveDependencies(SemanticUtils.getRelatedSemanticTypes(archiveName, isExtArchive, context), context);
        SemanticUtils.finalizeArchiveDependencies(result, Arrays.asList(archiveName));
        return result;
    }

    public static ArchiveDependencies getPackageDependencies(Package pkg, RuntimeContext context) throws Exception {
        ArchiveDependencies result = SemanticUtils.doGetArchiveDependencies(SemanticUtils.getRelatedSemanticTypes(pkg, context), context);
        SemanticUtils.finalizeArchiveDependencies(result, pkg.listJARs());
        return result;
    }

    private static ArchiveDependencies doGetArchiveDependencies(List<SemanticType> types, RuntimeContext context) throws Exception {
        SemanticTypeCache cache = context.getSemanticTypeCache();
        ArchiveDependencies result = new ArchiveDependencies();
        for (SemanticType type : types) {
            SemanticUtils.addArchiveDependency(cache.listComponentSemanticTypes(type.getTypeName()), context, result.backwardExt, result.backwardLib);
            SemanticUtils.addArchiveDependency(cache.listDependentSemanticTypes(type.getTypeName()), context, result.forwardExt, result.forwardLib);
        }
        return result;
    }

    private static void addArchiveDependency(List<String> types, RuntimeContext context, Set<String> extResult, Set<String> libResult) throws Exception {
        for (String typeName : types) {
            String className = context.getSemanticTypeCache().resolveSemanticType(typeName);
            if (className == null) continue;
            extResult.addAll(context.getClassLoaderRegistry().listExtArchivesByClass(className));
            libResult.addAll(context.getClassLoaderRegistry().listLibArchivesByClass(className, null));
        }
    }

    private static void finalizeArchiveDependencies(ArchiveDependencies dependencies, List<String> archiveNames) {
        archiveNames.forEach(archiveName -> {
            dependencies.backwardExt.remove(archiveName);
            dependencies.backwardLib.remove(archiveName);
            dependencies.forwardExt.remove(archiveName);
            dependencies.forwardLib.remove(archiveName);
        });
    }

    public static class ArchiveDependencies {
        public Set<String> backwardExt = new HashSet<String>();
        public Set<String> backwardLib = new HashSet<String>();
        public Set<String> forwardExt = new HashSet<String>();
        public Set<String> forwardLib = new HashSet<String>();
    }

    private static interface ArchivesGetter {
        public List<String> get(String var1) throws Exception;
    }
}

