/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.utils;

import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sef.dispatcher.AbstractRepositoryUtils;
import com.streamscape.sef.utils.DefaultObjectCreator;
import java.util.ArrayList;
import java.util.List;

public class RepositoryUtils
extends AbstractRepositoryUtils {
    public static synchronized <T> T lookupObject(String namespace, String objectName, T defaultObject) throws ObjectConfigurationException {
        return RepositoryUtils.doLookup(RepositoryUtils.getReferenceContext(namespace, false, true), objectName, defaultObject);
    }

    public static synchronized <T> T lookupObject(ReferenceContext referenceContext, String objectName, T defaultObject) throws ObjectConfigurationException {
        return RepositoryUtils.doLookup(referenceContext, objectName, defaultObject);
    }

    public static synchronized <T> T lookupObject(String namespace, String objectName, DefaultObjectCreator<T> creator) throws ObjectConfigurationException {
        return RepositoryUtils.lookupObject(RepositoryUtils.getReferenceContext(namespace, false, true), objectName, creator);
    }

    public static synchronized <T> T lookupObject(ReferenceContext referenceContext, String objectName, DefaultObjectCreator<T> creator) throws ObjectConfigurationException {
        T result = RepositoryUtils.lookupObject(referenceContext, objectName);
        if (result == null) {
            result = RepositoryUtils.lookupObject(referenceContext, objectName, creator != null ? (T)creator.createDefaultObject() : null);
        }
        return result;
    }

    private static <T> T doLookup(ReferenceContext referenceContext, String objectName, T defaultObject) throws ObjectConfigurationException {
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(referenceContext);
            if (!SemanticObjectReferenceStore.existsBinding(objectName)) {
                if (defaultObject != null) {
                    SemanticObjectReferenceStore.bind(objectName, defaultObject);
                }
            } else {
                defaultObject = SemanticObjectReferenceStore.lookup(objectName);
            }
            SemanticObjectReferenceStore.commitXact();
            return defaultObject;
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
    }

    public static synchronized <T> T lookupObject(ReferenceContext referenceContext, String objectName) throws ObjectConfigurationException {
        Object result;
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(referenceContext);
            result = SemanticObjectReferenceStore.lookup(objectName);
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
        return (T)result;
    }

    public static synchronized <T> T lookupObject(String namespace, String objectName) throws ObjectConfigurationException {
        ReferenceContext referenceContext = RepositoryUtils.getReferenceContext(namespace, false, false);
        if (referenceContext == null) {
            throw new ObjectConfigurationException("Namespace '" + namespace + "' does not exist.");
        }
        return RepositoryUtils.lookupObject(RepositoryUtils.getReferenceContext(namespace, false, false), objectName);
    }

    public static synchronized void bindObject(String namespace, Object object) throws ObjectConfigurationException {
        RepositoryUtils.bindObject(namespace, object.getClass().getSimpleName(), object);
    }

    public static synchronized void bindObject(String namespace, String objectName, Object object) throws ObjectConfigurationException {
        RepositoryUtils.bindObject(RepositoryUtils.getReferenceContext(namespace, false, true), objectName, object);
    }

    public static synchronized void bindObject(ReferenceContext referenceContext, String objectName, Object object) throws ObjectConfigurationException {
        boolean inXact = SemanticObjectReferenceStore.inXactByCurrentThread();
        try {
            if (!inXact) {
                SemanticObjectReferenceStore.beginXact();
            }
            SemanticObjectReferenceStore.setReferenceContext(referenceContext);
            if (SemanticObjectReferenceStore.existsBinding(objectName)) {
                SemanticObjectReferenceStore.rebind(objectName, object);
            } else {
                SemanticObjectReferenceStore.bind(objectName, object);
            }
            if (!inXact) {
                SemanticObjectReferenceStore.commitXact();
            }
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
    }

    public static synchronized boolean unbindObject(String namespace, String objectName) throws ObjectConfigurationException {
        ReferenceContext referenceContext = RepositoryUtils.getReferenceContext(namespace, false, false);
        return referenceContext != null && RepositoryUtils.unbindObject(referenceContext, objectName);
    }

    public static synchronized boolean unbindObject(ReferenceContext referenceContext, String objectName) throws ObjectConfigurationException {
        boolean result = false;
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(referenceContext);
            if (SemanticObjectReferenceStore.existsBinding(objectName)) {
                SemanticObjectReferenceStore.unbind(objectName);
                result = true;
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
        return result;
    }

    public static List<String> listObjects(String namespace) throws ObjectConfigurationException {
        ReferenceContext referenceContext = RepositoryUtils.getReferenceContext(namespace, false, false);
        return referenceContext != null ? RepositoryUtils.listObjects(referenceContext) : new ArrayList<String>();
    }

    public static List<String> listObjects(ReferenceContext referenceContext) throws ObjectConfigurationException {
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.setReferenceContext(referenceContext);
            List<String> result = SemanticObjectReferenceStore.listBoundNames(null);
            SemanticObjectReferenceStore.commitXact();
            return result;
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
    }

    public static synchronized boolean existsObject(String namespace, String objectName) throws ObjectConfigurationException {
        ReferenceContext referenceContext = RepositoryUtils.getReferenceContext(namespace, false, false);
        return referenceContext != null && RepositoryUtils.existsObject(referenceContext, objectName);
    }

    public static synchronized boolean existsObject(ReferenceContext referenceContext, String objectName) throws ObjectConfigurationException {
        boolean result = false;
        if (referenceContext != null) {
            try {
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.setReferenceContext(referenceContext);
                result = SemanticObjectReferenceStore.existsBinding(objectName);
                SemanticObjectReferenceStore.commitXact();
            }
            catch (ObjectConfigurationException exception) {
                SemanticObjectReferenceStore.abortXactSafe();
                throw exception;
            }
        }
        return result;
    }

    public static synchronized ReferenceContext getReferenceContext(String namespace, boolean inXact, boolean createIfAbsent) throws ObjectConfigurationException {
        ReferenceContext result;
        boolean inLocalXact = false;
        ReferenceContext rootContext = SemanticObjectReferenceStore.getReferenceContext();
        if (rootContext == null || !rootContext.isRoot()) {
            try {
                if (!inXact) {
                    inLocalXact = RepositoryUtils.beginXact();
                }
                SemanticObjectReferenceStore.setReferenceContext(ReferenceContext.ROOT);
            }
            catch (ObjectConfigurationException exception) {
                if (inLocalXact) {
                    SemanticObjectReferenceStore.abortXactSafe();
                }
                throw exception;
            }
        }
        if ((result = SemanticObjectReferenceStore.lookupReferenceContext(namespace)) == null && createIfAbsent) {
            try {
                if (!inLocalXact && !inXact) {
                    inLocalXact = RepositoryUtils.beginXact();
                }
                result = SemanticObjectReferenceStore.createSubcontextFromNamespace(namespace);
            }
            catch (ObjectConfigurationException exception) {
                if (inLocalXact) {
                    SemanticObjectReferenceStore.abortXactSafe();
                }
                throw exception;
            }
        }
        if (inLocalXact) {
            try {
                SemanticObjectReferenceStore.commitXact();
            }
            catch (ObjectConfigurationException exception) {
                SemanticObjectReferenceStore.abortXactSafe();
                throw exception;
            }
        }
        return result;
    }

    private static boolean beginXact() throws ObjectConfigurationException {
        try {
            SemanticObjectReferenceStore.beginXact();
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
        return true;
    }

    public static void destroyReferenceContext(ReferenceContext referenceContext) throws ObjectConfigurationException {
        try {
            SemanticObjectReferenceStore.beginXact();
            SemanticObjectReferenceStore.destroySubcontext(referenceContext);
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
    }

    public static void moveObjectToJunk(String namespace, String objectName) throws ObjectConfigurationException {
        ReferenceContext referenceContext = RepositoryUtils.getReferenceContext(namespace, false, false);
        if (referenceContext != null) {
            RepositoryUtils.moveObjectToJunk(referenceContext, objectName);
        }
    }

    public static void moveObjectToJunk(ReferenceContext referenceContext, String objectName) throws ObjectConfigurationException {
        boolean inXact = SemanticObjectReferenceStore.inXactByCurrentThread();
        try {
            if (!inXact) {
                SemanticObjectReferenceStore.beginXact();
                SemanticObjectReferenceStore.setReferenceContext(referenceContext);
            }
            SemanticObjectReferenceStore.moveObjectToJunk(objectName);
            if (!inXact) {
                SemanticObjectReferenceStore.commitXact();
            }
        }
        catch (ObjectConfigurationException exception) {
            SemanticObjectReferenceStore.abortXactSafe();
            throw exception;
        }
    }

    public static void moveToJunk(CachedEntity objectType, String objectName) throws RepositoryException, InterruptedException {
        AbstractRepositoryUtils.moveToJunk(objectType, objectName);
    }
}

