/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.utils;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.mf.admin.TypeFactory;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.utils.DefaultObjectCreator;
import com.streamscape.sef.utils.RepositoryUtils;
import java.util.List;

public class Configurator<T>
extends AbstractRuntimeFactory {
    private ReferenceContext configContext;

    public Configurator(String namespace) throws ObjectConfigurationException {
        Configurator.checkContext();
        this.configContext = RepositoryUtils.getReferenceContext(namespace, false, true);
    }

    public void unbindObject(String objectName) throws ObjectConfigurationException {
        RepositoryUtils.unbindObject(this.configContext, objectName);
    }

    public void bindObject(String objectName, T object) throws ObjectConfigurationException {
        RepositoryUtils.bindObject(this.configContext, objectName, object);
    }

    public T loadObject(String objectName) throws ObjectConfigurationException {
        return RepositoryUtils.lookupObject(this.configContext, objectName);
    }

    public T getObjectFromStorage(String objectName, String objectClassName) throws ObjectConfigurationException {
        return (T)this.doGetObjectFromStorage(objectName, () -> {
            try {
                return this.doCreateDefaultObject(ClassUtils.loadClass(objectClassName, context.getSystemClassLoaderChain()));
            }
            catch (ClassNotFoundException exception) {
                throw new ObjectConfigurationException("Creation of default object '" + objectClassName + "' failed.");
            }
        });
    }

    public T getObjectFromStorage(String objectName, Class objectClass) throws ObjectConfigurationException {
        return (T)this.doGetObjectFromStorage(objectName, () -> this.doCreateDefaultObject(objectClass));
    }

    private T doGetObjectFromStorage(String objectName, DefaultObjectCreator<T> creator) throws ObjectConfigurationException {
        return RepositoryUtils.lookupObject(this.configContext, objectName, creator);
    }

    private T doCreateDefaultObject(Class objectClass) throws ObjectConfigurationException {
        try {
            return objectClass.newInstance();
        }
        catch (InstantiationException exception) {
            throw new ObjectConfigurationException("Creation of default object '" + objectClass.getName() + "' failed.");
        }
        catch (IllegalAccessException exception) {
            throw new ObjectConfigurationException("Creation of default object '" + objectClass.getName() + "' failed.");
        }
    }

    public T getObjectFromStorage(String objectName, T defaultObject) throws ObjectConfigurationException {
        return RepositoryUtils.lookupObject(this.configContext, objectName, defaultObject);
    }

    public boolean existsObject(String objectName) throws ObjectConfigurationException {
        return RepositoryUtils.existsObject(this.configContext, objectName);
    }

    public void destroyContext() throws ObjectConfigurationException {
        RepositoryUtils.destroyReferenceContext(this.configContext);
    }

    public List<String> listBoundNames() throws ObjectConfigurationException {
        return RepositoryUtils.listObjects(this.configContext);
    }

    public void moveObjectToJunk(String objectName) throws ObjectConfigurationException {
        RepositoryUtils.moveObjectToJunk(this.configContext, objectName);
    }

    public static void addSemanticType(Class aliasedClass, String description) throws SemanticTypeFactoryException {
        Configurator.addSemanticType(aliasedClass, aliasedClass.getSimpleName(), description);
    }

    public static void addSemanticType(Class aliasedClass, String alias, String description) throws SemanticTypeFactoryException {
        SemanticType type = Configurator.createSemanticType(alias, aliasedClass, true);
        type.setDescription(description);
        TypeFactory.addSemanticType(type);
    }
}

