/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.Trace;
import com.streamscape.sef.trace.record.LogRecordMatcher;
import com.streamscape.sef.trace.record.LogRecordMatcherPattern;
import com.streamscape.sef.trace.record.LogRecordMatcherRegexp;
import com.streamscape.sef.trace.record.LogRecordMatcherResolver;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimestampResolverUtils {
    private static final TimestampFormatResolver[] timestampFormatResolvers = new TimestampFormatResolver[]{new DigitTimestampFormatResolver("N-N-N N:N:N.N+N", "yyyy-MM-dd HH:mm:ss.SSS ZZZZ", "(\\d{2,4})\\-(\\d{2,4})\\-(\\d{2,4})(\\s*)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})(\\s*)(\\+\\d{2,4})", 1, 2, 3), new DigitTimestampFormatResolver("N-N-N N:N:N.N-N", "yyyy-MM-dd HH:mm:ss.SSS ZZZZ", "(\\d{2,4})\\-(\\d{2,4})\\-(\\d{2,4})(\\s*)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})(\\s*)(\\-\\d{2,4})", 1, 2, 3), new DigitTimestampFormatResolver("N-N-N N:N:N.N", "yyyy-MM-dd HH:mm:ss.SSS", "(\\d{2,4})\\-(\\d{2,4})\\-(\\d{2,4})(\\s*)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})", 1, 2, 3), new DigitTimestampFormatResolver("N/N/N N:N:N.N", "MM/dd/yyyy HH:mm:ss.SSS", "(\\d{2,4})/(\\d{2,4})/(\\d{2,4})(\\s*)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})", 3, 1, 2), new DigitTimestampFormatResolver("N:N:N.N N-N-N", "HH:mm:ss.SSS yyyy-MM-dd", "(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})(\\s*)(\\d{2,4})\\-(\\d{2,4})\\-(\\d{2,4})", 5, 6, 7), new DigitTimestampFormatResolver("N:N:N.N N/N/N", "HH:mm:ss.SSS MM/dd/yyyy", "(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})(\\s*)(\\d{2,4})/(\\d{2,4})/(\\d{2,4})", 7, 5, 6)};

    public static LogRecordMatcher.FragmentParserPattern<?> createParser(String pattern, String timestampPattern, String timestampJavaFormat) {
        int index = pattern.indexOf(timestampPattern);
        if (index == -1) {
            throw new IllegalArgumentException("Timestamp pattern '" + timestampPattern + "' not found in pattern '" + pattern + "'.");
        }
        return new TimestampFragmentParser(timestampPattern, index, timestampJavaFormat);
    }

    public static LogRecordMatcher.FragmentParserPattern<Timestamp> resolveTimestamp(LogRecordMatcherPattern logRecordPattern, String javaFormat) {
        String pattern = TimestampResolverUtils.convertJavaFormat(javaFormat);
        int startIndex = logRecordPattern.getPatternString().indexOf(pattern);
        if (startIndex == -1) {
            return null;
        }
        TimestampFragmentParser timestampFragmentParser = new TimestampFragmentParser(pattern, startIndex, javaFormat);
        logRecordPattern.addFragmentParser(timestampFragmentParser);
        return timestampFragmentParser;
    }

    private static String convertJavaFormat(String javaFormat) {
        javaFormat = javaFormat.replace("yyyy", "N");
        javaFormat = javaFormat.replace("yyy", "N");
        javaFormat = javaFormat.replace("yy", "N");
        javaFormat = javaFormat.replace("MM", "N");
        javaFormat = javaFormat.replace("M", "W");
        javaFormat = javaFormat.replace("ww", "N");
        javaFormat = javaFormat.replace("WW", "N");
        javaFormat = javaFormat.replace("W", "N");
        javaFormat = javaFormat.replace("DDD", "N");
        javaFormat = javaFormat.replace("DD", "N");
        javaFormat = javaFormat.replace("D", "N");
        javaFormat = javaFormat.replace("dd", "N");
        javaFormat = javaFormat.replace("dd", "N");
        javaFormat = javaFormat.replace("dd", "N");
        javaFormat = javaFormat.replace("FF", "N");
        javaFormat = javaFormat.replace("F", "N");
        javaFormat = javaFormat.replace("E", "W");
        javaFormat = javaFormat.replace("uuu", "N");
        javaFormat = javaFormat.replace("uu", "N");
        javaFormat = javaFormat.replace("u", "N");
        javaFormat = javaFormat.replace("aa", "W");
        javaFormat = javaFormat.replace("a", "W");
        javaFormat = javaFormat.replace("HH", "N");
        javaFormat = javaFormat.replace("H", "N");
        javaFormat = javaFormat.replace("kk", "N");
        javaFormat = javaFormat.replace("k", "N");
        javaFormat = javaFormat.replace("KK", "N");
        javaFormat = javaFormat.replace("K", "N");
        javaFormat = javaFormat.replace("hh", "N");
        javaFormat = javaFormat.replace("h", "N");
        javaFormat = javaFormat.replace("mm", "N");
        javaFormat = javaFormat.replace("m", "N");
        javaFormat = javaFormat.replace("sss", "N");
        javaFormat = javaFormat.replace("ss", "N");
        javaFormat = javaFormat.replace("s", "N");
        javaFormat = javaFormat.replace("SSS", "N");
        javaFormat = javaFormat.replace("SS", "N");
        javaFormat = javaFormat.replace("S", "N");
        javaFormat = javaFormat.replace("Z", "N");
        javaFormat = javaFormat.replace("X", "N");
        return javaFormat;
    }

    public static LogRecordMatcher.FragmentParserPattern<Timestamp> resolveTimestamp(LogRecordMatcherPattern logRecordPattern, List<LogRecordMatcherResolver.LinePattern> linePatterns) {
        TimestampFormatResolver timestampFormatResolver = TimestampResolverUtils.findTimestampPattern(logRecordPattern.getPatternString());
        if (timestampFormatResolver == null) {
            return null;
        }
        TimestampFragmentParser timestampFragmentParser = new TimestampFragmentParser(timestampFormatResolver.getPattern(), logRecordPattern.getPatternString().indexOf(timestampFormatResolver.getPattern()));
        logRecordPattern.addFragmentParser(timestampFragmentParser);
        TimestampResolverUtils.resolveTimestampJavaFormat(logRecordPattern, linePatterns, timestampFragmentParser, timestampFormatResolver);
        return timestampFragmentParser;
    }

    private static void resolveTimestampJavaFormat(LogRecordMatcherPattern logRecordPattern, List<LogRecordMatcherResolver.LinePattern> linePatterns, TimestampFragmentParser timestampFragmentParser, TimestampFormatResolver timestampFormatResolver) {
        List<String> timestampStrings = TimestampResolverUtils.collectTimestampStrings(logRecordPattern, linePatterns, timestampFragmentParser);
        String format = timestampFormatResolver.resolve(timestampStrings);
        if (format != null) {
            timestampFragmentParser.setTimestampJavaFormat(format);
        }
    }

    private static List<String> collectTimestampStrings(LogRecordMatcherPattern logRecordPattern, List<LogRecordMatcherResolver.LinePattern> linePatterns, TimestampFragmentParser timestampFragmentParser) {
        ArrayList<String> timestampStrings = new ArrayList<String>();
        for (LogRecordMatcherResolver.LinePattern linePattern : linePatterns) {
            String value;
            Matcher matcher = logRecordPattern.matches(linePattern.line);
            if (!matcher.matches() || (value = logRecordPattern.getStringValueFor(matcher, timestampFragmentParser)) == null) continue;
            timestampStrings.add(value.trim());
        }
        return timestampStrings;
    }

    private static TimestampFormatResolver findTimestampPattern(String pattern) {
        for (TimestampFormatResolver timestampFormatResolver : timestampFormatResolvers) {
            if (!pattern.contains(timestampFormatResolver.getPattern())) continue;
            return timestampFormatResolver;
        }
        return null;
    }

    public static void main(String[] args) {
        Pattern pattern = Pattern.compile("(\\d{2,4})\\-(\\d{2,4})\\-(\\d{2,4})(\\s*)(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d{2,4})(\\s*)(\\+\\d{2,4})");
        Matcher matcher = pattern.matcher("1999-02-03 11:12:13.123+1234");
        System.out.println(matcher.matches());
        System.out.println(matcher.group(1) + "-" + matcher.group(2) + "-" + matcher.group(3));
    }

    public static class TimestampFragmentParser
    extends LogRecordMatcherPattern.AbstractFragmentParserPattern<Timestamp> {
        private String javaFormat;
        private SimpleDateFormat simpleDateFormat;

        public TimestampFragmentParser(String pattern, int startPosition) {
            super("timestamp", pattern, startPosition);
        }

        public TimestampFragmentParser(String pattern, int startPosition, String javaFormat) {
            this(pattern, startPosition);
            if (javaFormat != null) {
                this.setTimestampJavaFormat(javaFormat);
            }
        }

        @Override
        public Timestamp parse(String s) {
            if (this.simpleDateFormat != null) {
                try {
                    return new Timestamp(this.simpleDateFormat.parse(s).getTime());
                }
                catch (ParseException e) {
                    Trace.logException(this, e, false);
                }
            }
            return null;
        }

        public void setTimestampJavaFormat(String javaFormat) {
            this.javaFormat = javaFormat;
            this.simpleDateFormat = new SimpleDateFormat(javaFormat);
        }

        public String getJavaFormat() {
            return this.javaFormat;
        }
    }

    static interface TimestampFormatResolver {
        public String getPattern();

        public String resolve(List<String> var1);
    }

    static class DigitTimestampFormatResolver
    implements TimestampFormatResolver {
        private final String pattern;
        private final String javaPattern;
        private final String regexp;
        private final int yearIndex;
        private final int monthIndex;
        private final int dayIndex;
        private final Pattern regexpPattern;

        public DigitTimestampFormatResolver(String pattern, String javaPattern, String regexp, int yearIndex, int monthIndex, int dayIndex) {
            this.pattern = pattern;
            this.javaPattern = javaPattern;
            this.regexp = regexp;
            this.yearIndex = yearIndex;
            this.monthIndex = monthIndex;
            this.dayIndex = dayIndex;
            this.regexpPattern = Pattern.compile(regexp);
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public String resolve(List<String> timestamps) {
            HashSet<Integer> years = new HashSet<Integer>();
            HashSet<Integer> months = new HashSet<Integer>();
            HashSet<Integer> days = new HashSet<Integer>();
            for (String timestamp : timestamps) {
                Matcher matcher = this.regexpPattern.matcher(timestamp);
                if (!matcher.matches()) continue;
                years.add(Integer.valueOf(matcher.group(this.yearIndex).trim()));
                months.add(Integer.valueOf(matcher.group(this.monthIndex).trim()));
                days.add(Integer.valueOf(matcher.group(this.dayIndex).trim()));
            }
            boolean twoDigitYear = false;
            String javaPatternNew = this.javaPattern;
            int yearIndexNew = this.yearIndex;
            int monthIndexNew = this.monthIndex;
            int dayIndexNew = this.dayIndex;
            if (this.isYear4(years)) {
                if (this.isMonth(months) && this.isMonth(days)) {
                    if (months.size() > days.size()) {
                        monthIndexNew = this.dayIndex;
                        dayIndexNew = this.monthIndex;
                    }
                } else if (this.isMonth(days)) {
                    monthIndexNew = this.dayIndex;
                    dayIndexNew = this.monthIndex;
                }
            } else if (this.isYear4(days)) {
                yearIndexNew = this.dayIndex;
                dayIndexNew = this.yearIndex;
                if (this.isMonth(years) && this.isMonth(months)) {
                    if (months.size() > days.size()) {
                        dayIndexNew = this.monthIndex;
                        monthIndexNew = this.yearIndex;
                    } else {
                        dayIndexNew = this.yearIndex;
                        monthIndexNew = this.monthIndex;
                    }
                } else if (this.isMonth(years)) {
                    monthIndexNew = this.yearIndex;
                    dayIndexNew = this.monthIndex;
                } else {
                    monthIndexNew = this.monthIndex;
                    dayIndexNew = yearIndexNew;
                }
            } else if (this.isYear4(months)) {
                yearIndexNew = this.monthIndex;
                monthIndexNew = this.yearIndex;
                if (this.isMonth(years) && this.isMonth(days)) {
                    if (days.size() > years.size()) {
                        dayIndexNew = this.dayIndex;
                        monthIndexNew = this.yearIndex;
                    } else {
                        dayIndexNew = this.yearIndex;
                        monthIndexNew = this.dayIndex;
                    }
                } else if (this.isMonth(years)) {
                    monthIndexNew = this.yearIndex;
                    dayIndexNew = this.dayIndex;
                } else {
                    monthIndexNew = this.dayIndex;
                    dayIndexNew = yearIndexNew;
                }
            } else {
                twoDigitYear = true;
                if (this.isDay100(days)) {
                    if (this.isMonth(months) && this.isMonth(years)) {
                        if (months.size() < years.size()) {
                            monthIndexNew = this.yearIndex;
                            yearIndexNew = this.monthIndex;
                        }
                    } else if (this.isMonth(years)) {
                        monthIndexNew = this.yearIndex;
                        yearIndexNew = this.monthIndex;
                    }
                } else if (this.isDay100(years)) {
                    dayIndexNew = this.yearIndex;
                    yearIndexNew = this.dayIndex;
                    if (this.isMonth(months) && this.isMonth(days)) {
                        if (days.size() < months.size()) {
                            monthIndexNew = this.dayIndex;
                            yearIndexNew = this.monthIndex;
                        } else {
                            monthIndexNew = this.monthIndex;
                            yearIndexNew = this.dayIndex;
                        }
                    } else if (this.isMonth(days)) {
                        monthIndexNew = this.dayIndex;
                        yearIndexNew = this.monthIndex;
                    }
                } else if (this.isDay100(months)) {
                    dayIndexNew = this.monthIndex;
                    monthIndexNew = this.dayIndex;
                    if (this.isMonth(days) && this.isMonth(years)) {
                        if (days.size() < years.size()) {
                            monthIndexNew = this.yearIndex;
                            yearIndexNew = this.dayIndex;
                        } else {
                            monthIndexNew = this.dayIndex;
                            yearIndexNew = this.yearIndex;
                        }
                    } else if (this.isMonth(days)) {
                        monthIndexNew = this.dayIndex;
                        yearIndexNew = this.yearIndex;
                    }
                }
            }
            if (yearIndexNew == this.monthIndex) {
                javaPatternNew = this.swap(javaPatternNew, "yyyy", "MM");
            } else if (yearIndexNew == dayIndexNew) {
                javaPatternNew = this.swap(javaPatternNew, "yyyy", "dd");
            }
            if (monthIndexNew == this.dayIndex) {
                javaPatternNew = this.swap(javaPatternNew, "MM", "dd");
            }
            if (twoDigitYear) {
                javaPatternNew = javaPatternNew.replace("yyyy", "yy");
            }
            return javaPatternNew;
        }

        private String swap(String s, String s1, String s2) {
            int s2pos;
            int s1pos = ((String)s).indexOf(s1);
            if (s1pos < (s2pos = ((String)s).indexOf(s2))) {
                s = ((String)s).substring(0, s2pos) + s1 + ((String)s).substring(s2pos + s2.length());
                s = ((String)s).substring(0, s1pos) + s2 + ((String)s).substring(s1pos + s1.length());
            } else {
                s = ((String)s).substring(0, s1pos) + s2 + ((String)s).substring(s1pos + s1.length());
                s = ((String)s).substring(0, s2pos) + s1 + ((String)s).substring(s2pos + s2.length());
            }
            return s;
        }

        private boolean isYear4(Set<Integer> values) {
            if (values.size() == 0) {
                return false;
            }
            return String.valueOf(values.iterator().next()).length() == 4;
        }

        private boolean isMonth(Set<Integer> values) {
            if (values.size() == 0) {
                return false;
            }
            return values.stream().filter(v -> v > 12 && v < 1).count() == 0L;
        }

        private boolean isDay(Set<Integer> values) {
            if (values.size() == 0) {
                return false;
            }
            return values.stream().filter(v -> v > 31 && v < 1).count() == 0L;
        }

        private boolean isDay100(Set<Integer> values) {
            if (values.size() == 0) {
                return false;
            }
            return values.stream().filter(v -> v > 31 && v < 13 && values.size() <= 2 && !this.isYear((Integer)v)).count() == 0L;
        }

        private boolean isYear(Set<Integer> values) {
            if (values.size() == 0) {
                return false;
            }
            new Date(System.currentTimeMillis()).getYear();
            int yearMax = this.isYear4(values) ? Calendar.getInstance().get(1) : Calendar.getInstance().get(1) - 2000;
            int yearMin = this.isYear4(values) ? 2016 : 16;
            return values.stream().filter(v -> v > yearMax && v < yearMin).count() == 0L;
        }

        private boolean isYear(Integer v) {
            new Date(System.currentTimeMillis()).getYear();
            int yearMax = String.valueOf(v).length() == 4 ? Calendar.getInstance().get(1) : Calendar.getInstance().get(1) - 2000;
            int yearMin = String.valueOf(v).length() == 4 ? 2016 : 16;
            return v <= yearMax && v >= yearMin;
        }
    }

    public static class TimestampFragmentParserRegexp
    extends LogRecordMatcherRegexp.AbstractFragmentParserRegexp<Timestamp> {
        private String javaFormat;
        private SimpleDateFormat simpleDateFormat;

        public TimestampFragmentParserRegexp(int regexpGroupIndex, String javaFormat) {
            super("timestamp", regexpGroupIndex);
            if (javaFormat != null) {
                this.setTimestampJavaFormat(javaFormat);
            }
        }

        @Override
        public Timestamp parse(String s) {
            if (this.simpleDateFormat != null) {
                try {
                    return new Timestamp(this.simpleDateFormat.parse(s).getTime());
                }
                catch (ParseException e) {
                    Trace.logException(this, e, false);
                }
            }
            return null;
        }

        public void setTimestampJavaFormat(String javaFormat) {
            this.javaFormat = javaFormat;
            this.simpleDateFormat = new SimpleDateFormat(javaFormat);
        }

        public String getJavaFormat() {
            return this.javaFormat;
        }
    }
}

