/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.sef.trace.record.LogRecordMatcherResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SymbolPatterns {
    public static final PlaceholderSymbolPattern WHITESPACE_PLACEHOLDER = new PlaceholderSymbolPattern(" ", "\\s*");
    public static final PlaceholderSymbolPattern DIGIT_PLACEHOLDER = new PlaceholderSymbolPattern("d", "\\d");
    public static final PlaceholderSymbolPattern NUMBER_PLACEHOLDER = new PlaceholderSymbolPattern("N", "\\d+");
    public static final PlaceholderSymbolPattern WORD_PLACEHOLDER = new PlaceholderSymbolPattern("W", "\\w+");
    public static final PlaceholderSymbolPattern IDENTIFICATOR_PLACEHOLDER = new PlaceholderSymbolPattern("W", "[a-zA-Z][\\w-$#~:\\\\]*");
    public static final PlaceholderSymbolPattern CLASSNAME_PLACEHOLDER = new PlaceholderSymbolPattern("CN", "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+([a-zA-Z_$][a-zA-Z\\d_$]*)");
    public static final PlaceholderSymbolPattern CLASSNAME_COMPACT_PLACEHOLDER = new PlaceholderSymbolPattern("CN", "\\.?([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+([a-zA-Z_$][a-zA-Z\\d_$]*)");
    public static final PlaceholderSymbolPattern IPV4_PLACEHOLDER = new PlaceholderSymbolPattern("IPV4", "((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)(\\.|$)){4}");
    public static final PlaceholderSymbolPattern IPV6_PLACEHOLDER = new PlaceholderSymbolPattern("IPV6", "(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))");
    public static final PlaceholderSymbolPattern IP_PLACEHOLDER = new PlaceholderSymbolPattern("IP", "(" + IPV4_PLACEHOLDER.getRegexp() + ")|(" + IPV6_PLACEHOLDER.getRegexp() + ")");
    public static final PlaceholderSymbolPattern QUOTED_STRING_PLACEHOLDER = new PlaceholderSymbolPattern("QS", "'(.)*'");
    public static final PlaceholderSymbolPattern DOUBLEQUOTED_STRING_PLACEHOLDER = new PlaceholderSymbolPattern("DQS", "\"(.)*\"");
    static final String DELIMITERS = "-_\\|;:,./?!@#$%^&~";
    private static Map<String, PlaceholderSymbolPattern> placeholders = new HashMap<String, PlaceholderSymbolPattern>();

    private static void registerPlaceholder(PlaceholderSymbolPattern placeholder) {
        placeholders.put(placeholder.placeholder, placeholder);
    }

    public static SymbolPattern from(String pattern) {
        CompoundSymbolPattern result = new CompoundSymbolPattern(new SymbolPattern[0]);
        LogRecordMatcherResolver.LineTokenizer tokenizer = new LogRecordMatcherResolver.LineTokenizer(pattern, false);
        while (tokenizer.hasNext()) {
            String token = tokenizer.next();
            if (token.startsWith("[") && token.endsWith("]") || token.startsWith("(") && token.endsWith("]") || token.startsWith("{") && token.endsWith("}")) {
                String subtoken = token.substring(1, token.length() - 1).trim();
                result.addSymbolPattern(new QuotedPattern(SymbolPatterns.from(subtoken), token.charAt(0), token.charAt(token.length() - 1)));
                continue;
            }
            PlaceholderSymbolPattern placeholder = placeholders.get(token);
            if (placeholder == null) {
                int lastI = 0;
                for (int i = 0; i < token.length(); ++i) {
                    if (!DELIMITERS.contains(token.substring(i, i + 1))) continue;
                    result.addSymbolPattern(SymbolPatterns.from(token.substring(lastI, i)));
                    result.addSymbolPattern(new FixedSymbolPattern(token.substring(i, i + 1)));
                    lastI = i + 1;
                }
                if (lastI >= token.length()) continue;
                result.addSymbolPattern(SymbolPatterns.from(token.substring(lastI)));
                continue;
            }
            result.addSymbolPattern(placeholder);
        }
        return result.size() == 0 ? null : (result.size() == 1 ? result.get(0) : result);
    }

    static {
        SymbolPatterns.registerPlaceholder(WHITESPACE_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(DIGIT_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(NUMBER_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(WORD_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(IDENTIFICATOR_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(CLASSNAME_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(CLASSNAME_COMPACT_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(IPV4_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(IPV6_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(IP_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(QUOTED_STRING_PLACEHOLDER);
        SymbolPatterns.registerPlaceholder(DOUBLEQUOTED_STRING_PLACEHOLDER);
    }

    public static class PlaceholderSymbolPattern
    implements SymbolPattern {
        private String placeholder;
        private SymbolPattern extendedPlaceholder;
        private String regexp;
        private Pattern regexpPattern;

        public PlaceholderSymbolPattern(String placeholder, String regexp) {
            this(placeholder, null, regexp);
        }

        public PlaceholderSymbolPattern(String placeholder, SymbolPattern extendedPlaceholder, String regexp) {
            this.placeholder = placeholder;
            this.extendedPlaceholder = extendedPlaceholder;
            this.regexp = regexp;
            this.regexpPattern = Pattern.compile(regexp);
        }

        @Override
        public String getPattern() {
            return this.placeholder;
        }

        @Override
        public String getExtendedPattern() {
            return this.extendedPlaceholder != null ? this.extendedPlaceholder.getExtendedPattern() : this.getPattern();
        }

        @Override
        public String getRegexp() {
            return this.regexp;
        }

        @Override
        public Pattern getRegexpPatten() {
            return this.regexpPattern;
        }

        public String toString() {
            return this.getPattern();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PlaceholderSymbolPattern)) {
                return false;
            }
            PlaceholderSymbolPattern that = (PlaceholderSymbolPattern)o;
            return Objects.equals(this.placeholder, that.placeholder);
        }

        public int hashCode() {
            return Objects.hash(this.placeholder);
        }
    }

    static class CompoundSymbolPattern
    implements SymbolPattern {
        private List<SymbolPattern> patterns = new ArrayList<SymbolPattern>();

        public CompoundSymbolPattern(SymbolPattern ... symbolPattern) {
            this(Arrays.asList(symbolPattern));
        }

        public CompoundSymbolPattern(List<SymbolPattern> symbolPatterns) {
            this.patterns.addAll(symbolPatterns);
        }

        public void addSymbolPattern(SymbolPattern symbolPattern) {
            this.patterns.add(symbolPattern);
        }

        @Override
        public String getPattern() {
            return this.patterns.stream().map(pattern -> pattern.getPattern()).collect(Collectors.joining(""));
        }

        @Override
        public String getRegexp() {
            return this.patterns.stream().map(pattern -> pattern.getRegexp()).collect(Collectors.joining(""));
        }

        @Override
        public Pattern getRegexpPatten() {
            return Pattern.compile(this.getRegexp());
        }

        public String getRegexpWithWrap(String[] patternFragments, int[] indexes) {
            String pattern = this.getPattern();
            int[] startPositions = new int[patternFragments.length];
            for (int i = 0; i < patternFragments.length; ++i) {
                startPositions[i] = pattern.indexOf(patternFragments[i]);
                if (startPositions[i] != -1) continue;
                throw new IllegalArgumentException("Fragment '" + patternFragments[i] + "' is not present in pattern.");
            }
            return this.getRegexpWithWrap(patternFragments, startPositions, indexes);
        }

        public String getRegexpWithWrap(String[] patternFragments, int[] startPositions, int[] indexes) {
            int patternIndex;
            int i;
            String pattern = this.getPattern();
            int[][] sortedPatternFragments = new int[patternFragments.length][3];
            for (i = 0; i < patternFragments.length; ++i) {
                int startPosition = pattern.indexOf(patternFragments[i], startPositions[i]);
                if (startPosition != startPositions[i]) {
                    throw new IllegalArgumentException("Fragment '" + patternFragments[i] + "' is not present in pattern at position '" + startPositions[i] + "'.");
                }
                sortedPatternFragments[i][0] = i;
                sortedPatternFragments[i][1] = startPositions[i];
                sortedPatternFragments[i][2] = startPositions[i] + patternFragments[i].length();
            }
            Arrays.sort(sortedPatternFragments, Comparator.comparingInt(a -> a[1]));
            for (i = 1; i < sortedPatternFragments.length; ++i) {
                if (sortedPatternFragments[i][1] > sortedPatternFragments[i - 1][1]) continue;
                throw new IllegalArgumentException("Fragments '" + patternFragments[sortedPatternFragments[i - 1][0]] + "' and '" + patternFragments[sortedPatternFragments[i][0]] + "' have intersection.");
            }
            int fragmentIndex = 0;
            String fragmentPrefix = null;
            StringBuilder regexpBuilder = new StringBuilder();
            StringBuilder prefixPatternBuilder = new StringBuilder();
            for (patternIndex = 0; fragmentIndex < patternFragments.length && patternIndex < this.patterns.size(); ++patternIndex) {
                if (fragmentPrefix == null) {
                    fragmentPrefix = pattern.substring(0, sortedPatternFragments[fragmentIndex][1]);
                }
                if (prefixPatternBuilder.toString().equals(fragmentPrefix)) {
                    regexpBuilder.append("(");
                    StringBuilder fragmentPatternBuilder = new StringBuilder();
                    while (patternIndex < this.patterns.size()) {
                        fragmentPatternBuilder.append(this.patterns.get(patternIndex).getPattern());
                        prefixPatternBuilder.append(this.patterns.get(patternIndex).getPattern());
                        regexpBuilder.append(this.patterns.get(patternIndex).getRegexp());
                        if (fragmentPatternBuilder.toString().equals(patternFragments[sortedPatternFragments[fragmentIndex][0]])) break;
                        ++patternIndex;
                    }
                    ++fragmentIndex;
                    fragmentPrefix = null;
                    regexpBuilder.append(")");
                    continue;
                }
                prefixPatternBuilder.append(this.patterns.get(patternIndex).getPattern());
                regexpBuilder.append(this.patterns.get(patternIndex).getRegexp());
            }
            while (patternIndex < this.patterns.size()) {
                regexpBuilder.append(this.patterns.get(patternIndex).getRegexp());
                ++patternIndex;
            }
            if (indexes != null) {
                for (int i2 = 0; i2 < sortedPatternFragments.length; ++i2) {
                    indexes[i2] = sortedPatternFragments[i2][0] + 1;
                }
            }
            return regexpBuilder.toString();
        }

        public int size() {
            return this.patterns.size();
        }

        public SymbolPattern get(int i) {
            return this.patterns.get(i);
        }

        public List<SymbolPattern> getAll() {
            return this.patterns != null ? this.patterns : new ArrayList<SymbolPattern>();
        }

        public void addSymbolPatterns(List<SymbolPattern> patterns) {
            this.patterns.addAll(patterns);
        }

        @Override
        public CompoundSymbolPattern compress() {
            ArrayList<SymbolPattern> compressed = new ArrayList<SymbolPattern>();
            FixedSymbolPattern compressedFixedSymbolPattern = null;
            for (SymbolPattern symbolPattern : this.patterns) {
                if ((symbolPattern = symbolPattern.compress()) instanceof CompoundSymbolPattern) {
                    if (((CompoundSymbolPattern)symbolPattern).size() == 0) continue;
                    if (((CompoundSymbolPattern)symbolPattern).size() == 1 && ((CompoundSymbolPattern)symbolPattern).get(0) instanceof FixedSymbolPattern) {
                        symbolPattern = ((CompoundSymbolPattern)symbolPattern).get(0);
                    }
                }
                if (symbolPattern instanceof FixedSymbolPattern) {
                    if (compressedFixedSymbolPattern == null) {
                        compressedFixedSymbolPattern = (FixedSymbolPattern)symbolPattern;
                        continue;
                    }
                    compressedFixedSymbolPattern = new FixedSymbolPattern(compressedFixedSymbolPattern.symbols + ((FixedSymbolPattern)symbolPattern).symbols);
                    continue;
                }
                if (compressedFixedSymbolPattern != null) {
                    compressed.add(compressedFixedSymbolPattern);
                    compressedFixedSymbolPattern = null;
                }
                compressed.add(symbolPattern);
            }
            if (compressedFixedSymbolPattern != null) {
                compressed.add(compressedFixedSymbolPattern);
            }
            return new CompoundSymbolPattern(compressed);
        }

        @Override
        public CompoundSymbolPattern unroll() {
            ArrayList<SymbolPattern> unrolled = new ArrayList<SymbolPattern>();
            for (SymbolPattern symbolPattern : this.patterns) {
                if ((symbolPattern = symbolPattern.unroll()) instanceof CompoundSymbolPattern) {
                    CompoundSymbolPattern unrolledCompoundSymbolPattern = ((CompoundSymbolPattern)symbolPattern).unroll();
                    for (int i = 0; i < unrolledCompoundSymbolPattern.size(); ++i) {
                        unrolled.add(unrolledCompoundSymbolPattern.get(i));
                    }
                    continue;
                }
                unrolled.add(symbolPattern);
            }
            return new CompoundSymbolPattern(unrolled);
        }

        @Override
        public CompoundSymbolPattern trimTailingSpaces() {
            ArrayList<SymbolPattern> newPatterns = new ArrayList<SymbolPattern>(this.patterns);
            boolean changed = false;
            for (int index = newPatterns.size() - 1; index >= 0; --index) {
                SymbolPattern pattern = newPatterns.get(index);
                if (pattern == WHITESPACE_PLACEHOLDER) {
                    newPatterns.remove(index);
                    changed = true;
                    continue;
                }
                SymbolPattern trimmedPattern = pattern.trimTailingSpaces();
                if (trimmedPattern == pattern) break;
                if (trimmedPattern instanceof CompoundSymbolPattern && ((CompoundSymbolPattern)trimmedPattern).size() == 0) {
                    newPatterns.remove(index);
                    --index;
                } else {
                    newPatterns.set(index, trimmedPattern);
                }
                changed = true;
                break;
            }
            return changed ? new CompoundSymbolPattern(newPatterns) : this;
        }

        public String toString() {
            return this.getPattern();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompoundSymbolPattern)) {
                return false;
            }
            CompoundSymbolPattern that = (CompoundSymbolPattern)o;
            return Objects.equals(this.patterns, that.patterns);
        }

        public int hashCode() {
            return Objects.hash(this.patterns);
        }
    }

    static interface SymbolPattern {
        public String getPattern();

        public String getRegexp();

        public Pattern getRegexpPatten();

        default public String getExtendedPattern() {
            return this.getPattern();
        }

        default public SymbolPattern compress() {
            return this;
        }

        default public SymbolPattern trimTailingSpaces() {
            return this;
        }

        default public SymbolPattern unroll() {
            return this;
        }
    }

    static class QuotedPattern
    implements SymbolPattern {
        private SymbolPattern symbolPattern;
        private final char openSymbol;
        private final char closeSymbol;

        public QuotedPattern(SymbolPattern symbolPattern, char openSymbol, char closeSymbol) {
            this.symbolPattern = symbolPattern;
            this.openSymbol = openSymbol;
            this.closeSymbol = closeSymbol;
        }

        @Override
        public String getPattern() {
            return this.openSymbol + " " + this.symbolPattern.getPattern() + " " + this.closeSymbol;
        }

        @Override
        public String getRegexp() {
            return Pattern.quote(String.valueOf(this.openSymbol)) + "\\s*" + this.symbolPattern.getRegexp() + "\\s*" + Pattern.quote(String.valueOf(this.closeSymbol));
        }

        @Override
        public Pattern getRegexpPatten() {
            return Pattern.compile(this.getRegexp());
        }

        @Override
        public SymbolPattern unroll() {
            return new CompoundSymbolPattern(new FixedSymbolPattern(String.valueOf(this.openSymbol)), WHITESPACE_PLACEHOLDER, this.symbolPattern, WHITESPACE_PLACEHOLDER, new FixedSymbolPattern(String.valueOf(this.closeSymbol)));
        }

        public String toString() {
            return this.getPattern();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof QuotedPattern)) {
                return false;
            }
            QuotedPattern that = (QuotedPattern)o;
            return this.openSymbol == that.openSymbol && this.closeSymbol == that.closeSymbol && Objects.equals(this.symbolPattern, that.symbolPattern);
        }

        public int hashCode() {
            return Objects.hash(this.symbolPattern, Character.valueOf(this.openSymbol), Character.valueOf(this.closeSymbol));
        }
    }

    public static class FixedSymbolPattern
    implements SymbolPattern {
        private String symbols;

        public FixedSymbolPattern(String symbols) {
            this.symbols = symbols;
        }

        @Override
        public String getPattern() {
            return this.symbols;
        }

        @Override
        public String getRegexp() {
            return Pattern.quote(this.symbols);
        }

        @Override
        public Pattern getRegexpPatten() {
            return Pattern.compile(this.getRegexp());
        }

        public String toString() {
            return this.getPattern();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FixedSymbolPattern)) {
                return false;
            }
            FixedSymbolPattern that = (FixedSymbolPattern)o;
            return Objects.equals(this.symbols, that.symbols);
        }

        public int hashCode() {
            return Objects.hash(this.symbols);
        }
    }
}

