/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.sef.trace.record.SymbolPatterns;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class SymbolPatternTree {
    private SymbolPatternNode root = new SymbolPatternNode();

    public void add(SymbolPatterns.SymbolPattern symbolPattern, String line) {
        if (!(symbolPattern instanceof SymbolPatterns.CompoundSymbolPattern)) {
            symbolPattern = new SymbolPatterns.CompoundSymbolPattern(symbolPattern);
        }
        this.add((SymbolPatterns.CompoundSymbolPattern)symbolPattern, line);
    }

    public void add(SymbolPatterns.CompoundSymbolPattern compoundSymbolPattern, String line) {
        SymbolPatternNode child;
        int i;
        SymbolPatternNode node = this.root;
        ++node.count;
        for (i = 0; i < compoundSymbolPattern.size(); ++i) {
            child = null;
            if (node.childs != null) {
                child = node.childs.get(compoundSymbolPattern.get(i));
            }
            if (child == null) break;
            ++child.count;
            node = child;
        }
        while (i < compoundSymbolPattern.size()) {
            if (node.childs == null) {
                node.childs = new HashMap<SymbolPatterns.SymbolPattern, SymbolPatternNode>();
            }
            child = new SymbolPatternNode(node, compoundSymbolPattern.get(i));
            node.childs.put(child.symbolPattern, child);
            node = child;
            ++i;
        }
        node.end = true;
        node.line = line;
    }

    public List<Sequence> findBestSequences() {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        if (this.root == null || this.root.childs == null || this.root.childs.size() == 0) {
            return sequences;
        }
        this.findBestSequences(this.root, 0, sequences);
        return sequences;
    }

    private void findBestSequences(SymbolPatternNode node, int length, List<Sequence> sequences) {
        if (node.childs == null || node.childs.size() == 0) {
            if (length > 0) {
                sequences.add(new Sequence(node, length));
            }
        } else if (node.childs.size() == 1) {
            this.findBestSequences(node.childs.values().iterator().next(), length + 1, sequences);
        } else {
            if (length > 0) {
                sequences.add(new Sequence(node, length));
            }
            List<SymbolPatternNode> childs = new ArrayList<SymbolPatternNode>(node.childs.values());
            childs = SymbolPatternTree.findTopPercentile(childs, 95, c -> c.count);
            for (SymbolPatternNode child : childs) {
                this.findBestSequences(child, 1, sequences);
            }
        }
    }

    public Sequence getBestSequence(List<Sequence> sequences) {
        if (sequences.size() == 0) {
            return null;
        }
        if (sequences.size() == 1) {
            return sequences.get(0);
        }
        sequences = SymbolPatternTree.findTopPercentile(sequences, 95, s -> s.node.count);
        sequences.sort(Comparator.comparingInt(s -> s.length));
        return sequences.get(sequences.size() - 1);
    }

    private static <T> List<T> findTopPercentile(List<T> list, int percentile, Function<T, Integer> f) {
        T current;
        list.sort(Comparator.comparingInt(o -> (Integer)f.apply(o)));
        ArrayList<T> result = new ArrayList<T>();
        T max = list.get(list.size() - 1);
        result.add(max);
        for (int index = list.size() - 2; index >= 0 && f.apply(current = list.get(index)) * 100 / f.apply(max) > percentile; --index) {
            result.add(current);
        }
        return result;
    }

    static class SymbolPatternNode {
        private SymbolPatternNode parent;
        private SymbolPatterns.SymbolPattern symbolPattern;
        private int count;
        private boolean end;
        private String line;
        private Map<SymbolPatterns.SymbolPattern, SymbolPatternNode> childs;

        public SymbolPatternNode() {
        }

        public SymbolPatternNode(SymbolPatternNode parent, SymbolPatterns.SymbolPattern symbolPattern) {
            this.parent = parent;
            this.symbolPattern = symbolPattern;
            this.count = 1;
        }

        public int getCount() {
            return this.count;
        }

        public SymbolPatterns.SymbolPattern getSymbolPattern() {
            return this.symbolPattern;
        }

        public String toString() {
            return "SymbolPatternNode{symbolPattern=" + String.valueOf(this.symbolPattern) + ", count=" + this.count + ", end=" + this.end + ", childs.count=" + (this.childs != null ? this.childs.size() : 0) + ", pattern=" + String.valueOf(this.getFullPattern()) + "}";
        }

        public SymbolPatterns.CompoundSymbolPattern getFullPattern() {
            SymbolPatterns.CompoundSymbolPattern result = new SymbolPatterns.CompoundSymbolPattern(new SymbolPatterns.SymbolPattern[0]);
            if (this.parent != null) {
                result.addSymbolPatterns(this.parent.getFullPattern().getAll());
            }
            if (this.symbolPattern != null) {
                result.addSymbolPattern(this.symbolPattern);
            }
            return result;
        }
    }

    public static class Sequence {
        SymbolPatternNode node;
        int length;

        public Sequence(SymbolPatternNode node, int length) {
            this.node = node;
            this.length = length;
        }

        public String toString() {
            return "Sequence{sequence count=" + this.node.count + ", sequence length=" + this.length + ", sequence pattern=" + this.node.getFullPattern().getPattern() + "}";
        }
    }
}

