/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.Trace;
import com.streamscape.sef.trace.record.LogRecordMatcherPattern;
import com.streamscape.sef.trace.record.SymbolPatternTree;
import com.streamscape.sef.trace.record.SymbolPatterns;
import com.streamscape.sef.trace.record.TimestampResolverUtils;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LogRecordMatcherResolver {
    private Builder.SourceProvider sourceProvider;
    private int linesCount;
    private int sampleRate = 1;
    private SkipFilter skipFilter = null;
    private boolean wordsInSquareBrackets;
    private boolean compactClassNames;
    private String timestampJavaFormat;
    private int linesRead = 0;

    public static Builder builder() {
        return new Builder();
    }

    private LogRecordMatcherResolver() {
    }

    public LogRecordMatcherPattern resolve() throws IOException {
        List<LinePattern> linePatterns = this.convertLinesToSymbolPatterns(this.readLines());
        LogRecordMatcherPattern pattern = this.findBestMatch(linePatterns);
        return pattern;
    }

    public int getLinesRead() {
        return this.linesRead;
    }

    private LogRecordMatcherPattern findBestMatch(List<LinePattern> linePatterns) {
        SymbolPatternTree tree = new SymbolPatternTree();
        for (LinePattern linePattern : linePatterns) {
            tree.add(linePattern.pattern, linePattern.line);
        }
        List<SymbolPatternTree.Sequence> sequences = tree.findBestSequences();
        SymbolPatternTree.Sequence bestSequence = tree.getBestSequence(sequences);
        Trace.logDebug(this, "Sequences: " + String.valueOf(sequences));
        Trace.logDebug(this, "Best Sequence: " + String.valueOf(bestSequence));
        if (bestSequence != null) {
            LogRecordMatcherPattern logRecordPattern = new LogRecordMatcherPattern(bestSequence.node.getFullPattern());
            if (this.timestampJavaFormat == null) {
                TimestampResolverUtils.resolveTimestamp(logRecordPattern, linePatterns);
            } else {
                TimestampResolverUtils.resolveTimestamp(logRecordPattern, this.timestampJavaFormat);
            }
            return logRecordPattern;
        }
        return null;
    }

    private List<String> readLines() throws IOException {
        this.linesRead = 0;
        try (Reader reader = this.sourceProvider.reader();){
            String line;
            BufferedReader bufferedReader = new BufferedReader(reader);
            int sampleRate = 0;
            ArrayList<String> lines = new ArrayList<String>();
            while ((this.linesRead < this.linesCount || this.linesCount <= 0) && (line = bufferedReader.readLine()) != null) {
                if (line.trim().length() == 0 || this.skipFilter != null && this.skipFilter.matches(line)) continue;
                if (sampleRate > 0) {
                    --sampleRate;
                    continue;
                }
                sampleRate = this.sampleRate;
                ++this.linesRead;
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    private List<LinePattern> convertLinesToSymbolPatterns(List<String> lines) {
        return lines.stream().map(line -> line.trim()).filter(line -> line.length() > 0).map(line -> new LinePattern(this.convertLineToSymbolPattern((String)line), (String)line)).collect(Collectors.toList());
    }

    SymbolPatterns.SymbolPattern convertLineToSymbolPattern(String line) {
        SymbolPatterns.CompoundSymbolPattern compoundSymbolPattern = new SymbolPatterns.CompoundSymbolPattern(new SymbolPatterns.SymbolPattern[0]);
        this.convertLineToSymbolPattern(line, compoundSymbolPattern);
        if (compoundSymbolPattern.size() == 1) {
            return compoundSymbolPattern.get(0);
        }
        return compoundSymbolPattern;
    }

    private void convertLineToSymbolPattern(String line, SymbolPatterns.CompoundSymbolPattern compoundSymbolPattern) {
        LineTokenizer tokenizer = new LineTokenizer(line);
        while (tokenizer.hasNext()) {
            if (compoundSymbolPattern.size() > 0) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.WHITESPACE_PLACEHOLDER);
            } else if (line.length() > 0 && Character.isWhitespace(line.charAt(0))) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.WHITESPACE_PLACEHOLDER);
            }
            String token = tokenizer.next();
            while (token != null && token.length() > 0) {
                token = this.convertTokenToSymbolPattern(token, compoundSymbolPattern);
            }
        }
    }

    private String convertTokenToSymbolPattern(String token, SymbolPatterns.CompoundSymbolPattern compoundSymbolPattern) {
        if (token.startsWith("'") || token.startsWith("\"")) {
            if (token.length() == 1) {
                compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(token));
            } else if (token.endsWith(token.substring(0, 1))) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.QUOTED_STRING_PLACEHOLDER);
            } else {
                compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(token.substring(0, 1)));
                this.convertLineToSymbolPattern(token.substring(1), compoundSymbolPattern);
            }
        } else if (token.startsWith("(") || token.startsWith("[") || token.startsWith("{")) {
            Character openChar = Character.valueOf(token.charAt(0));
            Character closeChar = LineTokenizer.getCloseChar(openChar.charValue());
            if (token.length() == 1) {
                compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(token));
            } else if (token.endsWith(closeChar.toString())) {
                String substring = token.substring(1, token.length() - 1);
                if (substring.length() == 0) {
                    compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(token));
                } else {
                    SymbolPatterns.SymbolPattern subpattern = this.convertLineToSymbolPattern(substring.trim());
                    if (this.wordsInSquareBrackets && openChar.charValue() == '[' && subpattern instanceof SymbolPatterns.CompoundSymbolPattern) {
                        subpattern = new SymbolPatterns.PlaceholderSymbolPattern(SymbolPatterns.WORD_PLACEHOLDER.getPattern(), subpattern, SymbolPatterns.IDENTIFICATOR_PLACEHOLDER.getRegexp());
                    }
                    compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.QuotedPattern(subpattern, openChar.charValue(), closeChar.charValue()));
                }
            } else {
                compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(openChar.toString()));
                this.convertLineToSymbolPattern(token.substring(1), compoundSymbolPattern);
            }
        } else {
            boolean processed = true;
            if (SymbolPatterns.NUMBER_PLACEHOLDER.getRegexpPatten().matcher(token).matches()) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.NUMBER_PLACEHOLDER);
            } else if (SymbolPatterns.WORD_PLACEHOLDER.getRegexpPatten().matcher(token).matches()) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.WORD_PLACEHOLDER);
            } else if (SymbolPatterns.IP_PLACEHOLDER.getRegexpPatten().matcher(token).matches()) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.IP_PLACEHOLDER);
            } else if (this.compactClassNames ? SymbolPatterns.CLASSNAME_COMPACT_PLACEHOLDER.getRegexpPatten().matcher(token).matches() : SymbolPatterns.CLASSNAME_PLACEHOLDER.getRegexpPatten().matcher(token).matches()) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.CLASSNAME_PLACEHOLDER);
            } else if (SymbolPatterns.IDENTIFICATOR_PLACEHOLDER.getRegexpPatten().matcher(token).matches()) {
                compoundSymbolPattern.addSymbolPattern(SymbolPatterns.IDENTIFICATOR_PLACEHOLDER);
            } else if ("-_\\|;:,./?!@#$%^&~".contains(token.substring(0, 1))) {
                compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(token.substring(0, 1)));
                compoundSymbolPattern.addSymbolPattern(this.convertLineToSymbolPattern(token.substring(1)));
            } else {
                processed = false;
                for (int i = 0; i < token.length(); ++i) {
                    if (!"-_\\|;:,./?!@#$%^&~".contains(token.substring(i, i + 1))) continue;
                    compoundSymbolPattern.addSymbolPattern(this.convertLineToSymbolPattern(token.substring(0, i)));
                    compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.FixedSymbolPattern(token.substring(i, i + 1)));
                    return token.substring(i + 1);
                }
            }
            if (!processed) {
                compoundSymbolPattern.addSymbolPattern(new SymbolPatterns.PlaceholderSymbolPattern("U", Pattern.quote(token)));
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
    }

    public static class Builder {
        private SourceProvider sourceProvider;
        private int linesCount = 1000;
        private int sampleRate;
        private CompoundSkipFilter skipFilter = new CompoundSkipFilter();
        private boolean compactClassNames;
        private boolean wordsInSquareBrackets;
        private String timestampJavaFormat;

        public Builder sourceFile(final String filename) {
            this.sourceProvider = new SourceProvider(){
                private Reader reader;

                @Override
                public Reader reader() throws FileNotFoundException {
                    this.reader = new FileReader(filename);
                    return this.reader;
                }

                @Override
                public void close() throws IOException {
                    if (this.reader != null) {
                        this.reader.close();
                        this.reader = null;
                    }
                }
            };
            return this;
        }

        public Builder sourceContent(final String content) {
            this.sourceProvider = new SourceProvider(){

                @Override
                public Reader reader() {
                    return new StringReader(content);
                }

                @Override
                public void close() {
                }
            };
            return this;
        }

        public Builder sourceReader(final Reader reader) {
            this.sourceProvider = new SourceProvider(){

                @Override
                public Reader reader() {
                    return reader;
                }

                @Override
                public void close() {
                }
            };
            return this;
        }

        public Builder linesCount(int linesCount) {
            this.linesCount = linesCount;
            return this;
        }

        public Builder sampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public Builder skipJavaTraces(boolean skipJavaTraces) {
            this.skipFilter.add(new JavaTraceSkipFilter());
            return this;
        }

        public Builder compactClassNames(boolean compactClassNames) {
            this.compactClassNames = compactClassNames;
            return this;
        }

        public Builder wordsInSquareBrackets(boolean wordsInSquareBrackets) {
            this.wordsInSquareBrackets = wordsInSquareBrackets;
            return this;
        }

        public Builder javaTimestampFormat(String timestampJavaFormat) {
            this.timestampJavaFormat = timestampJavaFormat;
            return this;
        }

        public LogRecordMatcherResolver build() {
            if (this.sourceProvider == null) {
                throw new IllegalArgumentException("Source is not set.");
            }
            LogRecordMatcherResolver recordPatternResolver = new LogRecordMatcherResolver();
            recordPatternResolver.sourceProvider = this.sourceProvider;
            recordPatternResolver.linesCount = this.linesCount;
            recordPatternResolver.sampleRate = this.sampleRate;
            recordPatternResolver.skipFilter = this.skipFilter;
            recordPatternResolver.wordsInSquareBrackets = this.wordsInSquareBrackets;
            recordPatternResolver.compactClassNames = this.compactClassNames;
            recordPatternResolver.timestampJavaFormat = this.timestampJavaFormat;
            return recordPatternResolver;
        }

        static interface SourceProvider
        extends AutoCloseable {
            public Reader reader() throws FileNotFoundException;

            @Override
            public void close() throws IOException;
        }
    }

    static interface SkipFilter {
        public boolean matches(String var1);
    }

    static class LinePattern {
        SymbolPatterns.SymbolPattern pattern;
        String line;

        public LinePattern(SymbolPatterns.SymbolPattern pattern, String line) {
            this.pattern = pattern;
            this.line = line;
        }
    }

    static class LineTokenizer {
        private String line;
        private String next = null;
        private int position = 0;
        private boolean skipWhitespaces = true;

        public LineTokenizer(String line) {
            this.line = line.trim();
        }

        public LineTokenizer(String line, boolean skipWhitespaces) {
            this(line);
            this.skipWhitespaces = skipWhitespaces;
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.skipWhitespaces) {
                this.skipWhitespaces();
            }
            if (this.position >= this.line.length()) {
                return false;
            }
            char c = this.line.charAt(this.position);
            switch (c) {
                case '\'': {
                    this.next = this.nextWithClose('\'');
                    break;
                }
                case '\"': {
                    this.next = this.nextWithClose('\"');
                    break;
                }
                case '(': {
                    this.next = this.nextWithClose(')');
                    break;
                }
                case '[': {
                    this.next = this.nextWithClose(']');
                    break;
                }
                case '{': {
                    this.next = this.nextWithClose('}');
                    break;
                }
                case ' ': {
                    if (!this.skipWhitespaces) {
                        this.next = " ";
                        ++this.position;
                        return true;
                    }
                }
                default: {
                    this.next = this.nextWithWhitespaceClose();
                }
            }
            if (this.next != null) {
                this.next = this.next.trim();
            }
            if (this.next.length() == 0) {
                this.next = null;
            }
            return this.next != null;
        }

        private String nextWithWhitespaceClose() {
            this.skipWhitespaces();
            int startPosition = this.position;
            while (this.position < this.line.length() && !Character.isWhitespace(this.line.charAt(this.position)) && !"\"([{".contains(Character.valueOf(this.line.charAt(this.position)).toString())) {
                ++this.position;
            }
            return this.line.substring(startPosition, this.position);
        }

        private void skipWhitespaces() {
            while (this.position < this.line.length() && Character.isWhitespace(this.line.charAt(this.position))) {
                ++this.position;
            }
        }

        private String nextWithClose(char closeChar) {
            int startPosition = this.position;
            int openCount = 1;
            char openChar = LineTokenizer.getOpenChar(closeChar);
            while (++this.position < this.line.length()) {
                char c = this.line.charAt(this.position);
                if (c == openChar) {
                    ++openCount;
                    continue;
                }
                if (c != closeChar || --openCount != 0) continue;
                ++this.position;
                break;
            }
            return this.line.substring(startPosition, this.position);
        }

        static char getOpenChar(char closeChar) {
            switch (closeChar) {
                case ']': {
                    return '[';
                }
                case ')': {
                    return '(';
                }
                case '}': {
                    return '{';
                }
            }
            return '\u0000';
        }

        static Character getCloseChar(char openChar) {
            switch (openChar) {
                case '[': {
                    return Character.valueOf(']');
                }
                case '(': {
                    return Character.valueOf(')');
                }
                case '{': {
                    return Character.valueOf('}');
                }
            }
            return Character.valueOf('\u0000');
        }

        public String next() {
            try {
                String string = this.next;
                return string;
            }
            finally {
                this.next = null;
            }
        }
    }

    static class JavaTraceSkipFilter
    implements SkipFilter {
        static Pattern JAVA_TRACE_PATTERN = Pattern.compile("(\\s*at\\s*([a-zA-Z_$][a-zA-Z\\d_$]*\\.)*([a-zA-Z_$][a-zA-Z\\d_$])*.*)|(Caused by: .*)");

        JavaTraceSkipFilter() {
        }

        @Override
        public boolean matches(String line) {
            return JAVA_TRACE_PATTERN.matcher(line).matches();
        }
    }

    static class CompoundSkipFilter
    implements SkipFilter {
        private List<SkipFilter> skipFilters = new ArrayList<SkipFilter>();

        CompoundSkipFilter() {
        }

        @Override
        public boolean matches(String line) {
            return this.skipFilters.stream().anyMatch(skipFilter -> skipFilter.matches(line));
        }

        public void add(SkipFilter skipFilter) {
            this.skipFilters.add(skipFilter);
        }
    }
}

