/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.sef.trace.record.FragmentParser;
import com.streamscape.sef.trace.record.LogRecordMatcher;
import com.streamscape.sef.trace.record.TimestampResolverUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogRecordMatcherRegexp
implements LogRecordMatcher {
    private final String recordRegexp;
    private final Pattern recordRegexpPattern;
    private final List<FragmentParser<?>> fragmentParsers = new ArrayList();

    private LogRecordMatcherRegexp(String recordRegexp) {
        this.recordRegexp = recordRegexp;
        this.recordRegexpPattern = Pattern.compile(recordRegexp);
    }

    @Override
    public Matcher matches(CharSequence line) {
        return this.recordRegexpPattern.matcher(line);
    }

    @Override
    public String getStringValueFor(Matcher matcher, FragmentParser<?> resolver) {
        return matcher.group(resolver.getRegexpGroupIndex());
    }

    @Override
    public List<FragmentParser<?>> listFragmentParsers() {
        return new ArrayList(this.fragmentParsers);
    }

    @Override
    public String getRecordRegexp() {
        return this.recordRegexp;
    }

    public void addFragmentParser(AbstractFragmentParserRegexp<?> parserRegexp) {
        this.fragmentParsers.add(parserRegexp);
    }

    @Override
    public FragmentParser getFragmentParser(String name) {
        return this.fragmentParsers.stream().filter(r -> r.getName().equals(name)).findFirst().orElse(null);
    }

    public String toString() {
        return "LogRecordRegexp{recordRegexp='" + this.recordRegexp + "', recordRegexpPattern=" + String.valueOf(this.recordRegexpPattern) + ", fragmentParsers=" + String.valueOf(this.fragmentParsers) + "}";
    }

    public static LogRecordMatcherRegexpBuilder builder() {
        return new LogRecordMatcherRegexpBuilder();
    }

    public static class LogRecordMatcherRegexpBuilder {
        private String recordRegexp;
        private int timestampRegexpGroupIndex = -1;
        private String timestampJavaFormat;

        private LogRecordMatcherRegexpBuilder() {
        }

        public LogRecordMatcherRegexpBuilder recordRegexp(String recordRegexp) {
            this.recordRegexp = recordRegexp;
            return this;
        }

        public LogRecordMatcherRegexpBuilder timestampRegexpGroupIndex(int timestampRegexpGroupIndex) {
            this.timestampRegexpGroupIndex = timestampRegexpGroupIndex;
            return this;
        }

        public LogRecordMatcherRegexpBuilder timestampJavaFormat(String timestampJavaFormat) {
            this.timestampJavaFormat = timestampJavaFormat;
            return this;
        }

        public LogRecordMatcherRegexp build() {
            LogRecordMatcherRegexp matcherRegexp = new LogRecordMatcherRegexp(this.recordRegexp);
            if (this.timestampRegexpGroupIndex != -1 && this.timestampJavaFormat != null) {
                matcherRegexp.addFragmentParser(new TimestampResolverUtils.TimestampFragmentParserRegexp(this.timestampRegexpGroupIndex, this.timestampJavaFormat));
            }
            return matcherRegexp;
        }
    }

    public static abstract class AbstractFragmentParserRegexp<T>
    implements FragmentParser<T> {
        private final String name;
        private final int regexpGroupIndex;

        public AbstractFragmentParserRegexp(String name, int regexpGroupIndex) {
            this.name = name;
            this.regexpGroupIndex = regexpGroupIndex;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getRegexpGroupIndex() {
            return this.regexpGroupIndex;
        }

        public String toString() {
            return "AbstractFragmentParserRegexp{name='" + this.name + "', regexpGroupIndex=" + this.regexpGroupIndex + "}";
        }
    }
}

