/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.sef.trace.record.FragmentParser;
import com.streamscape.sef.trace.record.LogRecordMatcher;
import com.streamscape.sef.trace.record.SymbolPatterns;
import com.streamscape.sef.trace.record.TimestampResolverUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogRecordMatcherPattern
implements LogRecordMatcher {
    private final SymbolPatterns.CompoundSymbolPattern pattern;
    private String patternRegexp;
    private String recordRegexp;
    private Pattern recordRegexpPattern;
    private final List<FragmentParser<?>> fragmentParsers = new ArrayList();
    private int headerIndex = -1;
    private int contentIndex = -1;

    protected LogRecordMatcherPattern(SymbolPatterns.CompoundSymbolPattern pattern) {
        pattern = pattern.unroll();
        pattern = pattern.trimTailingSpaces();
        this.pattern = pattern = pattern.compress();
        this.buildRegexp();
    }

    private void buildRegexp() {
        this.patternRegexp = this.buildPatternRegexp();
        this.recordRegexp = "(" + this.patternRegexp + ")(.*)";
        this.headerIndex = 1;
        this.contentIndex = this.fragmentParsers.size() + 2;
        for (int i = 0; i < this.fragmentParsers.size(); ++i) {
            ++((AbstractFragmentParserPattern)this.fragmentParsers.get((int)i)).regexpGroupIndex;
        }
        this.recordRegexpPattern = Pattern.compile(this.recordRegexp);
    }

    private String buildPatternRegexp() {
        String[] patternFragments = new String[this.fragmentParsers.size()];
        int[] startPositions = new int[this.fragmentParsers.size()];
        for (int i = 0; i < this.fragmentParsers.size(); ++i) {
            patternFragments[i] = ((LogRecordMatcher.FragmentParserPattern)this.fragmentParsers.get(i)).getPattern();
            startPositions[i] = ((LogRecordMatcher.FragmentParserPattern)this.fragmentParsers.get(i)).getPatternStartPosition();
        }
        int[] fragmentRegexpIndexes = new int[this.fragmentParsers.size()];
        String regexp = this.pattern.getRegexpWithWrap(patternFragments, startPositions, fragmentRegexpIndexes);
        for (int i = 0; i < fragmentRegexpIndexes.length; ++i) {
            ((AbstractFragmentParserPattern)this.fragmentParsers.get((int)i)).regexpGroupIndex = fragmentRegexpIndexes[i];
        }
        return regexp;
    }

    @Override
    public Matcher matches(CharSequence line) {
        return this.recordRegexpPattern.matcher(line);
    }

    @Override
    public String getStringValueFor(Matcher matcher, FragmentParser<?> parser) {
        int resolverIndex = this.fragmentParsers.indexOf(parser);
        if (resolverIndex == -1) {
            throw new IllegalArgumentException("Unknown resolver '" + String.valueOf(parser) + "'.");
        }
        return matcher.group(parser.getRegexpGroupIndex());
    }

    @Override
    public List<FragmentParser<?>> listFragmentParsers() {
        return new ArrayList(this.fragmentParsers);
    }

    public String getPatternString() {
        return this.pattern.getPattern();
    }

    public String getPatternRegexp() {
        return this.patternRegexp;
    }

    @Override
    public String getRecordRegexp() {
        return this.recordRegexp;
    }

    public int getHeaderIndex() {
        return this.headerIndex;
    }

    public int getContentIndex() {
        return this.contentIndex;
    }

    public void addFragmentParser(LogRecordMatcher.FragmentParserPattern<?> fragmentParser) {
        if (this.getFragmentParser(fragmentParser.getName()) != null) {
            throw new IllegalArgumentException("Resolver with name '" + fragmentParser.getName() + "' already added.");
        }
        this.fragmentParsers.add(fragmentParser);
        this.buildRegexp();
    }

    @Override
    public FragmentParser getFragmentParser(String name) {
        return this.fragmentParsers.stream().filter(r -> r.getName().equals(name)).findFirst().orElse(null);
    }

    public String toString() {
        return "LogRecordPattern{pattern=" + this.pattern.getPattern() + ", recordRegexp='" + this.recordRegexp + "', fragmentParsers=" + String.valueOf(this.fragmentParsers) + "}";
    }

    public static LogRecordMatcherPatternBuilder builder() {
        return new LogRecordMatcherPatternBuilder();
    }

    public static abstract class AbstractFragmentParserPattern<T>
    implements LogRecordMatcher.FragmentParserPattern<T> {
        private String name;
        private String pattern;
        private int patternStartPosition;
        private int regexpGroupIndex;

        public AbstractFragmentParserPattern(String name, String pattern, int patternStartPosition) {
            this.name = name;
            this.pattern = pattern;
            this.patternStartPosition = patternStartPosition;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getPattern() {
            return this.pattern;
        }

        @Override
        public int getPatternStartPosition() {
            return this.patternStartPosition;
        }

        @Override
        public int getRegexpGroupIndex() {
            return this.regexpGroupIndex;
        }

        public String toString() {
            return "AbstractFragmentResolver{name='" + this.name + "', pattern='" + this.pattern + "'}";
        }
    }

    public static class LogRecordMatcherPatternBuilder {
        private String pattern;
        private String timestampPattern;
        private String timestampJavaFormat;

        private LogRecordMatcherPatternBuilder() {
        }

        public LogRecordMatcherPatternBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public LogRecordMatcherPatternBuilder timestampPattern(String timestampPattern) {
            this.timestampPattern = timestampPattern;
            return this;
        }

        public LogRecordMatcherPatternBuilder timestampJavaFormat(String timestampJavaFormat) {
            this.timestampJavaFormat = timestampJavaFormat;
            return this;
        }

        public LogRecordMatcherPattern build() {
            SymbolPatterns.SymbolPattern symbolPattern = SymbolPatterns.from(this.pattern);
            LogRecordMatcherPattern matcherPattern = new LogRecordMatcherPattern(symbolPattern instanceof SymbolPatterns.CompoundSymbolPattern ? (SymbolPatterns.CompoundSymbolPattern)symbolPattern : new SymbolPatterns.CompoundSymbolPattern(symbolPattern));
            if (this.timestampPattern != null) {
                matcherPattern.addFragmentParser(TimestampResolverUtils.createParser(this.pattern, this.timestampPattern, this.timestampJavaFormat));
            }
            return matcherPattern;
        }
    }
}

