/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace.record;

import com.streamscape.sef.trace.record.LogMatcher;
import com.streamscape.sef.trace.record.LogRecordMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public abstract class AbstractLogMatcher<T>
implements LogMatcher<T> {
    private final LogRecordMatcher logRecordMatcher;
    private boolean firstTime = true;
    private String lastDelimiter = "";
    private LogLinePair lastLogLinePair;
    private StringBuilder lineBuilder = new StringBuilder();
    private long lineBuilderOffset = -1L;
    private boolean seenCR = false;

    public AbstractLogMatcher(LogRecordMatcher logRecordMatcher) {
        this.logRecordMatcher = logRecordMatcher;
    }

    @Override
    public List<T> match(String block) {
        return this.match(block, new ArrayList());
    }

    public List<T> match(String block, long offset) {
        return this.match(block, offset, new ArrayList());
    }

    @Override
    public List<T> match(String block, List<T> result) {
        return this.match(block, 0L, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> match(String block, long offset, List<T> result) {
        if (block == null) {
            if (this.lineBuilder.length() > 0) {
                this.splitInternal("\n", result);
            }
            if (this.lastLogLinePair != null) {
                try {
                    result.add(this.doCreateLogRecord(this.logRecordMatcher, this.lastLogLinePair));
                }
                finally {
                    this.lastLogLinePair = null;
                }
            }
        } else {
            if (this.lineBuilderOffset == -1L || this.lineBuilder.length() == 0) {
                this.lineBuilderOffset = offset;
            }
            this.splitInternal(block, result);
        }
        return result;
    }

    private List<T> splitInternal(String block, List<T> traces) {
        block4: for (int i = 0; i < block.length(); ++i) {
            char c = block.charAt(i);
            switch (c) {
                case '\n': {
                    if (this.seenCR) {
                        this.seenCR = false;
                        this.lastDelimiter = "\r\n";
                        continue block4;
                    }
                    T completedTrace = this.processLineBuilder("\n");
                    if (completedTrace == null) continue block4;
                    traces.add(completedTrace);
                    continue block4;
                }
                case '\r': {
                    this.seenCR = true;
                    T completedTrace = this.processLineBuilder("\r");
                    if (completedTrace == null) continue block4;
                    traces.add(completedTrace);
                    continue block4;
                }
                default: {
                    this.seenCR = false;
                    this.lineBuilder.append(c);
                }
            }
        }
        return traces;
    }

    private T processLineBuilder(String delimiter) {
        LogLinePair completedLogLinePair = null;
        LogLinePair logLinePair = this.parseLogLine(this.lineBuilder, this.lineBuilderOffset);
        if (logLinePair == null) {
            if (!this.firstTime) {
                if (this.lastLogLinePair != null) {
                    this.lastLogLinePair.logLineBuilder.append(this.lastDelimiter).append((CharSequence)this.lineBuilder);
                    this.lineBuilderOffset += (long)(this.lastDelimiter.length() + this.lineBuilder.length());
                }
            } else {
                logLinePair = new LogLinePair(null, this.lineBuilder, this.lineBuilderOffset);
            }
        }
        if (logLinePair != null) {
            this.lineBuilderOffset += (long)(this.lastDelimiter.length() + this.lineBuilder.length());
            if (this.lastLogLinePair != null) {
                completedLogLinePair = this.lastLogLinePair;
            }
            this.lastLogLinePair = logLinePair;
        }
        this.lineBuilder = new StringBuilder();
        this.firstTime = false;
        this.lastDelimiter = delimiter;
        if (completedLogLinePair != null) {
            return this.doCreateLogRecord(this.logRecordMatcher, completedLogLinePair);
        }
        return null;
    }

    private LogLinePair parseLogLine(StringBuilder logLineBuilder, long offset) {
        Matcher matcher = this.logRecordMatcher.matches(logLineBuilder);
        if (matcher.matches()) {
            return new LogLinePair(matcher, logLineBuilder, offset);
        }
        return null;
    }

    protected abstract T doCreateLogRecord(LogRecordMatcher var1, LogLinePair var2);

    static class LogLinePair {
        Matcher matcher;
        StringBuilder logLineBuilder;
        long offset;

        public LogLinePair(Matcher matcher, StringBuilder logLineBuilder, long offset) {
            this.matcher = matcher;
            this.logLineBuilder = logLineBuilder;
            this.offset = offset;
        }
    }
}

