/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sef.container.ContainerLogger;
import com.streamscape.sef.trace.AbstractTrace;
import com.streamscape.sef.trace.TraceConfigurationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TraceConfigurator {
    private static TraceConfigurator instance = null;
    private boolean logEnabled = false;
    private String logFilename;
    private String logDefaultFilename;
    private File logFile;
    private Logger logger;

    static List<String> getWildcarded(List<String> packages) {
        ArrayList<String> result = new ArrayList<String>(packages.size());
        result.addAll(packages.stream().map(packageName -> packageName + ".*").collect(Collectors.toList()));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TraceConfigurator getInstance() {
        if (instance != null) return instance;
        Class<TraceConfigurator> clazz = TraceConfigurator.class;
        synchronized (TraceConfigurator.class) {
            if (instance != null) return instance;
            instance = new TraceConfigurator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TraceConfigurator() {
    }

    public synchronized void enable(String parameters) throws TraceConfigurationException {
        if (parameters != null) {
            if ((parameters = parameters.trim()).length() == 0) {
                this.doEnableAll(Trace.Level.DEBUG);
            } else {
                int openingBracketIndex = parameters.indexOf(40);
                if (openingBracketIndex == -1) {
                    this.doEnableAll(Trace.Level.fromString(parameters));
                } else {
                    TraceConfigurator.check(openingBracketIndex == 0, "invalid syntax: '(' is not first character.");
                    int closingBracketIndex = parameters.indexOf(41);
                    TraceConfigurator.check(closingBracketIndex != -1, "invalid syntax: ')' missed.");
                    String classesParameter = parameters.substring(openingBracketIndex + 1, closingBracketIndex);
                    TraceConfigurator.check(classesParameter.length() != 0, "invalid syntax: classes inside of '()' missed.");
                    this.doEnable(StringUtils.splitWithTrim(classesParameter, ','), closingBracketIndex != parameters.length() - 1 ? Trace.Level.fromString(parameters.substring(closingBracketIndex + 1)) : Trace.Level.DEBUG);
                }
            }
        }
    }

    void doEnableAll(Trace.Level level) throws TraceConfigurationException {
        Trace.enable("*", level);
    }

    void doEnable(List<String> classNames, Trace.Level level) throws TraceConfigurationException {
        if (classNames.contains("*")) {
            this.doEnableAll(level);
        } else {
            for (String className : classNames) {
                Trace.enable(className, level);
            }
        }
    }

    public synchronized void disable(String parameters) throws TraceConfigurationException {
        if (parameters != null) {
            if ((parameters = parameters.trim()).length() == 0) {
                this.doDisableAll();
            } else {
                int openingBracketIndex = parameters.indexOf(40);
                TraceConfigurator.check(openingBracketIndex == 0, "invalid syntax: '(' is not first character.");
                int closingBracketIndex = parameters.indexOf(41);
                TraceConfigurator.check(closingBracketIndex != -1, "invalid syntax: ')' missed.");
                TraceConfigurator.check(closingBracketIndex == parameters.length() - 1, "invalid syntax: ')' is not last character.");
                String classesParameter = parameters.substring(openingBracketIndex + 1, closingBracketIndex);
                TraceConfigurator.check(classesParameter.length() != 0, "invalid syntax: classes inside of '()' missed.");
                this.doDisable(StringUtils.splitWithTrim(classesParameter, ','));
            }
        }
    }

    void doDisableAll() throws TraceConfigurationException {
        Trace.disable("*");
    }

    void doDisable(List<String> classNames) throws TraceConfigurationException {
        if (classNames.contains("*")) {
            this.doDisableAll();
        } else {
            classNames.forEach(Trace::disable);
        }
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void enableLog(String logFilename) {
        this.enableLog(logFilename, null);
    }

    public void enableLog(String logFilename, String logDefaultFilename) {
        if (logFilename != null) {
            this.logFilename = logFilename;
            this.logDefaultFilename = logDefaultFilename;
            this.logEnabled = true;
        }
    }

    public void enableLog(Logger logger) {
        if (logger != null) {
            this.logger = logger;
            this.logEnabled = true;
        }
    }

    public void init(boolean redirectSystemOutput) {
        this.initLog(redirectSystemOutput);
        this.initTraceImpl();
    }

    public void init(boolean redirectSystemOutput, String configFilename) {
        this.init(redirectSystemOutput);
        Trace.setConfigurationFile(configFilename);
    }

    public void init(boolean redirectSystemOutput, String configFilename, String logFilename) {
        this.enableLog(logFilename);
        this.init(redirectSystemOutput);
        Trace.setConfigurationFile(configFilename);
    }

    void initLog(boolean redirectSystemOutput) {
        if (this.logEnabled) {
            try {
                if (this.logger == null) {
                    this.logger = new ContainerLogger(this.logFilename, this.logDefaultFilename);
                    this.logFile = ((ContainerLogger)this.logger).getFile();
                    if (redirectSystemOutput) {
                        ((ContainerLogger)this.logger).redirectSystemOutput();
                    }
                }
            }
            catch (IOException exception) {
                System.err.println("ERROR: Initialization of Container Logger failed: " + exception.toString());
                System.err.println("ERROR: Container Logger disabled.");
                this.logEnabled = false;
            }
        }
    }

    void initTraceImpl() {
        AbstractTrace.init();
        if (this.logEnabled) {
            Trace.setLogger("*", this.logger);
        }
    }

    static void check(boolean condition, String message) throws TraceConfigurationException {
        if (!condition) {
            throw new TraceConfigurationException(message);
        }
    }

    public File getLogFile() {
        return this.logFile;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setBroadcast(String parameters, boolean broadcast) {
        if (parameters == null || parameters.isEmpty() || parameters.equalsIgnoreCase("*")) {
            this.setBroadcastAll(broadcast);
        } else {
            for (String className : StringUtils.splitWithTrim(parameters, ',')) {
                Trace.setBroadcast(className, broadcast);
            }
        }
    }

    public void setBroadcastAll(boolean broadcast) {
        Trace.setBroadcast("*", broadcast);
    }
}

