/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace;

import com.streamscape.sef.trace.AbstractTrace;
import com.streamscape.sef.trace.TraceRecord;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class LogSplitter {
    private boolean firstTime = true;
    private String lastDelimiter = "";
    private TraceRecord lastTraceRecord;
    private StringBuilder lineBuilder = new StringBuilder();
    private boolean seenCR = false;
    private final SimpleDateFormat DATE_FORMAT = AbstractTrace.createDateFormat();
    private static final Pattern TRACE_PATTERN = Pattern.compile("^\\[(\\d\\d/\\d\\d/\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d)]\\s\\[TRACE\\]\\s\\[(ERROR|DEBUG|INFO\\s)\\]\\s\\[([^\\]]*)\\]\\s(.*)$");
    private static final Pattern COMPONENT_PATTERN = Pattern.compile("^\\[(\\d\\d/\\d\\d/\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d)]\\s\\[(ERROR|DEBUG|INFO\\s)\\]\\s\\[([^\\]]*)\\](?:\\s\\[(.*)\\])?+\\s(.*)$");

    public List<TraceRecord> split(String block) {
        ArrayList<TraceRecord> result = new ArrayList<TraceRecord>();
        this.split(block, result);
        return result;
    }

    public void split(String block, List<TraceRecord> result) {
        if (block == null) {
            if (this.lineBuilder.length() > 0) {
                this.splitInternal("\n", result);
            }
            if (this.lastTraceRecord != null) {
                try {
                    result.add(this.lastTraceRecord.resolve());
                }
                finally {
                    this.lastTraceRecord = null;
                }
            }
        } else {
            this.splitInternal(block, result);
        }
    }

    private List<TraceRecord> splitInternal(String block, List<TraceRecord> traces) {
        block4: for (int i = 0; i < block.length(); ++i) {
            char c = block.charAt(i);
            switch (c) {
                case '\n': {
                    if (this.seenCR) {
                        this.seenCR = false;
                        this.lastDelimiter = "\r\n";
                        continue block4;
                    }
                    TraceRecord completedTrace = this.processLineBuilder("\n");
                    if (completedTrace == null) continue block4;
                    traces.add(completedTrace.resolve());
                    continue block4;
                }
                case '\r': {
                    this.seenCR = true;
                    TraceRecord completedTrace = this.processLineBuilder("\r");
                    if (completedTrace == null) continue block4;
                    traces.add(completedTrace.resolve());
                    continue block4;
                }
                default: {
                    this.seenCR = false;
                    this.lineBuilder.append(c);
                }
            }
        }
        return traces;
    }

    private TraceRecord processLineBuilder(String delimiter) {
        TraceRecord completedTrace = null;
        TraceRecord traceRecord = this.parseTraceLine(this.lineBuilder);
        if (traceRecord == null) {
            if (!this.firstTime && this.lastTraceRecord != null) {
                this.lastTraceRecord.getMessageBuilder().append(this.lastDelimiter).append((CharSequence)this.lineBuilder);
            }
        } else {
            if (this.lastTraceRecord != null) {
                completedTrace = this.lastTraceRecord;
            }
            this.lastTraceRecord = traceRecord;
        }
        this.lineBuilder = new StringBuilder();
        this.firstTime = false;
        this.lastDelimiter = delimiter;
        return completedTrace;
    }

    private TraceRecord parseTraceLine(StringBuilder traceBuilder) {
        String timestamp = null;
        String level = null;
        String clazz = null;
        String component = null;
        String entity = null;
        String message = null;
        if (traceBuilder.indexOf("[TRACE]") != -1) {
            matcher = TRACE_PATTERN.matcher(traceBuilder);
            if (matcher.matches()) {
                timestamp = matcher.group(1);
                level = matcher.group(2);
                clazz = matcher.group(3);
                message = matcher.group(4);
            }
        } else {
            matcher = COMPONENT_PATTERN.matcher(traceBuilder);
            if (matcher.matches()) {
                timestamp = matcher.group(1);
                level = matcher.group(2);
                component = matcher.group(3);
                entity = matcher.group(4);
                message = matcher.group(5);
            }
        }
        if (timestamp != null) {
            TraceRecord record = new TraceRecord();
            try {
                record.setTimestamp(this.DATE_FORMAT.parse(LogSplitter.trim(timestamp)).getTime());
            }
            catch (ParseException exception) {
                System.out.println("Parsing timestamp '" + timestamp + "' failed.");
                exception.printStackTrace();
            }
            record.setLevel(LogSplitter.trim(level));
            record.setClassName(LogSplitter.trim(clazz));
            record.setComponent(LogSplitter.trim(component));
            record.setEntity(LogSplitter.trim(entity));
            record.getMessageBuilder().append(message);
            return record;
        }
        return null;
    }

    private static String trim(String str) {
        return str != null ? str.trim() : str;
    }

    public static SimpleDateFormat createDateFormat() {
        return AbstractTrace.createDateFormat();
    }
}

