/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.trace.LogEventSender;
import com.streamscape.sef.trace.TraceConfigurationException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class AbstractTrace {
    public static final SimpleDateFormat DATE_FORMAT = AbstractTrace.createDateFormat();
    public static final String HTTP_SERVER_PACKAGE = "com.streamscape.sef.network.http.server";
    public static final String HTTP_LOGGER_CLASS = "com.streamscape.sef.network.http.server.jetty.log.JettyTraceLogger";
    protected static TraceImpl impl = new TraceImpl();

    public static SimpleDateFormat createDateFormat() {
        return new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    }

    static void init() {
        if (impl == null) {
            impl = new TraceImpl();
        }
    }

    public static String formatMessageArgs(String prefix, String message, Object ... args) {
        if (args.length == 0 && prefix == null) {
            return message;
        }
        if (message == null) {
            message = "null";
        }
        String braces = "{}";
        StringBuilder builder = new StringBuilder();
        if (prefix != null) {
            builder.append(prefix);
        }
        int start = 0;
        for (Object arg : args) {
            int bracesIndex = message.indexOf("{}", start);
            if (bracesIndex < 0) {
                builder.append(message.substring(start));
                builder.append(" ");
                builder.append(arg);
                start = message.length();
                continue;
            }
            builder.append(message, start, bracesIndex);
            builder.append(arg);
            start = bracesIndex + "{}".length();
        }
        if (builder.length() > 0) {
            builder.append(message.substring(start));
            message = builder.toString();
        }
        return message;
    }

    protected static class TraceImpl {
        private LogRule globalRule;
        private Map<String, LogRule> packageRules;
        private Map<String, LogRule> classRules;
        private LogRule httpServerRule;
        private LogRule httpLoggerRule;
        private SimpleDateFormat dateFormat;
        private File configFile;
        private File originalConfigFile;
        private List<String> configFileComments;
        private static final String PACKAGE_SUFFIX = ".*";
        private static final String HTTP_SERVER_PACKAGE_WITH_SUFFIX = "com.streamscape.sef.network.http.server.*";
        private boolean isFirstWrite = true;

        private TraceImpl() {
            this.init();
            String traceClasses = System.getProperty(Trace.class.getName() + ".error");
            if (traceClasses != null) {
                this.init(StringUtils.split(traceClasses, ','), Trace.Level.ERROR);
            } else {
                traceClasses = System.getProperty(Trace.class.getName() + ".info");
                if (traceClasses != null) {
                    this.init(StringUtils.split(traceClasses, ','), Trace.Level.INFO);
                } else {
                    traceClasses = System.getProperty(Trace.class.getName() + ".debug");
                    if (traceClasses != null) {
                        this.init(StringUtils.split(traceClasses, ','), Trace.Level.DEBUG);
                    }
                }
            }
        }

        private void init() {
            this.globalRule = new LogRule();
            this.classRules = new TreeMap<String, LogRule>();
            this.packageRules = new TreeMap<String, LogRule>();
            this.dateFormat = DATE_FORMAT;
            this.configFile = null;
            this.originalConfigFile = null;
            this.configFileComments = new ArrayList<String>();
        }

        private void init(Collection<String> classNames, Trace.Level level) {
            for (String className : classNames) {
                this.doEnable(className, level, false);
            }
        }

        public void enable(String className, Trace.Level level) {
            this.doEnable(className, level, true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private synchronized void doEnable(String className, Trace.Level level, boolean updateConfigFile) {
            if (this.isHttpServerPackageOrChild(className)) {
                if (this.isHttpServerPackage(TraceImpl.getPackageName(className))) {
                    this.doEnableHttpPackage(level);
                } else {
                    if (!this.isHttpLoggerClass(className)) return;
                    this.doEnableHttpLogger(level);
                }
            } else {
                this.doEnable(className, level);
            }
            if (!updateConfigFile) return;
            this.writeConfigFile();
        }

        private void doEnableHttpPackage(Trace.Level level) {
            if (this.httpServerRule == null) {
                this.httpServerRule = new LogRule(level, this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE));
            } else {
                this.httpServerRule.level = level;
            }
            if (!TraceImpl.changeHttpLevel(this.httpLoggerRule, level)) {
                this.httpLoggerRule = new LogRule(Trace.Level.ERROR, this.httpServerRule);
            }
        }

        private void doEnableHttpLogger(Trace.Level level) {
            if (this.httpLoggerRule == null) {
                this.httpLoggerRule = new LogRule(level, this.getParentRuleForHttpLoggerClass());
            } else {
                this.httpLoggerRule.level = level;
            }
        }

        private void doEnable(String className, Trace.Level level) {
            if (className.equals("*")) {
                this.doEnableAll(level);
            } else if (TraceImpl.isPackage(className)) {
                this.doEnablePackage(TraceImpl.getPackageName(className), level);
            } else {
                this.doEnableClass(className, level);
            }
        }

        private void doEnableAll(Trace.Level level) {
            this.globalRule.level = level;
            TraceImpl.changeLevel(this.classRules, level);
            TraceImpl.changeLevel(this.packageRules, level);
            this.changeHttpLevels(level, this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE));
            this.logInternal("Trace level " + level.name() + " enabled for all classes.");
        }

        private static void changeLevel(Map<String, LogRule> rules, Trace.Level level) {
            rules.forEach((key, value) -> {
                value.level = level;
            });
        }

        private void doEnablePackage(String packageName, Trace.Level level) {
            TraceImpl.doEnablePackage(packageName, level, this.classRules);
            TraceImpl.doEnablePackage(packageName, level, this.packageRules);
            LogRule packageRule = this.packageRules.computeIfAbsent(packageName, key -> new LogRule(level, this.getPackageRule(packageName)));
            if (this.isHttpServerPackageParent(packageName)) {
                this.changeHttpLevels(level, packageRule);
            }
            this.logInternal("Trace level " + level.name() + " enabled for '" + packageName + "' package.");
        }

        private static void doEnablePackage(String packageName, Trace.Level level, Map<String, LogRule> rules) {
            rules.entrySet().stream().filter(entry -> TraceImpl.matchPackage((String)entry.getKey(), packageName)).forEach(entry -> {
                ((LogRule)entry.getValue()).level = level;
            });
        }

        private void doEnableClass(String className, Trace.Level level) {
            LogRule rule = this.classRules.get(className);
            if (rule != null) {
                rule.level = level;
            } else {
                this.classRules.put(className, new LogRule(level, this.getPackageRule(className)));
            }
            this.logInternal("Trace level " + level.name() + " enabled for '" + className + "' class.");
        }

        public void disable(String className) {
            this.doDisable(className, true);
        }

        private synchronized void doDisable(String className, boolean updateConfigFile) {
            if (className.equals("*")) {
                this.doDisableAll();
            } else if (TraceImpl.isPackage(className)) {
                this.doDisablePackage(TraceImpl.getPackageName(className));
            } else {
                this.doDisableClass(className);
            }
            this.clear();
            if (updateConfigFile) {
                this.writeConfigFile();
            }
        }

        private void doDisableAll() {
            TraceImpl.nullifyLevel(this.globalRule);
            TraceImpl.nullifyLevel(this.packageRules);
            TraceImpl.nullifyLevel(this.classRules);
            TraceImpl.nullifyLevel(this.httpServerRule);
            TraceImpl.nullifyLevel(this.httpLoggerRule);
            this.logInternal("Trace disabled for all classes.");
        }

        private static void nullifyLevel(Map<String, LogRule> rules) {
            rules.forEach((key, value) -> TraceImpl.nullifyLevel(value));
        }

        private void doDisablePackage(String packageName) {
            TraceImpl.nullifyLevel(packageName, this.packageRules);
            TraceImpl.nullifyLevel(packageName, this.classRules);
            if (this.isHttpServerPackageOrChild(packageName) || this.isHttpServerPackageParent(packageName)) {
                TraceImpl.nullifyLevel(this.httpServerRule);
                TraceImpl.nullifyLevel(this.httpLoggerRule);
                LogRule parentRule = this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE);
                if (parentRule != null && parentRule.level != null) {
                    this.changeHttpLevels(Trace.Level.ERROR, parentRule);
                }
            }
            this.logInternal("Trace disabled for '" + packageName + "' package.");
        }

        private static void nullifyLevel(String packageName, Map<String, LogRule> rules) {
            rules.entrySet().stream().filter(entry -> TraceImpl.matchPackage((String)entry.getKey(), packageName)).forEach(entry -> TraceImpl.nullifyLevel((LogRule)entry.getValue()));
        }

        private void doDisableClass(String className) {
            if (this.isHttpLoggerClass(className)) {
                TraceImpl.nullifyLevel(this.httpLoggerRule);
                LogRule parentRule = this.getParentRuleForHttpLoggerClass();
                if (parentRule != null && parentRule.level != null) {
                    this.changeHttpLoggerRule(Trace.Level.ERROR, parentRule);
                }
            } else {
                TraceImpl.nullifyLevel(this.classRules.get(className));
            }
            this.logInternal("Trace disabled for '" + className + "' class.");
        }

        private void changeHttpLevels(Trace.Level level, LogRule parentRule) {
            if (!TraceImpl.changeHttpLevel(this.httpServerRule, level)) {
                this.httpServerRule = new LogRule(Trace.Level.ERROR, parentRule);
            }
            this.changeHttpLoggerRule(level, this.getParentRuleForHttpLoggerClass());
        }

        private void changeHttpLoggerRule(Trace.Level level, LogRule parentRule) {
            if (!TraceImpl.changeHttpLevel(this.httpLoggerRule, level)) {
                this.httpLoggerRule = new LogRule(Trace.Level.ERROR, parentRule);
            }
        }

        private static boolean changeHttpLevel(LogRule rule, Trace.Level level) {
            if (rule != null) {
                if (level == Trace.Level.ERROR) {
                    rule.level = Trace.Level.ERROR;
                } else if (level == Trace.Level.INFO) {
                    if (rule.level == null) {
                        rule.level = Trace.Level.ERROR;
                    } else if (rule.level == Trace.Level.DEBUG) {
                        rule.level = Trace.Level.INFO;
                    }
                } else if (level == Trace.Level.DEBUG && rule.level == null) {
                    rule.level = Trace.Level.ERROR;
                }
                return true;
            }
            return false;
        }

        private static void nullifyLevel(LogRule rule) {
            if (rule != null) {
                rule.level = null;
            }
        }

        private void clear() {
            TraceImpl.doClear(this.packageRules);
            TraceImpl.doClear(this.classRules);
            this.httpServerRule = TraceImpl.getClearedRule(this.httpServerRule);
            this.httpLoggerRule = TraceImpl.getClearedRule(this.httpLoggerRule);
        }

        private static void doClear(Map<String, LogRule> rules) {
            rules.entrySet().stream().filter(entry -> ((LogRule)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toList()).forEach(rules::remove);
        }

        private static LogRule getClearedRule(LogRule rule) {
            return rule == null || rule.isEmpty() ? null : rule;
        }

        public boolean isEnabled(String className) {
            LogRule rule = this.getRule(className);
            return rule != null && rule.level != null;
        }

        public boolean isEnabled(String className, Trace.Level level) {
            LogRule rule = this.getRule(className);
            return rule != null && level.insideOf(rule.level);
        }

        public Trace.Level getLevel(String className) {
            LogRule rule = this.getRule(className);
            return rule != null ? rule.level : null;
        }

        public synchronized void setLogger(String className, Logger logger) {
            if (className.equals("*")) {
                this.doSetGlobalLogger(logger);
            } else if (TraceImpl.isPackage(className)) {
                this.doSetPackageLogger(TraceImpl.getPackageName(className), logger);
            } else {
                this.doSetClassLogger(className, logger);
            }
            this.clear();
        }

        private void doSetGlobalLogger(Logger logger) {
            this.globalRule.logger = logger;
            TraceImpl.changeLogger(this.classRules, logger);
            TraceImpl.changeLogger(this.packageRules, logger);
            this.changeHttpLoggers(this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE), logger);
        }

        private static void changeLogger(Map<String, LogRule> rules, Logger logger) {
            rules.forEach((key, value) -> {
                value.logger = logger;
            });
        }

        private void doSetPackageLogger(String packageName, Logger logger) {
            if (this.isHttpServerPackageOrChild(packageName)) {
                if (this.isHttpServerPackage(packageName)) {
                    logger = this.adjustLogger(logger, packageName, false);
                    this.changeHttpLoggers(this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE), logger);
                }
            } else {
                logger = this.adjustLogger(logger, packageName, true);
                TraceImpl.changeLogger(packageName, logger, this.classRules);
                TraceImpl.changeLogger(packageName, logger, this.packageRules);
                LogRule packageRule = this.packageRules.get(packageName);
                if (logger != null && packageRule == null) {
                    packageRule = new LogRule(logger, this.getPackageRule(packageName));
                    this.packageRules.put(packageName, packageRule);
                }
                if (this.isHttpServerPackageParent(packageName)) {
                    this.changeHttpLoggers(packageRule, logger);
                }
            }
        }

        private Logger adjustLogger(Logger logger, String packageName, boolean skipExactMatch) {
            LogRule parentRule;
            if (logger == null && (parentRule = this.getPackageRule(packageName, skipExactMatch)) != null) {
                logger = parentRule.logger;
            }
            return logger;
        }

        private static void changeLogger(String packageName, Logger logger, Map<String, LogRule> rules) {
            rules.entrySet().stream().filter(entry -> TraceImpl.matchPackage((String)entry.getKey(), packageName)).forEach(entry -> {
                ((LogRule)entry.getValue()).logger = logger;
            });
        }

        private void changeHttpLoggers(LogRule parentRule, Logger logger) {
            if (!TraceImpl.changeLogger(this.httpServerRule, logger) && logger != null) {
                this.httpServerRule = TraceImpl.createHttpRule(parentRule, logger);
            }
            if (!TraceImpl.changeLogger(this.httpLoggerRule, logger) && logger != null) {
                this.httpLoggerRule = TraceImpl.createHttpRule(this.httpServerRule, logger);
            }
        }

        private static boolean changeLogger(LogRule rule, Logger logger) {
            if (rule != null) {
                rule.logger = logger;
                return true;
            }
            return false;
        }

        private void doSetClassLogger(String className, Logger logger) {
            if (this.isHttpServerPackageOrChild(className)) {
                if (this.isHttpLoggerClass(className)) {
                    LogRule parentRule = this.getParentRuleForHttpLoggerClass();
                    TraceImpl.doSetClassLogger(className, logger, this.httpLoggerRule, parentRule, () -> {
                        this.httpLoggerRule = TraceImpl.createHttpRule(parentRule, logger);
                    });
                }
            } else {
                LogRule parentRule = this.getPackageRule(className);
                TraceImpl.doSetClassLogger(className, logger, this.getClassRule(className), parentRule, () -> this.classRules.put(className, new LogRule(logger, parentRule)));
            }
        }

        private static void doSetClassLogger(String className, Logger logger, LogRule rule, LogRule parentRule, Runnable ruleCreator) {
            if (rule != null) {
                rule.logger = logger == null ? (parentRule != null ? parentRule.logger : null) : logger;
            } else if (logger != null) {
                ruleCreator.run();
            }
        }

        private static LogRule createHttpRule(LogRule parentRule, Logger logger) {
            return new LogRule(parentRule != null && parentRule.level != null ? Trace.Level.ERROR : null, logger, parentRule != null && parentRule.broadcast);
        }

        public Logger getLogger(String className) {
            LogRule rule = this.getRule(className);
            return rule != null ? rule.logger : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBroadcast(String className, boolean broadcast) {
            TraceImpl traceImpl = this;
            synchronized (traceImpl) {
                if (className.equals("*")) {
                    this.doSetGlobalBroadcast(broadcast);
                } else if (TraceImpl.isPackage(className)) {
                    this.doSetPackageBroadcast(TraceImpl.getPackageName(className), broadcast);
                } else {
                    this.doSetClassBroadcast(className, broadcast);
                }
                this.clear();
            }
            if (broadcast) {
                LogEventSender.getInstance();
            }
        }

        private void doSetGlobalBroadcast(boolean broadcast) {
            this.globalRule.broadcast = broadcast;
            TraceImpl.changeBroadcast(this.classRules, broadcast);
            TraceImpl.changeBroadcast(this.packageRules, broadcast);
            this.changeHttpBroadcasts(this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE), broadcast);
        }

        private static void changeBroadcast(Map<String, LogRule> rules, boolean broadcast) {
            rules.forEach((key, value) -> {
                value.broadcast = broadcast;
            });
        }

        private void doSetPackageBroadcast(String packageName, boolean broadcast) {
            if (this.isHttpServerPackageOrChild(packageName)) {
                if (this.isHttpServerPackage(packageName)) {
                    this.changeHttpBroadcasts(this.getPackageRule(AbstractTrace.HTTP_SERVER_PACKAGE), broadcast);
                }
            } else {
                TraceImpl.changeBroadcast(packageName, broadcast, this.classRules);
                TraceImpl.changeBroadcast(packageName, broadcast, this.packageRules);
                LogRule packageRule = this.packageRules.computeIfAbsent(packageName, k -> new LogRule(broadcast, this.getPackageRule(packageName)));
                if (this.isHttpServerPackageParent(packageName)) {
                    this.changeHttpBroadcasts(packageRule, broadcast);
                }
            }
        }

        private static void changeBroadcast(String packageName, boolean broadcast, Map<String, LogRule> rules) {
            rules.entrySet().stream().filter(entry -> TraceImpl.matchPackage((String)entry.getKey(), packageName)).forEach(entry -> {
                ((LogRule)entry.getValue()).broadcast = broadcast;
            });
        }

        private void changeHttpBroadcasts(LogRule parentRule, boolean broadcast) {
            if (!TraceImpl.changeBroadcast(this.httpServerRule, broadcast)) {
                this.httpServerRule = TraceImpl.createHttpRule(parentRule, broadcast);
            }
            if (!TraceImpl.changeBroadcast(this.httpLoggerRule, broadcast)) {
                this.httpLoggerRule = TraceImpl.createHttpRule(this.httpServerRule, broadcast);
            }
        }

        private static boolean changeBroadcast(LogRule rule, boolean broadcast) {
            if (rule != null) {
                rule.broadcast = broadcast;
                return true;
            }
            return false;
        }

        private void doSetClassBroadcast(String className, boolean broadcast) {
            if (this.isHttpServerPackageOrChild(className)) {
                if (this.isHttpLoggerClass(className)) {
                    TraceImpl.doSetClassBroadcast(className, broadcast, this.httpLoggerRule, () -> {
                        this.httpLoggerRule = TraceImpl.createHttpRule(this.getParentRuleForHttpLoggerClass(), broadcast);
                    });
                }
            } else {
                TraceImpl.doSetClassBroadcast(className, broadcast, this.getClassRule(className), () -> this.classRules.put(className, new LogRule(broadcast, this.getPackageRule(className))));
            }
        }

        private static void doSetClassBroadcast(String className, boolean broadcast, LogRule rule, Runnable ruleCreator) {
            if (rule != null) {
                rule.broadcast = broadcast;
            } else {
                ruleCreator.run();
            }
        }

        private static LogRule createHttpRule(LogRule parentRule, boolean broadcast) {
            return new LogRule(parentRule != null && parentRule.level != null ? Trace.Level.ERROR : null, parentRule != null ? parentRule.logger : null, broadcast);
        }

        public boolean isBroadcastEnabled(String className) {
            LogRule rule = this.getRule(className);
            return rule != null && rule.broadcast;
        }

        private synchronized LogRule getRule(String className) {
            if (this.isHttpServerPackageOrChild(className)) {
                return this.isHttpLoggerClass(className) ? this.httpLoggerRule : this.httpServerRule;
            }
            LogRule result = this.getClassRule(className);
            return result != null ? result : this.getPackageRule(className);
        }

        private LogRule getClassRule(String className) {
            return this.classRules.get(className);
        }

        private LogRule getPackageRule(String className) {
            return this.getPackageRule(className, false);
        }

        private LogRule getPackageRule(String className, boolean skipExactMatch) {
            Pair<Object, Integer> result = new Pair<Object, Integer>(null, 0);
            for (Map.Entry<String, LogRule> entry : this.packageRules.entrySet()) {
                this.checkPackageRule(className, skipExactMatch, entry.getKey(), entry.getValue(), result);
                if ((Integer)result.second != -1) continue;
                break;
            }
            return result.first != null ? (LogRule)result.first : this.globalRule;
        }

        private void checkPackageRule(String className, boolean skipExactMatch, String packageName, LogRule rule, Pair<LogRule, Integer> result) {
            if (TraceImpl.matchPackage(className, packageName) && packageName.length() > (Integer)result.second) {
                if (packageName.length() == className.length()) {
                    if (skipExactMatch) {
                        return;
                    }
                    result.first = rule;
                    result.second = -1;
                }
                result.first = rule;
                result.second = packageName.length();
            }
        }

        private boolean isHttpServerPackage(String className) {
            return className.equals(AbstractTrace.HTTP_SERVER_PACKAGE);
        }

        private boolean isHttpServerPackageOrChild(String className) {
            return TraceImpl.matchPackage(className, AbstractTrace.HTTP_SERVER_PACKAGE);
        }

        private boolean isHttpServerPackageParent(String packageName) {
            return TraceImpl.matchPackage(AbstractTrace.HTTP_SERVER_PACKAGE, packageName);
        }

        private boolean isHttpLoggerClass(String className) {
            return className.equals(AbstractTrace.HTTP_LOGGER_CLASS);
        }

        private LogRule getParentRuleForHttpLoggerClass() {
            return this.httpServerRule != null ? this.httpServerRule : this.getPackageRule(AbstractTrace.HTTP_LOGGER_CLASS);
        }

        private static boolean matchPackage(String className, String packageName) {
            return className.startsWith(packageName);
        }

        private static boolean isPackage(String className) {
            return className.endsWith(PACKAGE_SUFFIX);
        }

        private static String getPackageName(String fullName) {
            return fullName.substring(0, fullName.length() - 2);
        }

        public String getDateFormat() {
            return this.dateFormat.toPattern();
        }

        public void setDateFormat(String pattern) {
            this.dateFormat.applyPattern(pattern);
        }

        public TimeZone getTimeZone() {
            return this.dateFormat.getTimeZone();
        }

        public void setTimeZone(TimeZone timeZone) {
            this.dateFormat.setTimeZone(timeZone);
        }

        public synchronized List<String> getClasses() {
            return this.getLevels().stream().map(entry -> (String)entry.first).collect(Collectors.toList());
        }

        public RowSet getConfiguration() {
            RowMetaData metaData = new RowMetaData();
            metaData.addColumn("Class", SQLType.STRING);
            metaData.addColumn("Level", SQLType.STRING);
            RowSet result = new RowSet(metaData);
            for (Pair<String, Trace.Level> entry : this.getLevels()) {
                result.addRow(new Object[]{entry.first, ((Trace.Level)((Object)entry.second)).toString()});
            }
            return result;
        }

        public File getConfigurationFile() {
            return this.configFile;
        }

        public void setConfigurationFile(String filename) {
            this.configFile = new File(filename);
            this.originalConfigFile = new File(filename + ".original");
            this.readConfigFile();
            this.writeConfigFile();
        }

        private void readConfigFile() {
            this.configFileComments.clear();
            if (!this.configFile.exists()) {
                this.enableDefaultRules();
            } else {
                try {
                    ArrayList<String> parameters = new ArrayList<String>();
                    BufferedReader reader = new BufferedReader(new FileReader(this.configFile));
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line.isEmpty()) continue;
                        if (line.startsWith("#")) {
                            this.configFileComments.add(line);
                            continue;
                        }
                        parameters.add(line);
                    }
                    reader.close();
                    if (!parameters.isEmpty()) {
                        this.doEnable(parameters);
                    } else {
                        this.enableDefaultRules();
                    }
                }
                catch (FileNotFoundException exception) {
                    System.out.println("File '" + this.configFile.getPath() + "' not found.");
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    System.out.println("Parsing Trace configuration file '" + this.configFile.getPath() + "' failed.");
                }
            }
        }

        private void enableDefaultRules() {
            this.doEnable(Arrays.asList("* error", "com.streamscape.* info"));
        }

        private void doEnable(List<String> lines) {
            for (String line : lines) {
                try {
                    List<String> tokens = StringUtils.splitWithoutEmptyTokens(line, ' ');
                    TraceImpl.check(tokens.size() == 2, "Line '" + line + "' has invalid format.");
                    this.doEnable(tokens.get(0), Trace.Level.fromString(tokens.get(1)), false);
                }
                catch (TraceConfigurationException exception) {
                    System.out.println(exception.toString());
                    System.out.println("Parsing of line '" + line + "' failed. It will be ignored.");
                }
            }
        }

        private static void check(boolean condition, String message) throws TraceConfigurationException {
            if (!condition) {
                throw new TraceConfigurationException(message);
            }
        }

        public synchronized void writeConfigFile() {
            if (this.configFile != null) {
                if (this.isFirstWrite) {
                    this.originalConfigFile.delete();
                    this.configFile.renameTo(this.originalConfigFile);
                    this.isFirstWrite = false;
                }
                try {
                    PrintWriter writer = new PrintWriter(new FileWriter(this.configFile));
                    if (!this.configFileComments.isEmpty()) {
                        this.configFileComments.forEach(writer::println);
                        writer.println();
                    }
                    for (Pair<String, Trace.Level> entry : this.getLevels()) {
                        writer.append((CharSequence)entry.first).append(" ").append(((Trace.Level)((Object)entry.second)).toString()).append("\n");
                    }
                    writer.close();
                }
                catch (IOException exception) {
                    this.logException(this, exception, true);
                    this.logError(this, "Writing of Trace configuration file '" + this.configFile.getPath() + "' failed.", new Object[0]);
                    this.configFile.delete();
                    this.originalConfigFile.renameTo(this.configFile);
                }
            }
        }

        private synchronized List<Pair<String, Trace.Level>> getLevels() {
            LinkedList<Pair<String, Trace.Level>> result = new LinkedList<Pair<String, Trace.Level>>();
            Predicate<Map.Entry> IS_UNIQUE = entry -> this.isUnique((String)entry.getKey(), (LogRule)entry.getValue(), result);
            this.packageRules.entrySet().stream().filter(IS_UNIQUE).forEach(entry -> result.add(new Pair<String, Trace.Level>((String)entry.getKey(), ((LogRule)entry.getValue()).level)));
            if (this.isHttpRuleAcceptable(AbstractTrace.HTTP_SERVER_PACKAGE, this.httpServerRule, result)) {
                result.add(new Pair<String, Trace.Level>(AbstractTrace.HTTP_SERVER_PACKAGE, this.httpServerRule.level));
            }
            List classes = this.classRules.entrySet().stream().filter(IS_UNIQUE).map(entry -> new Pair<String, Trace.Level>((String)entry.getKey(), ((LogRule)entry.getValue()).level)).collect(Collectors.toCollection(LinkedList::new));
            if (this.isHttpRuleAcceptable(AbstractTrace.HTTP_LOGGER_CLASS, this.httpLoggerRule, result)) {
                classes.add(new Pair<String, Trace.Level>(AbstractTrace.HTTP_LOGGER_CLASS, this.httpLoggerRule.level));
            }
            result.forEach(entry -> {
                entry.first = String.valueOf(entry.first) + PACKAGE_SUFFIX;
            });
            if (this.globalRule.level != null) {
                result.add(0, new Pair<String, Trace.Level>("*", this.globalRule.level));
            }
            result.addAll(classes);
            return result;
        }

        private boolean isHttpRuleAcceptable(String className, LogRule rule, List<Pair<String, Trace.Level>> entries) {
            return rule != null && (rule.level == Trace.Level.INFO || rule.level == Trace.Level.DEBUG || this.isUnique(className, rule, entries));
        }

        private boolean isUnique(String className, LogRule rule, List<Pair<String, Trace.Level>> result) {
            return rule.level != null && !this.isEntryDuplicated(className, rule, result);
        }

        private boolean isEntryDuplicated(String className, LogRule rule, List<Pair<String, Trace.Level>> entries) {
            return rule.level.insideOf(this.globalRule.level) || entries.stream().anyMatch(entry -> TraceImpl.matchPackage(className, (String)entry.first) && rule.level.insideOf((Trace.Level)((Object)((Object)entry.second))));
        }

        public boolean logError(Object source, String message, Object ... args) {
            return this.log(source, Trace.Level.ERROR, "ERROR", message, args);
        }

        public boolean logInfo(Object source, String message, Object ... args) {
            return this.log(source, Trace.Level.INFO, "INFO ", message, args);
        }

        public boolean logDebug(Object source, String message, Object ... args) {
            return this.log(source, Trace.Level.DEBUG, "DEBUG", message, args);
        }

        public boolean logException(Object source, Throwable exception, boolean printStackTrace) {
            return this.log(source, Trace.Level.ERROR, "ERROR", printStackTrace ? TraceImpl.getStackTraceMessage(exception) : exception.toString(), new Object[0]);
        }

        boolean log(Object source, Trace.Level level, String messageType, String message, Object ... args) {
            String className = TraceImpl.getClassName(source);
            LogRule rule = this.getRule(className);
            if (rule != null && level.insideOf(rule.level)) {
                this.log(level, messageType, className, message, rule.logger, rule.broadcast, args);
                return true;
            }
            return false;
        }

        private void logInternal(String message) {
            this.log(Trace.Level.DEBUG, "DEBUG", Trace.class.getName(), message, null, false, new Object[0]);
        }

        private void log(Trace.Level level, String messageType, String className, String message, Logger logger, boolean broadcast, Object ... args) {
            Date currentDate = new Date();
            message = AbstractTrace.formatMessageArgs(null, message, args);
            String formattedMessage = this.formatMessage(currentDate, messageType, className, message);
            if (logger == null) {
                System.out.println(formattedMessage);
            } else {
                this.writeInLogger(logger, level, formattedMessage);
            }
            if (broadcast) {
                this.sendEvent(currentDate, level.name(), className, message);
            }
        }

        private String formatMessage(Date currentDate, String messageType, String className, String message) {
            StringBuilder result = new StringBuilder();
            result.append("[").append(this.dateFormat.format(currentDate)).append("]");
            result.append(" [TRACE]");
            result.append(" [").append(messageType).append("] ");
            if (className != null) {
                result.append("[").append(className).append("] ");
            }
            result.append(message);
            return result.toString();
        }

        private void writeInLogger(Logger logger, Trace.Level level, String message) {
            switch (level) {
                case ERROR: {
                    logger.logError(message);
                    break;
                }
                case INFO: {
                    logger.logInfo(message);
                    break;
                }
                case DEBUG: {
                    logger.logDebug(message);
                }
            }
        }

        private static String getStackTraceMessage(Throwable exception) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            exception.printStackTrace(new PrintStream(stream, true));
            return stream.toString();
        }

        private static String getClassName(Object source) {
            if (source != null) {
                return source instanceof Class ? ((Class)source).getName() : source.getClass().getName();
            }
            return null;
        }

        protected void sendEvent(Date logTime, String traceLevel, String className, String message) {
            try {
                LogEventSender.getInstance().sendEvent(logTime, traceLevel, className, message);
            }
            catch (Exception exception) {
                this.setBroadcast("*", false);
                this.logException(Trace.class, exception, true);
            }
        }

        private static class LogRule {
            Trace.Level level = null;
            Logger logger = null;
            boolean broadcast = false;

            LogRule() {
            }

            LogRule(Trace.Level level, LogRule parentRule) {
                this.level = level;
                if (parentRule != null) {
                    this.logger = parentRule.logger;
                    this.broadcast = parentRule.broadcast;
                }
            }

            LogRule(boolean broadcast, LogRule parentRule) {
                this.broadcast = broadcast;
                if (parentRule != null) {
                    this.level = parentRule.level;
                    this.logger = parentRule.logger;
                }
            }

            LogRule(Logger logger, LogRule parentRule) {
                this.logger = logger;
                if (parentRule != null) {
                    this.level = parentRule.level;
                    this.broadcast = parentRule.broadcast;
                }
            }

            LogRule(Trace.Level level, Logger logger, boolean broadcast) {
                this.level = level;
                this.logger = logger;
                this.broadcast = broadcast;
            }

            boolean isDefault() {
                return this.logger == null && !this.broadcast;
            }

            boolean isEmpty() {
                return this.level == null && this.isDefault();
            }
        }
    }
}

