/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.trace;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.sef.trace.LogEventSender;
import com.streamscape.sef.trace.TraceConfigurator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Consumer;

public abstract class AbstractComponentLogger {
    protected String sourceType;
    protected String sourceName;
    protected String component;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yy HH:mm:ss.SSS");
    private boolean broadcast = false;
    private int traceMask = Trace.Level.INFO.ordinal();
    private Logger logger = null;

    protected AbstractComponentLogger(String sourceType, String sourceName, Trace.Level level, TimeZone timeZone) {
        this.sourceType = sourceType;
        this.sourceName = sourceName;
        this.component = sourceName.replace('.', '/');
        this.traceMask = level.ordinal();
        this.logger = TraceConfigurator.getInstance().getLogger();
        this.dateFormat.setTimeZone(timeZone);
    }

    public void logDebug(String message) {
        this.logDebug(null, message);
    }

    public synchronized void logInfo(String message) {
        this.logInfo(null, message);
    }

    public synchronized void logError(String message) {
        this.logError(null, message);
    }

    public synchronized void logDebug(String entity, String message) {
        if (this.traceMask >= Trace.Level.DEBUG.ordinal()) {
            this.log("DEBUG", entity, message, this.getPrinter(str -> this.logger.logDebug((String)str)));
        }
    }

    public synchronized void logInfo(String entity, String message) {
        if (this.traceMask >= Trace.Level.INFO.ordinal()) {
            this.log("INFO ", entity, message, this.getPrinter(str -> this.logger.logInfo((String)str)));
        }
    }

    public synchronized void logError(String entity, String message) {
        if (this.traceMask >= Trace.Level.ERROR.ordinal()) {
            this.log("ERROR", entity, message, this.getPrinter(str -> this.logger.logError((String)str)));
        }
    }

    private Consumer<String> getPrinter(Consumer<String> loggerPrinter) {
        return this.logger != null ? loggerPrinter : System.out::println;
    }

    public void setDateFormat(String pattern) {
        this.dateFormat.applyPattern(pattern);
    }

    public void setBroadcast(boolean broadcast) {
        this.broadcast = broadcast;
    }

    public void setLogLevel(Trace.Level level) {
        this.traceMask = level.ordinal();
    }

    public Trace.Level getLogLevel() {
        return Trace.Level.values()[this.traceMask];
    }

    public boolean isLogEnabled(Trace.Level level) {
        return this.traceMask >= level.ordinal();
    }

    protected void log(String level, String entity, String message, Consumer<String> printer) {
        Date currentDate = new Date();
        printer.accept(this.formatMessage(currentDate, level, entity, message));
        if (this.broadcast) {
            this.doSendEvent(currentDate, level.trim(), entity, message);
        }
    }

    private String formatMessage(Date currentDate, String level, String entity, String message) {
        StringBuilder result = new StringBuilder();
        result.append("[").append(this.dateFormat.format(currentDate)).append("]");
        result.append(" [").append(level).append("]");
        result.append(" [").append(this.component).append("] ");
        if (entity != null) {
            result.append("[").append(entity).append("] ");
        }
        result.append(message);
        return result.toString();
    }

    private void doSendEvent(Date currentDate, String level, String entity, String message) {
        try {
            this.sendEvent(currentDate, level, entity, message);
        }
        catch (Exception exception) {
            this.setBroadcast(false);
            Trace.logException(this, exception, true);
        }
    }

    protected void sendEvent(Date timestamp, String level, String entity, String message) throws Exception {
        LogEventSender.getInstance().sendEvent(this.sourceType, this.sourceName, timestamp, level, this.component, entity, message);
    }
}

