/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractPackageOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class UnregisterPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "unregister package";

    public UnregisterPackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("UNREGISTER PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.setDescription("Unregisters the specified package from the Service Package Manifest.\n" + UnregisterPackageOperation.getSupportedTypes());
        this.syntax.setExamples("unregister service package service.TestPackage");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(this.getPackageType(statement), this.getPackageName(statement));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillAllPackages(completions);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        if (((ServiceContext)this.callable).getPackageManifestManager().isPackageLoaded(definition.getPackageType() + "." + definition.getPackageName())) {
            ((ServiceContext)this.callable).getPackageManifestManager().unloadPackage(definition.getPackageType() + "." + definition.getPackageName());
        }
        ((ServiceContext)this.callable).getPackageManifestManager().removePackage(definition.getPackageType() + "." + definition.getPackageName());
        return new SLResponse();
    }

    public static class Definition
    extends AbstractPackageOperation.ManifestDefinition {
        public Definition(String packageType, String packageName) {
            super(UnregisterPackageOperation.NAME, packageType, packageName);
        }
    }
}

