/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ShowPackageManifestOperation
extends AbstractServiceOperation {
    public static final String NAME = "show package manifest";

    public ShowPackageManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SHOW PACKAGE MANIFEST");
        this.syntax.setDescription("Shows the list of packages registered in Service Package Manifest.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(ShowPackageManifestOperation.createResultDescriptor());
        PackageManifestManager pkgManager = ((ServiceContext)this.callable).getPackageManifestManager();
        for (String pkgName : pkgManager.listPackages()) {
            PackageDescriptor pack = pkgManager.getPackage(pkgName);
            Row row = result.newRow();
            row.setRawData(new Object[]{pkgName, pack.isAutoload(), pack.useChainedLoader(), pack.loadAsRoot(), pkgManager.isPackageLoaded(pkgName)});
            result.addToRowSet(row);
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ShowPackageManifestOperation.addColumn(result, "Package Name");
        ShowPackageManifestOperation.addColumn(result, "Autoload");
        ShowPackageManifestOperation.addColumn(result, "Chained Loader");
        ShowPackageManifestOperation.addColumn(result, "Load As Root");
        ShowPackageManifestOperation.addColumn(result, "Loaded");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ShowPackageManifestOperation.NAME);
        }
    }
}

