/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.runtime.mf.operation.service.PropertyTypeSyntaxes;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.service.osf.config.AbstractFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class SetPropertyOperation
extends AbstractServiceOperation {
    public static final String NAME = "set property";

    public SetPropertyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET PROPERTY");
        this.syntax.addModifier((AbstractModifier)new BlockModifier("", "propertyBlockModifier").addModifier(new CompoundModifier("propertyCompoundModifier").addParameter((AbstractParameter)((ExpressionParameter)new ExpressionParameter("name").setExcludedDelimiters("[]/.")).setCompletionAdviser(new PropertyNameAdviser())).addModifier(new Modifier("=", "equals")).addParameter(new StringParameter("value"))).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Sets service property value.\nFor Factory and Object property types factory/object name is set only.\nService should be restarted to apply properties changes.");
        this.syntax.setExamples("set property ( directories.inbound = '/my/directory' )\nset property ( monitors[0]/action = 'drop' )\nset property ( system.settings/memory.size = '1024M' )");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        StatementValueList line = statement.getBlock("propertyBlockModifier").getLineByIndex(0);
        String value = line.getParameter("value").getValue();
        if (value != null && value.equalsIgnoreCase("null")) {
            value = null;
        }
        return new Definition(line.getParameter("name").getValue(), value);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, ((ServiceContext)this.callable).getServiceConfiguration().getServiceName(), ((ServiceContext)this.callable).getServiceConfiguration().getServiceType(), true);
        ServiceConfigurationProperty property = this.getProperty(sco, definition.propertyName);
        if (property == null) {
            throw new Exception("Property '" + definition.propertyName + "' doesn't exist.");
        }
        Object propertyValue = null;
        PropertyTypeSyntaxes.PropertySyntax propertySyntax = PropertyTypeSyntaxes.getPropertySyntax(property.getType());
        if (propertySyntax instanceof PropertyTypeSyntaxes.AbstractPropertySyntax) {
            propertyValue = ((PropertyTypeSyntaxes.AbstractPropertySyntax)propertySyntax).parsePropertyValue(definition.propertyValue);
        } else {
            switch (property.getType()) {
                case JDBC_FACTORY: 
                case TRANSPORT_FACTORY: 
                case CLIENT_FACTORY: {
                    AbstractFactoryPropertyValue value = (AbstractFactoryPropertyValue)property.getDefault();
                    if (value == null || value.getFactoryType().length() == 0) {
                        value = (AbstractFactoryPropertyValue)property.getValue();
                    }
                    if (value == null) {
                        throw new Exception("Cannot set factory name. No property default or value was set before and type is unknown.");
                    }
                    propertyValue = value.clone();
                    ((AbstractFactoryPropertyValue)propertyValue).setFactoryName(definition.propertyValue);
                    break;
                }
                case OBJECT: {
                    ObjectPropertyValue value = (ObjectPropertyValue)property.getDefault();
                    if (value == null || value.getObjectType().length() == 0) {
                        value = (ObjectPropertyValue)property.getValue();
                    }
                    if (value == null) {
                        throw new Exception("Cannot set object name. No property default or value was set before and type is unknown.");
                    }
                    propertyValue = new ObjectPropertyValue(definition.propertyValue, value.getObjectType(), value.getReferenceContext());
                    break;
                }
                case LIST: {
                    throw new Exception("Use corresponding syntax to set LIST property. See command help and use autocompletion.");
                }
                case TABLE: {
                    throw new Exception("Use corresponding syntax to set TABLE property. See command help and use autocompletion.");
                }
                default: {
                    throw new Exception(String.valueOf((Object)property.getType()) + " property not available for set.");
                }
            }
        }
        property.setValue(propertyValue);
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        return new SLResponse();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ServiceConfigurationProperty getProperty(ServiceConfigurationObject sco, String propName) throws Exception {
        ServiceConfigurationProperty property = null;
        String temp = propName;
        try {
            while (temp != null) {
                String name = null;
                String key = null;
                int index = temp.indexOf(47);
                if (index > 0) {
                    name = temp.substring(0, index);
                    temp = temp.substring(index + 1);
                } else {
                    name = temp;
                    temp = null;
                }
                index = name.indexOf(91);
                if (index > 0) {
                    int keyEnd = name.indexOf(93, index);
                    if (keyEnd <= 0) throw new IllegalArgumentException("Invalid property name format.");
                    key = name.substring(index + 1, keyEnd);
                    name = name.substring(0, index);
                }
                if (property != null) {
                    Object value = property.getValue();
                    Object tempProp = null;
                    if (!(value instanceof Hashtable)) {
                        throw new IllegalArgumentException("Unsupported property '" + name + "' type, TABLE is expected.");
                    }
                    tempProp = ((Hashtable)value).get(name);
                    if (!(tempProp instanceof ServiceConfigurationProperty)) throw new IllegalArgumentException("Invalid value of '" + name + "' property.");
                    property = tempProp;
                } else {
                    property = sco.getProperty(name);
                }
                if (key == null) continue;
                if (property.getType() == ServicePropertyType.TABLE) {
                    if (!(property.getValue() instanceof Hashtable)) throw new IllegalArgumentException("Table property '" + name + "' value is empty.");
                    property = (ServiceConfigurationProperty)((Hashtable)property.getValue()).get(key);
                    continue;
                }
                if (property.getType() != ServicePropertyType.LIST) throw new IllegalArgumentException("Unsupported property '" + name + "' type, TABLE or LIST is expected.");
                if (!(property.getValue() instanceof List)) throw new IllegalArgumentException("List property '" + name + "' value is empty.");
                Integer listValueIndex = 0;
                try {
                    listValueIndex = Integer.valueOf(key.trim());
                }
                catch (NumberFormatException error) {
                    throw new IllegalArgumentException("Invalid index " + key + " of list property '" + name + "'.");
                }
                property = (ServiceConfigurationProperty)((List)property.getValue()).get(listValueIndex);
            }
            return property;
        }
        catch (Exception exception) {
            throw new Exception("Unable to resolve property '" + propName + "'. " + exception.getMessage());
        }
    }

    static class PropertyNameAdviser
    implements CompletionAdviser<ServiceContext> {
        PropertyNameAdviser() {
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, ServiceContext callable, MFSession session) {
            ArrayList<String> completions = new ArrayList<String>();
            block3: for (ServiceConfigurationProperty property : callable.getServiceConfiguration().getProperties()) {
                switch (property.getType()) {
                    case LIST: 
                    case TABLE: {
                        this.addComplexPropertyCompletions(property, completions);
                        continue block3;
                    }
                }
                completions.add(property.getName());
            }
            return completions;
        }

        private void addComplexPropertyCompletions(ServiceConfigurationProperty property, List<String> completions) {
            switch (property.getType()) {
                case LIST: {
                    Object value = property.getValue();
                    if (value instanceof List) {
                        List props = (List)value;
                        for (int i = 0; i < props.size(); ++i) {
                            ServiceConfigurationProperty innerProp = (ServiceConfigurationProperty)props.get(i);
                            if (innerProp == null) continue;
                            ArrayList<String> temp = new ArrayList<String>();
                            this.addComplexPropertyCompletions(innerProp, temp);
                            for (int j = 0; j < temp.size(); ++j) {
                                completions.add(property.getName() + "[" + i + "]/" + (String)temp.get(j));
                            }
                        }
                        break;
                    }
                    completions.add(property.getName() + "[0]");
                    break;
                }
                case TABLE: {
                    Object value = property.getValue();
                    if (value instanceof Hashtable) {
                        Hashtable props = (Hashtable)value;
                        for (String key : props.keySet()) {
                            ServiceConfigurationProperty innerProp = (ServiceConfigurationProperty)props.get(key);
                            if (innerProp == null) continue;
                            ArrayList<String> temp = new ArrayList<String>();
                            this.addComplexPropertyCompletions(innerProp, temp);
                            String path = property.getName() + "/" + innerProp.getName();
                            if (temp.size() > 0) {
                                for (int j = 0; j < temp.size(); ++j) {
                                    completions.add(path + "/" + (String)temp.get(j));
                                }
                                continue;
                            }
                            completions.add(path);
                        }
                        break;
                    }
                    completions.add(property.getName());
                    break;
                }
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class Definition
    extends AbstractSLStatement {
        String propertyName;
        String propertyValue;

        Definition(String propertyName, String propertyValue) {
            super(SetPropertyOperation.NAME);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }
}

