/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class SetEventTriggerAutoEnableImpl
extends AbstractServiceOperation {
    public static final String NAME = "set event trigger autoenable";

    public SetEventTriggerAutoEnableImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET EVENT TRIGGER AUTOENABLE").addActionParameter(new IdentifierParameter("TriggerName")).addParameter(new BooleanParameter("autoenable"));
        this.syntax.setDescription("Sets autoenable for specified event trigger.");
        this.syntax.addCompletionCommand("list event triggers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new SetEventTriggerAutoEnable(statement.getParameter("TriggerName").getValue(), Boolean.parseBoolean(statement.getParameter("autoenable").getValue().toLowerCase()));
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        EventTriggerManagerDelegate triggerManagerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        completions.addAll(triggerManagerDelegate.listEventTriggers());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        EventTriggerManagerDelegate triggerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        SetEventTriggerAutoEnable operation = (SetEventTriggerAutoEnable)definition;
        if (triggerDelegate.existsEventTrigger(operation.getTriggerName())) {
            triggerDelegate.setEventTriggerAutoEnable(operation.getTriggerName(), operation.isAutoenable());
            return new SLResponse("Trigger '" + operation.getTriggerName() + "' autoenable has been set to '" + operation.isAutoenable() + "'.");
        }
        return new SLResponse("Specified trigger '" + operation.getTriggerName() + "' does not exist.", false);
    }

    public class SetEventTriggerAutoEnable
    extends AbstractSLStatement {
        private String triggerName;
        private boolean autoenable;

        public SetEventTriggerAutoEnable(String name, boolean autoenable) {
            super(SetEventTriggerAutoEnableImpl.NAME);
            this.triggerName = name;
            this.autoenable = autoenable;
        }

        public String getTriggerName() {
            return this.triggerName;
        }

        public boolean isAutoenable() {
            return this.autoenable;
        }
    }
}

