/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class SetDefaultDataspaceOperation
extends AbstractServiceOperation {
    public static final String NAME = "set default dataspace";

    public SetDefaultDataspaceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET DEFAULT DATASPACE").addActionParameter((SyntaxParameter)new StringParameter("type>.<name").setName("dsname"));
        this.syntax.setDescription("Sets default dataspace name.\n\nService restart is needed to use new datasapce in service.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("dsname").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, ((ServiceContext)this.callable).getServiceConfiguration().getServiceName(), ((ServiceContext)this.callable).getServiceConfiguration().getServiceType(), true);
        ConfigurationProperty property = sco.getAdvancedProperty("sessionDataspace");
        if (property == null) {
            property = ServiceConfigurationObject.createSessionDataspaceProperty();
            sco.addAdvancedProperty(property);
        }
        property.setTextValue(((Definition)statement).dsname);
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        return new SLResponse("NOTE: Service restart is needed to apply dataspace change.");
    }

    static class Definition
    extends AbstractSLStatement {
        private String dsname;

        Definition(String dsname) {
            super(SetDefaultDataspaceOperation.NAME);
            this.dsname = dsname;
        }
    }
}

