/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.ArrayList;
import java.util.List;

public class SetAdvancedPropertyOperation
extends AbstractServiceOperation {
    public static final String NAME = "set advanced property";

    public SetAdvancedPropertyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("SET ADVANCED PROPERTY");
        this.syntax.addModifier(SetAdvancedPropertyOperation.createAdvancedPropertyBlockModifier(true));
        this.syntax.setDescription("Sets service advanced property value.\nService should be restarted to apply properties changes.");
        this.syntax.addCompletionCommand("list advanced properties");
    }

    static BlockModifier createAdvancedPropertyBlockModifier(boolean withCompleter) {
        ExpressionParameter nameParameter = new ExpressionParameter("name");
        if (withCompleter) {
            nameParameter.setCompletionAdviser(new AdvancedPropertyNameAdviser());
        }
        return (BlockModifier)new BlockModifier("", "advancedPropertyBlockModifier").addModifier(new CompoundModifier("advancedPropertyCompoundModifier").addParameter(nameParameter).addModifier(new Modifier("=", "equals")).addParameter(new StringParameter("value"))).setSyntaxHint(SyntaxHint.SPACE);
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        StatementValueList line = statement.getBlock("advancedPropertyBlockModifier").getLineByIndex(0);
        return new Definition(line.getParameter("name").getValue(), line.getParameter("value").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, ((ServiceContext)this.callable).getServiceConfiguration().getServiceName(), ((ServiceContext)this.callable).getServiceConfiguration().getServiceType(), true);
        ConfigurationProperty property = sco.getAdvancedProperty(definition.propertyName);
        if (property == null) {
            throw new Exception("Property '" + definition.propertyName + "' doesn't exist.");
        }
        String propertyValue = definition.propertyValue.toString();
        if (propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false")) {
            property.setBooleanValue(Boolean.valueOf(propertyValue));
        } else {
            try {
                Long longValue = Long.valueOf(propertyValue);
                property.setNumericValue(longValue);
            }
            catch (NumberFormatException error) {
                property.setTextValue(propertyValue);
            }
        }
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        return new SLResponse();
    }

    private static class AdvancedPropertyNameAdviser
    implements CompletionAdviser<ServiceContext> {
        private AdvancedPropertyNameAdviser() {
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, ServiceContext callable, MFSession session) {
            ArrayList<String> completions = new ArrayList<String>();
            for (ConfigurationProperty property : callable.getServiceConfiguration().getAdvancedProperties()) {
                completions.add(property.getName());
            }
            return completions;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    static class Definition
    extends AbstractSLStatement {
        String propertyName;
        String propertyValue;

        Definition(String propertyName, String propertyValue) {
            super(SetAdvancedPropertyOperation.NAME);
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }
    }
}

