/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.impl.SetPropertyOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.SyntaxParameter;

public class RemovePropertyOperation
extends AbstractServiceOperation {
    public static final String NAME = "remove property";

    public RemovePropertyOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REMOVE PROPERTY").addActionParameter((SyntaxParameter)((ExpressionParameter)new ExpressionParameter("name").setExcludedDelimiters("[]/.")).setCompletionAdviser(new SetPropertyOperation.PropertyNameAdviser()));
        this.syntax.setDescription("Removes the specified property.\nService should be restarted to apply properties changes.");
        this.syntax.setExamples("remove property directories.inbound");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("name").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ServiceConfigurationObject sco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, ((ServiceContext)this.callable).getServiceConfiguration().getServiceName(), ((ServiceContext)this.callable).getServiceConfiguration().getServiceType(), true);
        sco.removeProperty(definition.propertyName);
        ServiceConfigurationFactory.saveConfigurationObject(sco);
        return new SLResponse();
    }

    static class Definition
    extends AbstractSLStatement {
        String propertyName;

        Definition(String propertyName) {
            super(RemovePropertyOperation.NAME);
            this.propertyName = propertyName;
        }
    }
}

