/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractPackageOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class RegisterPackageOperation
extends AbstractPackageOperation {
    public static final String NAME = "register package";

    public RegisterPackageOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("REGISTER PACKAGE").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new AbstractPackageOperation.PackageAutoloadModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageSequenceModifier());
        this.syntax.setDescription("Registers the specified package in the Service Package Manifest.\n" + RegisterPackageOperation.getSupportedTypes());
        this.syntax.setExamples("register package service.TestPackage \nregister package service.TestPackage autoload true\nregister package service.TestPackage autoload true sequence 1");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseManifestSyntax(statement, null);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillAllPackages(completions);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        Package pkg = RuntimeContext.getInstance().getRepositoryAccessor().getPackage(RegisterPackageOperation.getType(definition.getPackageType()), definition.getPackageName());
        PackageDescriptor descriptor = PackageDescriptor.create(pkg, definition.isAutoload(), false);
        if (definition.getSequence() != -1) {
            ((ServiceContext)this.callable).getPackageManifestManager().addPackageAt(definition.getSequence(), descriptor);
        } else {
            ((ServiceContext)this.callable).getPackageManifestManager().addPackage(descriptor);
        }
        return new SLResponse();
    }

    @Override
    protected AbstractPackageOperation.ManifestDefinition createManifestDefinition(String packageType, String packageName) {
        return new Definition(packageType, packageName);
    }

    public static class Definition
    extends AbstractPackageOperation.ManifestDefinition {
        public Definition(String packageType, String packageName) {
            super(RegisterPackageOperation.NAME, packageType, packageName);
        }

        public Definition(String packageType, String packageName, boolean autoload, int sequence) {
            super(RegisterPackageOperation.NAME, packageType, packageName, autoload, sequence);
        }

        @Override
        public boolean isAutoload() {
            return this.autoload == null ? true : this.autoload;
        }
    }
}

