/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.lib.utils.MacroProcessor;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.service.osf.config.AbstractFactoryPropertyValue;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.PasswordPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.SyntaxHint;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class ListPropertiesOperation
extends AbstractServiceOperation {
    public static final String NAME = "list properties";

    public ListPropertiesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST PROPERTIES");
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier("RESOLVE").setRequired(false)).setSyntaxHint(SyntaxHint.SPACE));
        this.syntax.setDescription("Shows service properties.\nFor Factory and Object properties type is displayed in Type column and name displayed in value column.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getModifier("RESOLVE").isPresent());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        ServiceConfigurationObject runningSco = ((ServiceContext)this.callable).getServiceConfiguration();
        ServiceConfigurationObject savedSco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, runningSco.getServiceName(), runningSco.getServiceType(), true);
        RowSet result = new RowSet(ListPropertiesOperation.createResultDescriptor());
        for (ServiceConfigurationProperty savedProperty : savedSco.getProperties()) {
            boolean modified;
            Object savedValueRaw;
            ServiceConfigurationProperty runningProperty = runningSco.getPropertyNames().contains(savedProperty.getName()) ? runningSco.getProperty(savedProperty.getName()) : null;
            Object object = savedValueRaw = ((Definition)definition).isResolve() ? savedProperty.getValue() : savedProperty.getRawValue();
            Object runningValueRaw = runningProperty != null ? (((Definition)definition).isResolve() ? runningProperty.getValue() : runningProperty.getRawValue()) : null;
            String savedValue = savedValueRaw != null ? savedValueRaw.toString() : "null";
            String runningValue = runningValueRaw != null ? runningValueRaw.toString() : "null";
            boolean bl = modified = !runningValue.equals(savedValue);
            if (savedProperty.getType() == ServicePropertyType.PASSWORD) {
                if (runningValueRaw == null) {
                    runningValueRaw = new PasswordPropertyValue("");
                }
                if (savedValueRaw != null && ((PasswordPropertyValue)savedValueRaw).getPassword().length() == 0) {
                    savedValue = "";
                }
                if (runningValueRaw != null && ((PasswordPropertyValue)runningValueRaw).getPassword().length() == 0) {
                    runningValue = "";
                }
                String value1 = savedValueRaw != null ? ((PasswordPropertyValue)savedValueRaw).getPassword() : "null";
                String value2 = runningValueRaw != null ? ((PasswordPropertyValue)runningValueRaw).getPassword() : "null";
                boolean bl2 = modified = !value1.equals(value2);
                if (MacroProcessor.isGlobalVariable(value1)) {
                    savedValue = value1;
                }
                if (MacroProcessor.isGlobalVariable(value2)) {
                    runningValue = value2;
                }
            }
            Object type = savedProperty.getType().toString();
            if (savedProperty.getType() == ServicePropertyType.JDBC_FACTORY || savedProperty.getType() == ServicePropertyType.TRANSPORT_FACTORY || savedProperty.getType() == ServicePropertyType.CLIENT_FACTORY || savedProperty.getType() == ServicePropertyType.OBJECT) {
                Object subType = null;
                switch (savedProperty.getType()) {
                    case JDBC_FACTORY: 
                    case TRANSPORT_FACTORY: 
                    case CLIENT_FACTORY: {
                        Object value = (AbstractFactoryPropertyValue)savedProperty.getDefault();
                        if (value == null || ((AbstractFactoryPropertyValue)value).getFactoryType().length() == 0) {
                            value = (AbstractFactoryPropertyValue)savedValueRaw;
                        }
                        if (value != null) {
                            subType = ((AbstractFactoryPropertyValue)value).getFactoryType();
                        }
                        savedValue = savedValueRaw != null ? ((AbstractFactoryPropertyValue)savedValueRaw).getFactoryName() : "null";
                        runningValue = runningValueRaw != null ? ((AbstractFactoryPropertyValue)runningValueRaw).getFactoryName() : "null";
                        break;
                    }
                    case OBJECT: {
                        Object value = (ObjectPropertyValue)savedProperty.getDefault();
                        if (value == null || ((ObjectPropertyValue)value).getObjectType().length() == 0) {
                            value = (ObjectPropertyValue)savedValueRaw;
                        }
                        if (value != null) {
                            subType = ((ObjectPropertyValue)value).getReferenceContext().getContextNameSpace() + "," + ((ObjectPropertyValue)value).getObjectType();
                        }
                        savedValue = savedValueRaw != null ? ((ObjectPropertyValue)savedValueRaw).getObjectName() : "null";
                        runningValue = runningValueRaw != null ? ((ObjectPropertyValue)runningValueRaw).getObjectName() : "null";
                        break;
                    }
                }
                if (subType == null || ((String)subType).length() == 0) {
                    subType = "UNKNOWN TYPE";
                }
                type = (String)type + "(" + (String)subType + ")";
            }
            result.addToRowSet(new Object[]{savedProperty.getName(), type, runningValue, savedValue, modified});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListPropertiesOperation.addColumn(result, "Name");
        ListPropertiesOperation.addColumn(result, "Type");
        ListPropertiesOperation.addColumn(result, "Running Value");
        ListPropertiesOperation.addColumn(result, "Saved Value");
        ListPropertiesOperation.addColumn(result, "Modified");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        boolean resolve = false;

        Definition(boolean resolve) {
            super(ListPropertiesOperation.NAME);
            this.resolve = resolve;
        }

        boolean isResolve() {
            return this.resolve;
        }
    }
}

