/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.metrics.Metric;
import com.streamscape.sef.metrics.MetricsFactory;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.operation.ListMetricsOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListMetricsOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "list metrics";

    public ListMetricsOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST METRICS");
        this.syntax.setDescription("Returns list of metrics.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new ListMetricsOperation();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListMetricsOperationImpl.createResultDescriptor());
        MetricsFactory metricsFactory = ((ServiceContext)this.callable).getMetricsFactory();
        for (String metricName : metricsFactory.listMetricNames()) {
            Metric metric = metricsFactory.getMetric(metricName);
            result.addToRowSet(new Object[]{metricName, metric.getMinThreshold(), metric.getMaxThreshold(), metric.getValue(), metric.getUnits().name()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListMetricsOperationImpl.addColumn(result, "Name");
        ListMetricsOperationImpl.addColumn(result, "MIN");
        ListMetricsOperationImpl.addColumn(result, "MAX");
        ListMetricsOperationImpl.addColumn(result, "Current");
        ListMetricsOperationImpl.addColumn(result, "Units");
        return result;
    }
}

