/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import java.util.List;

public class ListEventsOperation
extends AbstractServiceOperation {
    public static final String NAME = "list events";

    public ListEventsOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST EVENTS");
        this.syntax.setDescription("Returns list of events which service uses.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        return ListEventsOperation.createSLResponse(((ServiceContext)this.callable).listActiveEvents());
    }

    public static SLResponse createSLResponse(List<ActiveEvent> activeEvents) throws Exception {
        RowSet rowSet = new RowSet(ListEventsOperation.createResultDescriptor());
        for (ActiveEvent activeEvent : activeEvents) {
            rowSet.addToRowSet(new Object[]{activeEvent.getEventId(), activeEvent.getType(), activeEvent.getEventScope() != null ? activeEvent.getEventScope() : "-", activeEvent.getSelector() != null ? activeEvent.getSelector() : "-", activeEvent.getTrigger() != null ? activeEvent.getTrigger() : "-", activeEvent.getEventModel()});
        }
        return new SLResponse(rowSet);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListEventsOperation.addColumn(result, "Event Id");
        ListEventsOperation.addColumn(result, "Event Type");
        ListEventsOperation.addColumn(result, "Event Scope");
        ListEventsOperation.addColumn(result, "Event Selector");
        ListEventsOperation.addColumn(result, "Trigger");
        ListEventsOperation.addColumn(result, "Event Model");
        return result;
    }

    public class Definition
    extends AbstractSLStatement {
        public Definition() {
            super(ListEventsOperation.NAME);
        }

        @Override
        public String getName() {
            return ListEventsOperation.NAME;
        }
    }
}

