/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.operation.ListEventTriggersOperation;
import com.streamscape.service.osf.config.EventTriggerData;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListEventTriggersOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "list event triggers";

    public ListEventTriggersOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST EVENT TRIGGERS");
        this.syntax.setAlias("LIST TRIGGERS");
        this.syntax.setDescription("Returns list of event triggers.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new ListEventTriggersOperation();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListEventTriggersOperationImpl.createResultDescriptor());
        EventTriggerManagerDelegate triggerManagerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        for (String triggerName : triggerManagerDelegate.listEventTriggers()) {
            String lastError = triggerManagerDelegate.getLastError(triggerName);
            if (lastError == null) {
                lastError = "---";
            }
            EventTriggerData triggerData = triggerManagerDelegate.getEventTriggerData(triggerName);
            EventTriggerState triggerState = triggerManagerDelegate.getTriggerState(triggerName);
            TriggerActionTime triggerActionTime = triggerManagerDelegate.getTriggerActionTime(triggerName);
            if (triggerData == null) {
                triggerState = EventTriggerState.INVALID;
            } else if (!triggerData.isAutoEnable()) {
                triggerState = EventTriggerState.DISABLED;
            }
            result.addToRowSet(new Object[]{triggerName, triggerActionTime != null ? triggerActionTime : "UNKNOWN", triggerState != null ? triggerState.name() : "UNKNOWN", lastError});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListEventTriggersOperationImpl.addColumn(result, "Event Trigger");
        ListEventTriggersOperationImpl.addColumn(result, "Trigger Condition");
        ListEventTriggersOperationImpl.addColumn(result, "State");
        ListEventTriggersOperationImpl.addColumn(result, "Last Error");
        return result;
    }
}

