/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.operation.ListEventHandlersOperation;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListEventHandlersOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "list event handlers";

    public ListEventHandlersOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST EVENT HANDLERS");
        this.syntax.setDescription("Returns list of event handlers.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new ListEventHandlersOperation();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(ListEventHandlersOperationImpl.createResultDescriptor());
        ServiceContext handlersSource = (ServiceContext)this.callable;
        for (String handlerName : handlersSource.listEventHandlers()) {
            EventHandler handler = handlersSource.getEventHandler(handlerName);
            result.addToRowSet(new Object[]{handlerName, handler.getRequestEventId(), handler.getResponseEventId()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        ListEventHandlersOperationImpl.addColumn(result, "Event Handler");
        ListEventHandlersOperationImpl.addColumn(result, "Request Event Id");
        ListEventHandlersOperationImpl.addColumn(result, "Response Event Id");
        return result;
    }
}

