/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class ListAdvancedPropertiesOperation
extends AbstractServiceOperation {
    public static final String NAME = "list advanced properties";

    public ListAdvancedPropertiesOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST ADVANCED PROPERTIES");
        this.syntax.setDescription("Shows service advanced properties.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        ServiceConfigurationObject runningSco = ((ServiceContext)this.callable).getServiceConfiguration();
        ServiceConfigurationObject savedSco = ServiceConfigurationFactory.loadConfigurationObject((FabricComponent)this.callable, runningSco.getServiceName(), runningSco.getServiceType(), true);
        RowSet result = new RowSet(ListAdvancedPropertiesOperation.createResultDescriptor());
        for (ConfigurationProperty savedProperty : savedSco.getAdvancedProperties()) {
            ConfigurationProperty runningProperty = runningSco.getAdvancedProperty(savedProperty.getName());
            Object savedValueRaw = savedProperty.getValue();
            Object runningValueRaw = runningProperty != null ? runningProperty.getValue() : "not applied yet";
            String savedValue = savedValueRaw != null ? savedValueRaw.toString() : "null";
            String runningValue = runningValueRaw != null ? runningValueRaw.toString() : "null";
            boolean modified = !runningValue.equals(savedValue);
            result.addToRowSet(new Object[]{savedProperty.getName(), savedProperty.getValueClass() != null ? savedProperty.getValueClass().getSimpleName() : "N/A", runningValue, savedValue, modified});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        ListAdvancedPropertiesOperation.addColumn(result, "Name");
        ListAdvancedPropertiesOperation.addColumn(result, "Type");
        ListAdvancedPropertiesOperation.addColumn(result, "Running Value");
        ListAdvancedPropertiesOperation.addColumn(result, "Saved Value");
        ListAdvancedPropertiesOperation.addColumn(result, "Modified");
        return result;
    }

    static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(ListAdvancedPropertiesOperation.NAME);
        }
    }
}

