/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.operation.DropEventTriggerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DropEventTriggerOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "drop event trigger";

    public DropEventTriggerOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DROP EVENT TRIGGER").addActionParameter(new IdentifierParameter("TriggerName"));
        this.syntax.setDescription("Drops event trigger.");
        this.syntax.addCompletionCommand("list event triggers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new DropEventTriggerOperation(statement.getParameter("TriggerName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        EventTriggerManagerDelegate triggerManagerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        completions.addAll(triggerManagerDelegate.listEventTriggers());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DropEventTriggerOperation operation = (DropEventTriggerOperation)definition;
        EventTriggerManagerDelegate triggerManagerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        triggerManagerDelegate.removeEventTrigger(operation.getTriggerName());
        return new SLResponse("Event trigger '" + operation.getTriggerName() + "' was dropped.");
    }
}

