/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.operation.DisableEventTriggerOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DisableEventTriggerOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "disable event trigger";

    public DisableEventTriggerOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DISABLE EVENT TRIGGER").addActionParameter(new IdentifierParameter("TriggerName"));
        this.syntax.setDescription("If service is running sets autoenable to false and disables a trigger with a given name, halting event processing.\nIf service is not running only sets autoenable to false.");
        this.syntax.addCompletionCommand("list event triggers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new DisableEventTriggerOperation(statement.getParameter("TriggerName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        EventTriggerManagerDelegate triggerManagerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        completions.addAll(triggerManagerDelegate.listEventTriggers());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        EventTriggerManagerDelegate triggerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        DisableEventTriggerOperation operation = (DisableEventTriggerOperation)definition;
        if (triggerDelegate.existsEventTrigger(operation.getTriggerName())) {
            triggerDelegate.disableEventTrigger(operation.getTriggerName());
            return new SLResponse("Trigger '" + operation.getTriggerName() + "' has been disabled.");
        }
        return new SLResponse("Specified trigger '" + operation.getTriggerName() + "' does not exist.", false);
    }
}

