/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractPackageOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class DescribePackageManifestOperation
extends AbstractPackageOperation {
    public static final String NAME = "describe package manifest";

    public DescribePackageManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE PACKAGE MANIFEST");
        this.syntax.setDescription("Shows a list of all packages registered in Service Package Manifest.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        RowSet result = new RowSet(DescribePackageManifestOperation.createResultDescriptor());
        PackageManifestManager manifestManager = ((ServiceContext)this.callable).getPackageManifestManager();
        for (String pkgName : manifestManager.listPackages()) {
            PackageDescriptor pkg = manifestManager.getPackage(pkgName);
            result.addToRowSet(new Object[]{pkgName, manifestManager.isPackageLoaded(pkgName), pkg.isValid()});
        }
        return new SLResponse(result);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DescribePackageManifestOperation.addColumn(result, "Package Name");
        DescribePackageManifestOperation.addColumn(result, "Loaded");
        DescribePackageManifestOperation.addColumn(result, "Valid");
        return result;
    }

    public static class Definition
    extends AbstractPackageOperation.ManifestDefinition {
        public Definition() {
            super(DescribePackageManifestOperation.NAME, null, null);
        }
    }
}

