/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.Trace;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.EventTriggerState;
import com.streamscape.sef.evtrigger.EventTriggerCompiledDefinition;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.evtrigger.TriggerActionTime;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.impl.CreateEventTriggerOperationImpl;
import com.streamscape.sef.service.mf.operation.DescribeEventTriggerOperation;
import com.streamscape.service.osf.config.ActiveEvent;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.lexer.BufferUtils;
import java.util.List;

public class DescribeEventTriggerOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "describe event trigger";

    public DescribeEventTriggerOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE EVENT TRIGGER").addActionParameter(new IdentifierParameter("TriggerName"));
        this.syntax.addModifier((AbstractModifier)new ChoiceModifier("mode").addPossibleValues(DescribeMode.class).setRequired(false));
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier("comment").addModifier((AbstractModifier)new Modifier("NO COMMENT").setName("noComment"))).addModifier((AbstractModifier)new Modifier("NO DOC").setName("nodoc"))).setRequired(false));
        this.syntax.setDescription("Provides information about the specified event trigger.");
        this.syntax.addCompletionCommand("list event triggers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        DescribeMode mode = DescribeMode.DEFINITION;
        if (statement.getModifier("mode").isPresent()) {
            mode = DescribeMode.valueOf(statement.getModifier("mode").getToken().toUpperCase());
        }
        return new DescribeEventTriggerOperation(statement.getParameter("TriggerName").getValue(), mode, statement.getModifier("noComment").isPresent(), statement.getModifier("nodoc").isPresent());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        EventTriggerManagerDelegate triggerManagerDelegate = (EventTriggerManagerDelegate)((Object)this.callable);
        completions.addAll(triggerManagerDelegate.listEventTriggers());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        DescribeEventTriggerOperation operation = (DescribeEventTriggerOperation)definition;
        if (((ServiceContext)this.callable).existsEventTrigger(operation.getTriggerName())) {
            RowSet result = null;
            EventTriggerDefinition trigger = this.getOrCreateEventTriggerDefinition(operation);
            switch (operation.getMode().ordinal()) {
                case 2: {
                    result = new RowSet(DescribeEventTriggerOperationImpl.createResultDescriptorSimple("Body"));
                    result.addToRowSet(new Object[]{this.removeComments(trigger.getTriggerScript(), operation)});
                    break;
                }
                case 0: 
                case 1: {
                    result = new RowSet(DescribeEventTriggerOperationImpl.createResultDescriptorSimple("Definition"));
                    result.addToRowSet(new Object[]{this.removeComments(trigger.getFullSyntax(), operation)});
                    break;
                }
                case 4: {
                    result = new RowSet(DescribeEventTriggerOperationImpl.createResultDescriptorSimple("Doc"));
                    result.addToRowSet(new Object[]{BufferUtils.extractUnwrappedJavaDoc(trigger.getFullSyntax())});
                    break;
                }
                case 3: {
                    Object eventId;
                    result = new RowSet(DescribeEventTriggerOperationImpl.createResultDescriptorEvents());
                    Object selector = trigger.getEventSelector();
                    if (selector == null || ((String)selector).length() == 0) {
                        selector = "x";
                    }
                    if (trigger.getTriggerActionTime() == TriggerActionTime.BEFORE) {
                        EventHandler handler = ((ServiceContext)this.callable).getEventHandler(trigger.getEventHandlerName());
                        if (((String)selector).equals("x")) {
                            selector = handler.getRequestSelector();
                        } else if (handler.getRequestSelector() != null && handler.getRequestSelector().length() > 0) {
                            selector = "(" + handler.getRequestSelector() + ") && (" + (String)selector + ")";
                        }
                        if (selector == null || ((String)selector).length() == 0) {
                            selector = "x";
                        }
                        eventId = handler.getRequestEventId();
                    } else {
                        eventId = trigger.getActionableEventId();
                    }
                    result.addToRowSet(new Object[]{StringUtils.wrapEventId((String)eventId), ActiveEvent.ActiveEventType.Actionable.toString(), selector, this.resolveEventModel((String)eventId)});
                    if (!(trigger instanceof EventTriggerCompiledDefinition)) break;
                    for (String eventId2 : ((EventTriggerCompiledDefinition)trigger).getRaisedEventIds()) {
                        result.addToRowSet(new Object[]{StringUtils.wrapEventId(eventId2), ActiveEvent.ActiveEventType.Source.toString(), selector, this.resolveEventModel(eventId2)});
                    }
                    break;
                }
                case 5: {
                    String lastError;
                    EventTriggerManagerDelegate delegate;
                    EventTriggerState triggerState;
                    result = new RowSet(DescribeEventTriggerOperationImpl.createResultDescriptorProperties());
                    String eventIds = "trigger not compiled";
                    String advisoryCapable = "trigger not compiled";
                    if (trigger instanceof EventTriggerCompiledDefinition) {
                        eventIds = ((EventTriggerCompiledDefinition)trigger).getRaisedEventIds().toString();
                        advisoryCapable = Boolean.toString(((EventTriggerCompiledDefinition)trigger).isAdvisoryCapable());
                    }
                    if ((triggerState = (delegate = (EventTriggerManagerDelegate)((Object)this.callable)).getTriggerState(operation.getTriggerName())) == null) {
                        triggerState = EventTriggerState.NOT_INITIALIZED;
                    }
                    if ((lastError = delegate.getLastError(operation.getTriggerName())) == null) {
                        lastError = "---";
                    }
                    result.addToRowSet(new Object[]{"Name", operation.getTriggerName()});
                    result.addToRowSet(new Object[]{"Event Scope", trigger.getEventScope()});
                    result.addToRowSet(new Object[]{"Trigger Condition", trigger.getTriggerActionTime().toString()});
                    result.addToRowSet(new Object[]{"Event Handler Name", trigger.getEventHandlerName() != null ? trigger.getEventHandlerName() : "none"});
                    result.addToRowSet(new Object[]{"Actionable Event", StringUtils.wrapEventId(trigger.getActionableEventId())});
                    result.addToRowSet(new Object[]{"Source Events", eventIds});
                    result.addToRowSet(new Object[]{"Advisory Capable", advisoryCapable});
                    result.addToRowSet(new Object[]{"RPL Expression", trigger.getEventSelector() != null ? trigger.getEventSelector() : "none"});
                    result.addToRowSet(new Object[]{"State", triggerState});
                    result.addToRowSet(new Object[]{"Last Error", lastError});
                    break;
                }
            }
            return new SLResponse(result);
        }
        return new SLResponse("Specified trigger '" + operation.getTriggerName() + "' does not exist.", false);
    }

    private EventTriggerDefinition getOrCreateEventTriggerDefinition(DescribeEventTriggerOperation operation) throws Exception {
        EventTriggerDefinition trigger = ((EventTriggerManagerDelegate)((Object)this.callable)).getEventTriggerDefinition(operation.getTriggerName());
        if (trigger == null) {
            DSLStatement statement = new CreateEventTriggerOperationImpl().parseDsl(((EventTriggerManagerDelegate)((Object)this.callable)).getEventTriggerSyntax(operation.getTriggerName()));
            trigger = CreateEventTriggerOperationImpl.parseEventTriggerSlangDefinition(statement);
        }
        return trigger;
    }

    private String removeComments(String syntax, DescribeEventTriggerOperation operation) {
        if (operation.isNoComment()) {
            syntax = BufferUtils.removeComments(syntax);
        } else if (operation.isNodoc()) {
            syntax = BufferUtils.removeJavaDoc(syntax);
        }
        return syntax;
    }

    static RowMetaData createResultDescriptorProperties() {
        RowMetaData result = new RowMetaData(10);
        DescribeEventTriggerOperationImpl.addColumn(result, "Property");
        DescribeEventTriggerOperationImpl.addColumn(result, "Value");
        return result;
    }

    static RowMetaData createResultDescriptorEvents() {
        RowMetaData result = new RowMetaData();
        DescribeEventTriggerOperationImpl.addColumn(result, "Event");
        DescribeEventTriggerOperationImpl.addColumn(result, "Type");
        DescribeEventTriggerOperationImpl.addColumn(result, "Selector");
        DescribeEventTriggerOperationImpl.addColumn(result, "Model");
        return result;
    }

    private static RowMetaData createResultDescriptorSimple(String name) {
        RowMetaData result = new RowMetaData(10);
        DescribeEventTriggerOperationImpl.addColumn(result, name);
        return result;
    }

    private Object resolveEventModel(String eventId) {
        try {
            return RuntimeContext.getInstance().getDatagramPrototypeCache().getModel(eventId);
        }
        catch (DatagramFactoryException e) {
            Trace.logDebug(this, "Event model not found for event [" + eventId + "]. Cause: " + e.getMessage());
            return "Unknown";
        }
    }

    public static enum DescribeMode {
        DEF,
        DEFINITION,
        BODY,
        EVENTS,
        DOC,
        PROPERTIES;

    }
}

