/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.lib.utils.StringUtils;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.sef.service.mf.operation.DescribeEventHandlerOperation;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import java.util.List;

public class DescribeEventHandlerOperationImpl
extends AbstractServiceOperation {
    public static final String NAME = "describe event handler";

    public DescribeEventHandlerOperationImpl() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE EVENT HANDLER").addActionParameter(new IdentifierParameter("HandlerName"));
        this.syntax.setDescription("Provides meta information about the specified event handler.");
        this.syntax.addCompletionCommand("list event handlers");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new DescribeEventHandlerOperation(statement.getParameter("HandlerName").getValue());
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        completions.addAll(((ServiceContext)this.callable).listEventHandlers());
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        RowSet result = new RowSet(DescribeEventHandlerOperationImpl.createResultDescriptor());
        ServiceContext handlersSource = (ServiceContext)this.callable;
        DescribeEventHandlerOperation operation = (DescribeEventHandlerOperation)definition;
        if (handlersSource.existsEventHandler(operation.getHandlerName())) {
            EventHandler handler = handlersSource.getEventHandler(operation.getHandlerName());
            result.addToRowSet(new Object[]{"Handler Name", handler.getHandlerName()});
            result.addToRowSet(new Object[]{"Method Name", handler.getMethodName()});
            result.addToRowSet(new Object[]{"Request EventId", StringUtils.wrapEventId(handler.getRequestEventId())});
            String selector = handler.getRequestSelector();
            if (selector != null) {
                result.addToRowSet(new Object[]{"Request Selector", handler.getRequestSelector()});
            }
            result.addToRowSet(new Object[]{"Request Type", handler.getRequestSemanticType()});
            result.addToRowSet(new Object[]{"Request SDR Path", handler.getRequestSDRPath()});
            result.addToRowSet(new Object[]{"Response EventId", StringUtils.wrapEventId(handler.getResponseEventId())});
            result.addToRowSet(new Object[]{"Response Type", handler.getResponseSemanticType()});
            return new SLResponse(result);
        }
        return new SLResponse("Specified handler '" + operation.getHandlerName() + "' does not exist.", false);
    }

    static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData(10);
        DescribeEventHandlerOperationImpl.addColumn(result, "Property");
        DescribeEventHandlerOperationImpl.addColumn(result, "Value");
        return result;
    }
}

