/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventTriggerManagerDelegate;
import com.streamscape.sef.evtrigger.EventTriggerDefinition;
import com.streamscape.sef.service.mf.impl.AbstractAlterCreateEventTriggerOperationImpl;
import com.streamscape.sef.service.mf.operation.CreateEventTriggerOperation;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.slex.MFSession;
import com.streamscape.tools.parser.AbstractParserException;

public class CreateEventTriggerOperationImpl
extends AbstractAlterCreateEventTriggerOperationImpl {
    public static final String NAME = "create event trigger";

    public CreateEventTriggerOperationImpl() {
        super(NAME, "Creates and compiles new event trigger on the specified component.\nSee RPL syntax specification in corresponding docs.\n\nJavadoc can be defined anywhere in command, preferable at the beginning and should be enclosed in /** and */.\nJavadoc extends standard html tags with the following tags:\n\n   Links:\n      {@link type#<typename>}                                               - Link to semantic type with specified name.\n      {@link prototype#<eventId>}                                           - Link to event prototype with specified eventId.\n      {@link service#<ServiceType>.<ServiceName>}                           - Link to service with specified type and name.\n      {@link handler#<ServiceType>.<ServiceName>.<HandlerName>}             - Link to service event handler with specified type and name.\n      {@link collection#[<DataspaceType>].<DataspaceName>.<CollectionName>} - Link to collection in specified dataspace. Default dataspace type is TSPACE.\n      {@link function#[<DataspaceType>].<DataspaceName>.<FunctionName>}     - Link to function in specified dataspace. Default dataspace type is TSPACE.\n\n   Code tag:\n      {@code <some code>} - Formats specified code with specific font.\n\n   Tags, in order they will be in result html:\n      @author <authors>              - Authors in javadoc style.\n      @version <version>             - Version in javadoc style.\n      @copyright <copyright>         - Copyright in javadoc style.\n      @since <since version or date> - Since in javadoc style.\n      @see <link>                    - See also in javadoc style.\n      @anytag <any text>             - Any tag.\n      @raises <events>               - Raises events.\n      @todo <what todo>              - Todo.\n\n    NOTE: Tags should be located at the end of javadoc. One tag ends where another tag starts.\n");
        this.syntax.setExamples(CreateEventTriggerOperationImpl.getEventTriggerSamples());
    }

    @Override
    protected SLStatement createEventTriggerOperation(EventTriggerDefinition definition) {
        return new CreateEventTriggerOperation(definition);
    }

    @Override
    public SLResponse invoke(SLStatement definition, MFSession session, long timeout) throws Exception {
        EventTriggerDefinition triggerDefinition = ((CreateEventTriggerOperation)definition).getTriggerDefinition();
        EventTriggerManagerDelegate delegate = (EventTriggerManagerDelegate)((Object)this.callable);
        try {
            delegate.addEventTrigger(triggerDefinition.getFullSyntax());
        }
        catch (ServiceConfigurationException exception) {
            if (exception.getCause() instanceof AbstractParserException) {
                throw (AbstractParserException)exception.getCause();
            }
            throw exception;
        }
        return new SLResponse("Trigger '" + triggerDefinition.getName() + "' successfully created.");
    }
}

