/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.service.mf.impl;

import com.streamscape.runtime.mf.operation.pkg.AbstractPackageOperation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractPackageOperation;
import com.streamscape.sef.service.mf.impl.RegisterPackageOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.util.List;

public class AlterPackageManifestOperation
extends AbstractPackageOperation {
    public static final String NAME = "alter package manifest";

    public AlterPackageManifestOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("ALTER PACKAGE MANIFEST").addActionParameter(new AbstractPackageOperation.PackageTypeNameParameter());
        this.syntax.addModifier(new AbstractPackageOperation.PackageAutoloadModifier());
        this.syntax.addModifier(new AbstractPackageOperation.PackageSequenceModifier());
        this.syntax.setDescription("Alters the specified package in the Service Package Manifest.\n" + AlterPackageManifestOperation.getSupportedTypes());
        this.syntax.setExamples("alter package manifest service.TestPackage autoload true\nalter package manifest service.TestPackage sequence 1\nalter package manifest service.TestPackage autoload true sequence 1");
        this.syntax.addCompletionCommand("list packages");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return this.parseManifestSyntax(statement, null);
    }

    @Override
    protected void doFillCompletionsList(DSLStatementSyntax.DSLStatementCompletion comp, MFSession session, List<String> completions) {
        this.fillAllPackages(completions);
    }

    @Override
    protected AbstractPackageOperation.ManifestDefinition createManifestDefinition(String packageType, String packageName) {
        return new RegisterPackageOperation.Definition(packageType, packageName);
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        String fullPackageName = definition.getPackageType() + "." + definition.getPackageName();
        PackageDescriptor pkg = ((ServiceContext)this.callable).getPackageManifestManager().getPackage(fullPackageName);
        if (pkg == null) {
            return new SLResponse("Package '" + fullPackageName + "' is not registered in manifest.", false);
        }
        ((ServiceContext)this.callable).getPackageManifestManager().removePackage(fullPackageName);
        if (definition.autoload != null) {
            pkg.setAutoload(definition.isAutoload());
        }
        if (definition.getSequence() != -1) {
            ((ServiceContext)this.callable).getPackageManifestManager().addPackageAt(definition.getSequence(), pkg);
        } else {
            ((ServiceContext)this.callable).getPackageManifestManager().addPackage(pkg);
        }
        return new SLResponse();
    }

    public static class Definition
    extends AbstractPackageOperation.ManifestDefinition {
        public Definition(String packageType, String packageName) {
            super(AlterPackageManifestOperation.NAME, packageType, packageName);
        }

        public Definition(String packageType, String packageName, boolean autoload, int sequence) {
            super(AlterPackageManifestOperation.NAME, packageType, packageName, autoload, sequence);
        }
    }
}

